/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.dmx.fixtures;

import com.integpg.dmx.fixtures.FixtureType;
import com.integpg.janoslib.logging.AppLog;
import com.integpg.janoslib.text.QuickDateFormat;
import com.integpg.janoslib.utils.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Json;

public class FixtureTypeFile {
    private static final QuickDateFormat QDF = new QuickDateFormat("hh:mm:ss.fff");
    public long LastModifiedTime = 0L;
    private final String _filename;
    private final File _file;
    private ArrayList<FixtureType> _fixtureTypes = new ArrayList();

    FixtureTypeFile(File file) {
        this._file = file;
        this._filename = file.getPath();
    }

    String getFilename() {
        return this._file.getPath();
    }

    void process() {
        try {
            Json[] fixtureTypeArray;
            this.LastModifiedTime = this._file.lastModified();
            String fileContent = FileUtils.readAllText(this._filename);
            Json fileJson = new Json(fileContent);
            for (Json fixtureTypeJson : fixtureTypeArray = (Json[])fileJson.get("FixtureTypes")) {
                System.out.println("   " + fixtureTypeJson);
                FixtureType fixtureType = new FixtureType(fixtureTypeJson);
                this._fixtureTypes.add(fixtureType);
            }
            AppLog.info("loaded fixture type " + this._filename);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            AppLog.error("error loading fixture type " + this._filename, ex);
        }
    }

    public ArrayList<FixtureType> getFixtureTypes() {
        return this._fixtureTypes;
    }
}

