/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.dmx;

import com.integpg.dmx.DmxMain;
import com.integpg.dmx.UdpConnectionListener;
import com.integpg.dmx.client.IClient;
import com.integpg.janoslib.logging.AppLog;
import com.integpg.janoslib.system.UnitConfig;
import com.integpg.janoslib.utils.HexUtils;
import com.integpg.system.ArrayUtils;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;

public class ArtNet
implements UdpConnectionListener {
    private static final byte[] ArtNet = "Art-Net\u0000".getBytes();
    private byte[] dmxBytes = new byte[512];

    @Override
    public void processMessage(IClient client, DatagramSocket socket, DatagramPacket packet) {
        byte[] data = packet.getData();
        int length = packet.getLength();
        if (!ArrayUtils.arrayComp((Object)ArtNet, (int)0, (Object)data, (int)0, (int)8)) {
            throw new RuntimeException("Not Art-Net");
        }
        short opCode = ArrayUtils.getShort((byte[])data, (int)8);
        opCode = ArrayUtils.swapEndian((short)opCode);
        switch (opCode) {
            case 8192: {
                this.processArtNetPoll(socket, packet);
                break;
            }
            case 20480: {
                ArrayUtils.arraycopy((Object)data, (int)18, (Object)this.dmxBytes, (int)0, (int)(length - 18));
                this.processArtNetDmx(this.dmxBytes);
            }
        }
    }

    private void processArtNetPoll(DatagramSocket socket, DatagramPacket packet) {
        try {
            System.out.println("artnet poll");
            ByteArrayOutputStream baos = new ByteArrayOutputStream(300);
            DataOutputStream dos = new DataOutputStream(baos);
            dos.write(ArtNet);
            dos.writeShort(ArrayUtils.swapEndian((short)8448));
            InetAddress address = InetAddress.getLocalHost();
            System.out.println("address: " + address.getHostAddress());
            dos.write(address.getAddress());
            dos.writeShort(ArrayUtils.swapEndian((short)6454));
            dos.writeShort(257);
            dos.write(0);
            dos.write(0);
            dos.writeShort(0);
            dos.write(0);
            dos.write(0);
            dos.writeShort(0);
            byte[] shortNameBytes = "JNIOR DMX Control\u0000".getBytes();
            dos.write(shortNameBytes);
            byte[] longNameBytes = new byte[64];
            String longNameStirng = UnitConfig.getHostname() + "\u0000";
            ArrayUtils.arraycopy((Object)longNameStirng.getBytes(), (int)0, (Object)longNameBytes, (int)0, (int)longNameStirng.length());
            dos.write(longNameBytes);
            byte[] nodeReport = new byte[64];
            String nodeReportString = "Up and running\u0000";
            ArrayUtils.arraycopy((Object)nodeReportString.getBytes(), (int)0, (Object)nodeReport, (int)0, (int)nodeReportString.length());
            dos.write(nodeReport);
            dos.writeShort(1);
            byte[] filler = new byte[300 - baos.size()];
            dos.write(filler, 0, filler.length);
            byte[] bytes = baos.toByteArray();
            System.out.println(HexUtils.hexDump(bytes));
            System.out.println("send to " + packet.getAddress());
            socket.send(new DatagramPacket(bytes, bytes.length, packet.getAddress(), 6454));
        }
        catch (IOException ex) {
            AppLog.error("Error durring artnet poll", ex);
        }
    }

    private void processArtNetDmx(byte[] dmxBytes) {
        DmxMain.DMX_PORTS[0].setChannels(1, dmxBytes);
    }
}

