/* global bootbox, DmxApp */

DmxApp.controller('FixtureTypeController', function ($scope, $compile, FixtureTypeService) {
    var _this = this;
    _this.NewFixtureType = {};
    _this.NewFixtureType.ChannelNames = [];
    _this.dialogBody = "<div id='add-fixture-type'>\r\n" +
        // "<div class='row form-group'>\r\n" +
        // "  <div class='col-sm-4'><label class='inline-with-control'>Fixture Type ID</label></div>" +
        // "  <div class='col-sm-6'><label class='inline-with-control'>{{fixtureTypeCtrl.NewFixtureType.Id}}</label></div>" +
        // "</div>\r\n" +
        "<div class='row form-group'>\r\n" +
        "  <div class='col-sm-4'><label class='inline-with-control'>Fixture Type Name</label></div>" +
        "  <div class='col-sm-6'>\r\n" +
        "    <input class='form-control' type='text' ng-model='fixtureTypeCtrl.NewFixtureType.Name' ng-style='(!fixtureTypeCtrl.NewFixtureType || !fixtureTypeCtrl.NewFixtureType.Name || null === fixtureTypeCtrl.NewFixtureType.Name) ? {\"border-color\" : \"#ff8080\"} : {}'>\r\n" +
        "  </div>" +
        "</div>" +
        "<div class='row form-group'>\r\n" +
        "  <div class='col-sm-4'><label class='inline-with-control'>Channel Count</label></div>" +
        "  <div class='col-sm-2'>\r\n" +
        "    <input class='form-control' type='number' min='1' max='64'\r\n" +
        "      ng-model='fixtureTypeCtrl.NewFixtureType.ChannelCount' ng-change='eachChannel()' ng-style='(!fixtureTypeCtrl.NewFixtureType || !fixtureTypeCtrl.NewFixtureType.ChannelCount || null === fixtureTypeCtrl.NewFixtureType.ChannelCount) ? {\"border-color\" : \"#ff8080\"} : {}'>\r\n" +
        "  </div>" +
        "</div>" +
        "<div class='row form-group' ng-repeat='channel in fixtureTypeCtrl.eachChannel() track by $index'>\r\n" +
        "  <div class='col-sm-4'><label class='inline-with-control' style='padding-left: 8px'>Channel {{channel}} Name</label></div>" +
        "  <div class='col-sm-6'>\r\n" +
        "    <input class='form-control' type='text' ng-model='fixtureTypeCtrl.NewFixtureType.ChannelNames[$index]'>\r\n" +
        "  </div>" +
        "</div>" +
        "</div>";


    _this.getFixtureTypes = function () {
        return FixtureTypeService.Config.FixtureTypes;
    };


    _this.hasFixtureTypeBeenRemoved = function (fixtureType) {
        return FixtureTypeService.hasFixtureTypeBeenRemoved(fixtureType);
    };


    _this.hasFixtureTypeChanged = function (fixtureType) {
        return FixtureTypeService.hasFixtureTypeChanged(fixtureType);
    };


    _this.eachChannel = function () {
        var channels = [];
        for (var i = 1; i <= _this.NewFixtureType.ChannelCount; i++) {
            channels.push(i);
        }
        return channels;
    };


    _this.addFixtureType = function () {
        FixtureTypeService.EditDialog = bootbox.dialog({
            title: "Add a New Fixture Type",
            message: _this.dialogBody,
            buttons: {
                cancel: {
                    label: 'Cancel',
                    className: 'btn-default'
                },
                confirm: {
                    label: 'Add',
                    className: 'btn-success',
                    callback: function (result) {
                        if (result) {
                            var fixtureType = angular.copy(_this.NewFixtureType);
                            fixtureType.Added = true;
                            FixtureTypeService.Config.FixtureTypes.push(fixtureType);
                            $scope.$apply();
                        }
                    }
                }
            }
        });
        FixtureTypeService.EditDialog.init(function () {
            _this.NewFixtureType = { Id: parseInt(new Date().getTime() / 1000), ChannelNames: [] };

            FixtureTypeService.EditDialog.attr('id', 'new-fixture-type-dialog');
            $(".modal-header").css("background-color", "#428bca");
            $(".modal-header").css("color", "#fff");

            $('#bootbox-confirm-btn').attr('ng-disabled', '!(fixtureTypeCtrl.NewFixtureType && fixtureTypeCtrl.NewFixtureType.Name && fixtureTypeCtrl.NewFixtureType.ChannelCount)');

            // finally compile our new controller
            var linkFn = $compile(angular.element(FixtureTypeService.EditDialog));
            var html = linkFn($scope);
        });
    };


    _this.editFixtureType = function (fixtureType) {
        FixtureTypeService.EditDialog = bootbox.dialog({
            title: "Edit fixture",
            message: _this.dialogBody,
            buttons: {
                cancel: {
                    label: 'Cancel',
                    className: 'btn-default'
                },
                confirm: {
                    label: 'Done',
                    className: 'btn-success',
                    callback: function (result) {
                        if (result) {
                            if (!fixtureType.OldName) {
                                fixtureType.OldName = fixtureType.Name;
                            }
                            if (!fixtureType.OldChannelCount) {
                                fixtureType.OldChannelCount = fixtureType.ChannelCount;
                            }
                            if (!fixtureType.OldChannelNames) {
                                fixtureType.OldChannelNames = angular.copy(fixtureType.ChannelNames);
                            }

                            fixtureType.Name = _this.NewFixtureType.Name;
                            fixtureType.ChannelCount = _this.NewFixtureType.ChannelCount;
                            fixtureType.ChannelNames = _this.NewFixtureType.ChannelNames;
                            $scope.$apply();
                        }
                    }
                }
            }
        });
        FixtureTypeService.EditDialog.init(function () {
            if (undefined === fixtureType.Id) {
                fixtureType.Id = parseInt(new Date().getTime() / 1000);
            }
            _this.NewFixtureType = angular.copy(fixtureType);

            FixtureTypeService.EditDialog.attr('id', 'edit-fixture-type-dialog');
            $(".modal-header").css("background-color", "#428bca");
            $(".modal-header").css("color", "#fff");

            $('#bootbox-confirm-btn').attr('ng-disabled', '!(fixtureTypeCtrl.NewFixtureType && fixtureTypeCtrl.NewFixtureType.Name && fixtureTypeCtrl.NewFixtureType.ChannelCount)');

            // finally compile our new controller
            var linkFn = $compile(angular.element(FixtureTypeService.EditDialog));
            var html = linkFn($scope);
        });
    };


    _this.removeFixtureType = function (fixtureType) {
        var dialog = bootbox.confirm({
            title: "Remove Fixture",
            message: "Are you sure you want to remove the '" + fixtureType.Name + "' fixture type?",
            buttons: {
                cancel: {
                    label: 'Cancel',
                    className: 'btn-default'
                },
                confirm: {
                    label: 'Remove',
                    className: 'btn-danger'
                }
            },
            callback: function (result) {
                if (result) {
                    if (fixtureType.Added) {
                        var index = FixtureTypeService.Config.FixtureTypes.indexOf(fixtureType);
                        if (index > -1) {
                            FixtureTypeService.Config.FixtureTypes.splice(index, 1);
                        }
                    } else {
                        fixtureType.Removed = true;
                    }

                    $scope.$apply();
                }
            }
        });
        dialog.init(function () {
            $(".modal-header").css("background-color", "#d9534f");
            $(".modal-header").css("color", "#fff");
        });
    };
});



DmxApp.service('FixtureTypeService', function ($rootScope) {
    var _this = this;
    _this.Config = {};
    _this.Config.FixtureTypes = [];
    _this.SavedConfig = angular.copy(_this.Config);

    _this.EditDialog = null;
    _this.$scope = null;


    _this.hasChanged = function () {
        for (var i = 0; i < _this.Config.FixtureTypes.length; i++) {
            var fixtureType = _this.Config.FixtureTypes[i];
            if (_this.hasFixtureTypeBeenRemoved(fixtureType)
                || _this.hasFixtureTypeChanged(fixtureType)) {
                return true;
            }
        }
        return false;
    };


    _this.hasFixtureTypeBeenRemoved = function (fixtureType) {
        return (fixtureType.Removed);
    };


    _this.hasFixtureTypeChanged = function (fixtureType) {
        return (fixtureType.Added)
            || (fixtureType.OldName && fixtureType.OldName !== fixtureType.Name)
            || (fixtureType.OldChannelCount && fixtureType.OldChannelCount !== fixtureType.ChannelCount)
            || (fixtureType.OldChannelNames && !angular.equals(fixtureType.OldChannelNames, fixtureType.ChannelNames));
    };


    _this.load = function ($scope) {
        _this.$scope = $scope;
        JnrWebsocket.readFile("/flash/dmx/fixtures/fixture-types.json").then(fixtureTypeFileRead);
    };


    var fixtureTypeFileRead = function (json) {
        var filename = json.File;
        if (filename.endsWith("flash/dmx/fixtures/fixture-types.json")) {
            var fileContent = Base64.decode(json.Data);
            console.log(fileContent);
            var fixtureJson = JSON.parse(fileContent);
            _this.Config.FixtureTypes = fixtureJson.FixtureTypes;
            _this.SavedConfig = angular.copy(_this.Config);
            $rootScope.$apply();


            if (_this.EditDialog) {
                _this.EditDialog.modal('hide');
                _this.EditDialog = null;
            }

            if (_this.$scope && _this.$scope.CancelDialog) {
                _this.$scope.CancelDialog.modal('hide');
                _this.$scope.CancelDialog = null;
            }
        }
    };


    _this.save = function ($scope) {
        for (var fixtureTypeIndex = 0; fixtureTypeIndex < _this.Config.FixtureTypes.length; fixtureTypeIndex++) {
            var fixtureType = _this.Config.FixtureTypes[fixtureTypeIndex];
            if (fixtureType.Removed) {
                _this.Config.FixtureTypes.splice(fixtureTypeIndex, 1);
                fixtureTypeIndex--;
            }
        }

        _this.$scope = $scope;
        var jsonString = JSON.stringify({ FixtureTypes: _this.Config.FixtureTypes }, function (key, value) {
            console.log("stringify: " + key + ", " + value);
            if (key.startsWith("Added")) return undefined;
            if (key.startsWith("Old")) return undefined;
            if (key.startsWith("Removed")) return undefined;
            else return value;
        }, 2);
        JnrWebsocket.writeFile("/flash/dmx/fixtures/fixture-types.json", jsonString).then(writeFileComplete);
    };


    var writeFileComplete = function (json) {
        var filename = json.File;
        if ("/flash/dmx/fixtures/fixture-types.json" === filename) {
            for (var fixtureTypeIndex = 0; fixtureTypeIndex < _this.Config.FixtureTypes.length; fixtureTypeIndex++) {
                var fixtureType = _this.Config.FixtureTypes[fixtureTypeIndex];
                fixtureType.OldName = undefined;
                fixtureType.OldChannelCount = undefined;
                fixtureType.OldChannelNames = undefined;
                fixtureType.Added = undefined;
                fixtureType.Removed = undefined;
            }

            _this.SavedConfig = angular.copy(_this.Config);
            $rootScope.$apply();

            if (_this.$scope && _this.$scope.SaveDialog) {
                _this.$scope.SaveDialog.modal('hide');
                _this.$scope.SaveDialog = null;
            }
        }
    };
});