/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.dmx;

import com.integpg.dmx.DmxPort;
import com.integpg.dmx.WavFile;
import com.integpg.janoslib.messagepump.MessagePumpEngine;
import com.integpg.system.SystemMsg;

class Lightning {
    private WavFile _wav;
    private byte[] _lightning;

    Lightning(WavFile wav) {
        this._wav = wav;
        this.processData(this._wav.getBytes(), 16);
    }

    private void processData(byte[] data, int bitsPerSample) {
        try {
            this._lightning = new byte[data.length / 1025 + 1];
            int lightningIndex = 0;
            int max = 0;
            int pos = 0;
            int count = 0;
            int dataLength = data.length;
            while (pos < dataLength) {
                int sample = data[pos++];
                int temp = (sample += data[pos++] << 8) >> 31;
                sample ^= temp;
                if (max < (sample += temp & 1)) {
                    max = sample;
                }
                if (++count != 1025) continue;
                count = 0;
                int val = max >> 7;
                this._lightning[lightningIndex++] = (byte)val;
                max = 0;
            }
            int val = max >> 7;
            this._lightning[lightningIndex++] = (byte)val;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void flash(DmxPort dmxPort) {
        byte[] b = this._lightning;
        SystemMsg msg = new SystemMsg();
        msg.type = 1400;
        msg.msg = "{\"lightning\":0}".getBytes();
        MessagePumpEngine.postMessage(msg);
        dmxPort.setChannel(2, (byte)-1);
        dmxPort.setChannel(3, (byte)-1);
        dmxPort.setChannel(4, (byte)-1);
        long nextSampleTime = System.currentTimeMillis();
        for (int i = 0; i < b.length; ++i) {
            dmxPort.setChannel(1, b[i]);
            nextSampleTime += 20L;
            while (nextSampleTime > System.currentTimeMillis()) {
                Thread.yield();
            }
        }
        dmxPort.setChannel(1, (byte)0);
    }
}

