/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.dmx.effects;

import com.integpg.dmx.effects.Effect;
import com.integpg.dmx.scenes.SceneFile;
import com.integpg.dmx.scenes.SceneManager;

public class SceneEffect
extends Effect {
    private final String _sceneName;
    private final int _interval;
    private final SceneFile _sceneFile;
    private int _repeatCount;
    private long _nextStep = 0L;
    private int _stepIndex = 0;

    public SceneEffect(String sceneName, int interval, int repeatCount) {
        this._sceneName = sceneName;
        this._interval = interval;
        this._repeatCount = repeatCount;
        this._sceneFile = SceneManager.getSceneByName(this._sceneName);
    }

    @Override
    public void update() {
        if (null != this._sceneFile) {
            long now = System.currentTimeMillis();
            int stepCount = this._sceneFile.getStepCount();
            int stepIndex = 0;
            if (0L == this._nextStep) {
                this._nextStep = System.currentTimeMillis();
            }
            if (this._nextStep < now) {
                this._sceneFile.executeStep(stepIndex);
                if (stepCount <= this._stepIndex++) {
                    this._stepIndex = 0;
                }
                if (0 == this._stepIndex) {
                    --this._repeatCount;
                    System.out.println(this._repeatCount + " repeats remaining");
                }
                this._nextStep += (long)this._sceneFile.getInterval();
            }
        }
    }

    @Override
    public boolean isComplete() {
        System.out.println("_stepIndex: " + this._stepIndex + ", _repeatCount: " + this._repeatCount);
        return 0 == this._stepIndex && 0 >= this._repeatCount;
    }
}

