/* global bootbox, DmxApp */

DmxApp.controller('SceneController', function ($scope, $compile, SceneService) {
    var _this = this;


    _this.getScenes = function () {
        return SceneService.Config.Scenes;
    };



    _this.hasSceneBeenRemoved = function (scene) {
        return (scene.Removed);
    };


    _this.save = function () {
        SceneService.save();
    };


    _this.addScene = function () {
        bootbox.prompt({
            title: "What is the name of the new scene?",
            callback: function (result) {
                if (result) {
                    if (!result.endsWith(".json"))
                        result += ".json";

                    if (SceneService.Config.Scenes) {
                        for (var i = 0; i < SceneService.Config.Scenes.length; i++) {
                            if (SceneService.Config.Scenes[i].name === result)
                                return;
                        }
                    }

                    if (null === SceneService.Config.Scenes) {
                        SceneService.Config.Scenes = [];
                    }
                    var newSceneContent = "// new scene";
                    JnrWebsocket.writeFile("/flash/dmx/scenes/" + result, newSceneContent).then(SceneService.newSceneWriteFileComplete);
                    SceneService.ScenesByName[result] = { Name: result, Content: newSceneContent, OldContent: "//" };

                    var re = new RegExp("^(\/\/[^\n]*\n?)*");
                    var match = re.exec(newSceneContent);
                    console.log(match);
                    SceneService.ScenesByName[result].Comment = match[0].replaceAll("//", "");

                    SceneService.Config.Scenes.push(SceneService.ScenesByName[result]);

                    $scope.$apply();
                }
            }
        });
    };


    _this.editScene = function (scene) {
        windowObjectReference = window.open(
            "scene/?sceneName=" + scene.Name,
            scene.Name
        );


        // var dialog = bootbox.confirm({
        //     className: "fullscreen",
        //     title: "Edit Actions",
        //     message: "<textarea id='actions-text' style='background-color: #fff; border: 0; margin: -15px; width: calc(100% + 30px); height: calc(100% + 30px); padding: 8px;'></textarea>",
        //     buttons: {
        //         cancel: {
        //             label: 'Cancel',
        //             className: 'btn-default'
        //         },
        //         confirm: {
        //             label: 'Set',
        //             className: 'btn-success'
        //         }
        //     },
        //     callback: function (result) {
        //         if (result) {
        //             var content = $("#actions-text").val();

        //             if (content !== scene.Content) {
        //                 if (!scene.OldContent) {
        //                     scene.OldContent = scene.Content;
        //                 }

        //                 scene.Content = content;

        //                 var re = new RegExp("^(\/\/[^\n]*\n?)*");
        //                 var match = re.exec(scene.Content);
        //                 console.log(match);
        //                 scene.Comment = match[0].replaceAll("//", "");

        //                 $scope.$apply();
        //             }
        //         }
        //     }
        // });
        // dialog.init(function () {
        //     $(".modal-header").css("background-color", "#428bca");
        //     $(".modal-header").css("color", "#fff");

        //     if (scene.Content) {
        //         $("#actions-text").val(scene.Content);
        //     }
        // });
    };


    _this.renameScene = function (scene) {
        var oldName = scene.Name;

        bootbox.prompt({
            title: "What is the new name of the scene file?",
            value: oldName,
            callback: function (result) {
                if (result) {
                    if (!result.endsWith(".json"))
                        result += ".json";

                    if (result !== scene.Name) {
                        if (!scene.OldName) {
                            scene.OldName = scene.Name;
                        }
                        scene.Name = result;

                        $scope.$apply();
                    }
                }
            }
        }).init(function () {
            $(".modal-header").css("background-color", "#428bca");
            $(".modal-header").css("color", "#fff");
        });
    };


    _this.removeScene = function (scene) {
        var dialog = bootbox.confirm({
            title: "Are you sure you want to remove " + scene.Name,
            message: "<b>" + scene.Name + "</b> will be removed when you click Save Changes.  Once you successfully "
                + "Save the Changes the scene will be permenantly removed.",
            buttons: {
                cancel: {
                    label: 'Cancel',
                    className: 'btn-default'
                },
                confirm: {
                    label: 'Remove',
                    className: 'btn-danger'
                }
            },
            callback: function (result) {
                if (result) {
                    /**
                     * we are not going to delete the scene but rather rename it so that it no longer shows up.
                     */
                    if (!scene.OldName) {
                        scene.OldName = scene.Name;
                    }
                    scene.Name += ".removed";
                    scene.Removed = true;

                    $scope.$apply();
                }
            }
        });
        dialog.init(function () {
            $(".modal-header").css("background-color", "#d9534f");
            $(".modal-header").css("color", "#fff");
            $("#bootbox-confirm-btn").prop('disabled', false);
            $("#bootbox-cancel-btn").prop('disabled', false);
        });
    };


    _this.executeScene = function (scene) {
        _this.ExecuteDialog = bootbox.confirm({
            title: "Execute " + scene.Name,
            message: "How many times should <B>" + scene.Name + "</b> repeat? <input type'number' id='repeat-count' class='form-control' value='1'>",
            buttons: {
                cancel: {
                    label: 'Cancel',
                    className: 'btn-default'
                },
                confirm: {
                    label: 'Execute',
                    className: 'btn-success'
                }
            },
            callback: function (result) {
                if (result) {
                    JnrWebsocket.postMessage(1401, JSON.stringify({
                        Command: "exec-scene",
                        SceneName: scene.Name,
                        RepeatCount: $("#repeat-count").val()
                    }));
                }
            }
        });
        _this.ExecuteDialog.init(function () {
            $(".modal-header").css("background-color", "#5cb85c");
            $(".modal-header").css("color", "#fff");
            $("#repeat-count").focus();
        });
    };
});



DmxApp.service('SceneService', function ($rootScope) {
    var _this = this;
    _this.Config = {};
    _this.Config.Scenes = [];
    _this.ScenesByName = [];
    _this.SavedConfig = angular.copy(_this.Config);

    _this.EditDialog = null;
    _this.$scope = null;


    _this.hasChanged = function () {
        var hasChanged = !angular.equals(_this.Config, _this.SavedConfig);

        for (var index = 0; !hasChanged && index < _this.Config.Scenes.length; index++) {
            var scene = _this.Config.Scenes[index];
            hasChanged |= (scene.OldName && scene.OldName !== scene.Name)
                || (scene.OldContent && scene.OldContent !== scene.Content);
        }

        return hasChanged;
    };


    _this.load = function ($scope) {
        _this.$scope = $scope;
        JnrWebsocket.getFileListing("/flash/dmx/scenes/").then(scenesListingReceived);
    };


    var scenesListingReceived = function (json) {
        if (json.Folder === "/flash/dmx/scenes") {
            _this.Config.Scenes = [];

            for (var fileIndex in json.Content) {
                var sceneName = json.Content[fileIndex].Name;
                if (sceneName.endsWith(".json")) {
                    console.log(sceneName);
                    _this.ScenesByName[sceneName] = { "Name": sceneName, "Content": "" };
                    _this.Config.Scenes.push(_this.ScenesByName[sceneName]);

                    JnrWebsocket.readFile("/flash/dmx/scenes/" + sceneName).then(sceneFileReceived);
                }
            }

            _this.Config.Scenes.sort(function (a, b) {
                var nameA = a.Name.toUpperCase(); // ignore upper and lowercase
                var nameB = b.Name.toUpperCase(); // ignore upper and lowercase
                if (nameA < nameB) {
                    return -1;
                }
                if (nameA > nameB) {
                    return 1;
                }

                // names must be equal
                return 0;
            });

            if (_this.$scope && _this.$scope.CancelDialog) {
                _this.$scope.CancelDialog.modal('hide');
                _this.$scope.CancelDialog = null;
            }

            $rootScope.$apply();

            var sceneCollapsers = $(".scene-collapser");
            sceneCollapsers.click(function (event) {
                var $collapseIcon = $(event.target);
                if ($collapseIcon.hasClass("fa-expand")) {
                    $collapseIcon.addClass("fa-compress").removeClass("fa-expand");
                } else {
                    $collapseIcon.addClass("fa-expand").removeClass("fa-compress");
                }
            });

        }
    };


    var sceneFileReceived = function (json) {
        var sceneName = json.File;
        sceneName = sceneName.substring(sceneName.lastIndexOf("/") + 1);
        if (sceneName.endsWith(".json")) {
            fileData = Base64.decode(json.Data);
            console.log(fileData);

            var re = new RegExp("^(\/\/[^\n]*\n?)*");
            var match = re.exec(fileData);
            console.log(match);
            _this.ScenesByName[sceneName].Comment = match[0].replaceAll("//", "");
            _this.ScenesByName[sceneName].Content = fileData;

            _this.SavedConfig = angular.copy(_this.Config);
            $rootScope.$apply();
        }
    };


    _this.save = function ($scope) {
        _this.$scope = $scope;

        /** 
          * go through each scene and check to see if it has been renamed or if the scene content 
          * has been modified
          */
        for (var i = _this.Config.Scenes.length - 1; i >= 0; i--) {
            var scene = _this.Config.Scenes[i];

            // handle the renames.
            if (scene.OldName && scene.OldName !== scene.Name) {
                JnrWebsocket.renameFile("/flash/dmx/scenes/" + scene.OldName, "/flash/dmx/scenes/" + scene.Name).then(sceneRenamed);

                if (scene.Removed) {
                    _this.Config.Scenes.splice(i, 1);
                    _this.ScenesByName[scene.Name] = null;
                }
            }

            // handle if the scene content was modified
            if (scene.OldContent && scene.OldContent !== scene.Content) {
                //                    scene.Content = scene.Content.replaceAll("\r\n", "\n");
                //                    scene.Content = scene.Content.replaceAll("\n", "\r\n");
                JnrWebsocket.writeFile("/flash/dmx/scenes/" + scene.Name, scene.Content).then(writeFileComplete);
            }
        }
        $rootScope.$apply();

        if (null !== _this.$scope.SaveDialog) {
            _this.$scope.SaveDialog.modal('hide');
            _this.$scope.SaveDialog = null;
        }
    };


    var sceneRenamed = function (json) {
        var filename = json.Old;
        if (filename.startsWith("/flash/dmx/scenes/"))
            filename = filename.substring(filename.lastIndexOf("/") + 1);
        for (var i = _this.Config.Scenes.length - 1; i >= 0; i--) {
            if (_this.Config.Scenes[i].OldName && _this.Config.Scenes[i].OldName === filename) {
                var newFilename = json.New;
                if (newFilename.startsWith("/flash/dmx/scenes/"))
                    newFilename = newFilename.substring(newFilename.lastIndexOf("/") + 1);

                var scene = _this.Config.Scenes[i];
                scene.Name = newFilename;
                scene.OldName = null;

                _this.ScenesByName[newFilename] = scene;
                _this.ScenesByName[filename] = null;

                _this.SavedConfig = angular.copy(_this.Config);
                $rootScope.$apply();

                return;
            }
        }
    };


    var newSceneWriteFileComplete = function (json) {
        var filename = json.File;
        if (filename.startsWith("/flash/dmx/scenes/")) {
            filename = filename.substring(filename.lastIndexOf("/") + 1);
            windowObjectReference = window.open(
                "scene/?sceneName=" + filename,
                scene.Name
            );
        }
    };

    // var writeFileComplete = function (json) {
    //     var filename = json.File;
    //     if (filename.startsWith("/flash/dmx/scenes/")) {
    //         filename = filename.substring(filename.lastIndexOf("/") + 1);
    //         for (var i = _this.Config.Scenes.length - 1; i >= 0; i--) {
    //             if (_this.Config.Scenes[i].Name === filename) {
    //                 var scene = _this.Config.Scenes[i];
    //                 scene.OldContent = null;

    //                 _this.SavedConfig.Scenes = angular.copy(_this.Config.Scenes);
    //                 $rootScope.$apply();

    //                 JnrWebsocket.postMessage(1401, JSON.stringify({
    //                     Command: "update-scene",
    //                     SceneName: filename
    //                 }));

    //                 return;
    //             }
    //         }
    //     }
    // };
});