/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.dmx.fixtures;

import com.integpg.dmx.fixtures.Fixture;
import com.integpg.janoslib.logging.AppLog;
import com.integpg.janoslib.text.QuickDateFormat;
import com.integpg.janoslib.utils.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Json;

public class FixtureFile {
    private static final QuickDateFormat QDF = new QuickDateFormat("hh:mm:ss.fff");
    public long LastModifiedTime = 0L;
    private final String _filename;
    private final File _file;
    private ArrayList<Fixture> _fixtures = new ArrayList();

    FixtureFile(File file) {
        this._file = file;
        this._filename = file.getPath();
    }

    String getFilename() {
        return this._file.getPath();
    }

    void process() {
        try {
            Json[] fixtureArray;
            this.LastModifiedTime = this._file.lastModified();
            String fileContent = FileUtils.readAllText(this._filename);
            Json fileJson = new Json(fileContent);
            for (Json fixtureJson : fixtureArray = (Json[])fileJson.get("Fixtures")) {
                System.out.println("   " + fixtureJson);
                Fixture fixture = new Fixture(fixtureJson);
                this._fixtures.add(fixture);
            }
            AppLog.info("loaded " + this._filename);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            AppLog.error("error loading fixtrue " + this._filename, ex);
        }
    }

    public ArrayList<Fixture> getFixtures() {
        return this._fixtures;
    }
}

