/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.dmx;

import com.integpg.dmx.AssemblyInfo;
import com.integpg.dmx.DmxMain;
import com.integpg.dmx.ScriptExecutor;
import com.integpg.dmx.ScriptFile;
import com.integpg.dmx.ScriptFileCollection;
import com.integpg.dmx.actions.At;
import com.integpg.dmx.actions.Command;
import com.integpg.dmx.actions.FadeChannelCommand;
import com.integpg.dmx.actions.SetChannelCommand;
import com.integpg.dmx.effects.SceneEffect;
import com.integpg.dmx.scenes.SceneFile;
import com.integpg.dmx.scenes.SceneManager;
import com.integpg.janoslib.logging.AppLog;
import com.integpg.janoslib.logging.Logger;
import com.integpg.janoslib.net.IClient;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DmxCommandLine {
    private static final Logger LOG = Logger.getLogger(AssemblyInfo.getName() + "_commandline.log").setMaxSizeKB(32);

    static void process(IClient client, String commandString) {
        LOG.info(commandString);
        try {
            ScriptFile scriptFile;
            StringTokenizer tokenizer = new StringTokenizer(commandString, " ()");
            String command = tokenizer.nextToken();
            boolean shouldRepeat = false;
            boolean repeatForever = false;
            int repeatCount = 0;
            String scriptName = null;
            while (tokenizer.hasMoreTokens()) {
                String argument = tokenizer.nextToken();
                if ("-r".equalsIgnoreCase(argument)) {
                    shouldRepeat = true;
                    if (!tokenizer.hasMoreTokens()) {
                        throw new RuntimeException("Missing repeat count argument");
                    }
                    repeatCount = Integer.valueOf(tokenizer.nextToken());
                    continue;
                }
                if ("-f".equalsIgnoreCase(argument)) {
                    shouldRepeat = true;
                    repeatForever = true;
                    continue;
                }
                scriptName = argument.toLowerCase();
            }
            LOG.info("command: " + command + ", scriptName: " + scriptName);
            if ("script".equalsIgnoreCase(command) || "go".equalsIgnoreCase(command)) {
                if (ScriptFileCollection.containsKey(scriptName)) {
                    scriptFile = ScriptFileCollection.get(scriptName);
                    if (null != scriptFile) {
                        ScriptExecutor scriptExecutor;
                        if (!ScriptExecutor.isScriptExecuting(scriptName)) {
                            LOG.info(String.format("shouldRepeat: %s, repeatForever: %s, repeatCount: %d", String.valueOf(shouldRepeat), String.valueOf(repeatForever), repeatCount));
                            scriptExecutor = new ScriptExecutor(scriptFile);
                            if (repeatForever) {
                                scriptExecutor.setRepeatCount(-1);
                                client.send("executing " + scriptName + " forever");
                            } else if (0 != repeatCount) {
                                scriptExecutor.setRepeatCount(repeatCount);
                                client.send("executing " + scriptName + " script " + repeatCount + " times");
                            } else {
                                client.send(String.format("executing %s script", scriptName));
                            }
                            scriptExecutor.start();
                        } else {
                            scriptExecutor = ScriptExecutor.getByName(scriptName);
                            if (null != scriptExecutor) {
                                if (repeatForever) {
                                    scriptExecutor.setRepeatCount(-1);
                                    client.send("executing " + scriptName + " forever");
                                    LOG.info("Setting " + scriptName + " to repeat forever");
                                    scriptExecutor.setRepeatCount(repeatCount);
                                } else if (0 != repeatCount) {
                                    LOG.info("Setting repeat count for " + scriptName + " to " + repeatCount);
                                    scriptExecutor.setRepeatCount(repeatCount);
                                } else {
                                    LOG.info(String.format("new script executor for %s", scriptName));
                                    ScriptExecutor newScriptExecutor = new ScriptExecutor(scriptFile);
                                    newScriptExecutor.setRepeatCount(repeatCount);
                                    newScriptExecutor.start();
                                }
                            } else {
                                LOG.warn(String.format("could not get script executor for %s", scriptName));
                            }
                        }
                    }
                } else {
                    System.out.println("commandString: " + commandString);
                    Pattern pattern = Pattern.compile("(\\w*)\\((.*)\\)");
                    Matcher matcher = pattern.matcher(commandString.substring(3));
                    boolean found = matcher.find();
                    System.out.println(pattern.pattern() + " matched: " + found);
                    if (found) {
                        for (int i = 0; i < matcher.groupCount(); ++i) {
                            System.out.println(i + " = " + matcher.group(i));
                        }
                        String methodName = matcher.group(1);
                        String parameters = matcher.group(2);
                        try {
                            if ("set".equalsIgnoreCase(methodName)) {
                                SetChannelCommand channelCommand = new SetChannelCommand(parameters);
                                ((Command)channelCommand).execute(At.IMMEDIATE);
                            } else if ("fade".equalsIgnoreCase(methodName)) {
                                FadeChannelCommand fadeChannelCommand = new FadeChannelCommand("", parameters);
                                fadeChannelCommand.execute(At.IMMEDIATE);
                            }
                        }
                        catch (Exception ex) {
                            AppLog.error("error processing " + command);
                        }
                    }
                }
            }
            if ("scene".equalsIgnoreCase(command)) {
                if (SceneManager.containsKey(scriptName)) {
                    SceneFile sceneFile = SceneManager.getSceneByName(scriptName.toLowerCase());
                    if (null != sceneFile) {
                        LOG.info("shouldRepeat: " + shouldRepeat);
                        LOG.info("repeatForever: " + repeatForever);
                        LOG.info("repeatCount: " + repeatCount);
                        SceneEffect sceneEffect = new SceneEffect(scriptName, 1, repeatCount);
                        DmxMain.EFFECTS.addEffect(sceneEffect);
                        client.send("executing " + scriptName + " scene " + repeatCount + " times");
                    }
                } else {
                    System.out.println("command file not found for: " + scriptName);
                    client.send("scene file not found for " + scriptName);
                }
            } else if ("abort".equalsIgnoreCase(command)) {
                if (null != scriptName) {
                    if (ScriptExecutor.isScriptExecuting(scriptName)) {
                        ScriptExecutor.abort(scriptName);
                    }
                    scriptFile = ScriptFileCollection.get(scriptName);
                    DmxMain.EFFECTS.abortEffectFromScript(scriptFile.getFilename());
                } else {
                    LOG.info("Aborting all");
                    client.send("aborting all running scripts");
                    ScriptExecutor.abortAll();
                }
            }
        }
        catch (Exception ex) {
            LOG.error("Error processing GO <Command File> message", ex);
        }
    }
}

