/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.net.tcp;

import com.integpg.janoslib.logging.AppLog;
import com.integpg.janoslib.net.tcp.TcpServerEvent;
import com.integpg.janoslib.net.tcp.TcpServerListener;
import com.integpg.janoslib.system.Application;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

public class TcpServer
implements Runnable {
    private final String _name;
    private TcpServerListener _listener = null;
    private ServerSocket _svrSocket;
    private Socket socket;
    private final int _port;
    private Thread _thread;
    private boolean bServerRun = true;

    public TcpServer(int port) {
        this(String.format("%s TCP Server", Application.getAppName()), port);
    }

    public TcpServer(String name, int port) {
        this._name = name;
        this._port = port;
    }

    public void setTcpServerListener(TcpServerListener listener) {
        this._listener = listener;
    }

    public void start() {
        try {
            AppLog.info(String.format("Listening on port %d for the %s", this._port, this._name));
            this._svrSocket = new ServerSocket(this._port);
        }
        catch (IOException ex) {
            throw new RuntimeException(String.format("Unable to listen on port %d for the %s", this._port, this._name), ex);
        }
        try {
            this._thread = new Thread(this);
            this._thread.setName(this.getClass().getName() + ":" + this._port);
            this._thread.setDaemon(true);
            this._thread.start();
        }
        catch (RuntimeException ex) {
            throw new RuntimeException("Unable to start the server: " + ex.getMessage());
        }
    }

    public int getPort() {
        return this._svrSocket.getLocalPort();
    }

    public void stop() throws IOException {
        this.bServerRun = false;
        this._svrSocket.close();
        try {
            this._thread.interrupt();
            this._thread.join();
        }
        catch (InterruptedException ex) {
            AppLog.error("Error stopping server socket: " + ex.getMessage());
        }
    }

    @Override
    public void run() {
        try {
            AppLog.info("Listening for " + this._name + " clients on port " + this._port);
            while (this.bServerRun) {
                try {
                    this.socket = this._svrSocket.accept();
                    AppLog.info(String.format("%s:%d connected", this.socket.getInetAddress().getHostAddress(), this.socket.getPort()));
                    if (this._listener == null) continue;
                    this._listener.clientConnected(new TcpServerEvent(this, this.socket));
                }
                catch (IOException ex) {
                    AppLog.error("Error accepting server socket connection", ex);
                    this.bServerRun = false;
                }
                catch (Exception ex) {
                    AppLog.error("Error accepting server socket connection", ex);
                }
            }
        }
        catch (Exception ex) {
            AppLog.error("Error accepting server socket connection: " + ex.getMessage());
            this.bServerRun = false;
        }
        try {
            this._svrSocket.close();
        }
        catch (IOException ex) {
            AppLog.error("Error closing server socket: " + ex.getMessage());
        }
        this._svrSocket = null;
    }
}

