/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.system;

import com.integpg.system.JANOS;

public class UnitConfig {
    public static final String MODEL = JANOS.getRegistryString((String)"$Model", (String)"");
    public static final int SERIAL_NUMBER = JANOS.getSerialNumber();
    public static final String VERSION = JANOS.getRegistryString((String)"$Version", (String)"");

    public static boolean is410() {
        return MODEL.equals("410");
    }

    public static boolean is412() {
        return MODEL.equals("412");
    }

    public static boolean is414() {
        return MODEL.equals("414");
    }

    public static boolean is412DMX() {
        return MODEL.equals("412DMX");
    }

    public static int getInputCount() {
        String modelString = JANOS.getRegistryString((String)"$Model", (String)"");
        return modelString.startsWith("412") ? 4 : (modelString.equals("414") ? 12 : 8);
    }

    public static int getInternalOutputCount() {
        String modelString = JANOS.getRegistryString((String)"$Model", (String)"");
        int internalOutputCount = modelString.startsWith("412") ? 12 : (modelString.equals("414") ? 4 : 8);
        return internalOutputCount;
    }

    public static int getOutputCount() {
        int internalOutputCount;
        int outputCount = internalOutputCount = UnitConfig.getInternalOutputCount();
        if (UnitConfig.isModulePresent(1)) {
            outputCount = internalOutputCount + 4;
        }
        if (UnitConfig.isModulePresent(2)) {
            outputCount = internalOutputCount + 8;
        }
        if (UnitConfig.isModulePresent(3)) {
            outputCount = internalOutputCount + 12;
        }
        return outputCount;
    }

    private static int get410OutputCount() {
        int flags = 1;
        if (UnitConfig.isModulePresent(1)) {
            flags |= 2;
        }
        if (UnitConfig.isModulePresent(2)) {
            flags |= 4;
        }
        return flags;
    }

    private static int get412Flags() {
        int flags = 3;
        if (UnitConfig.isModulePresent(1)) {
            flags |= 4;
        }
        return flags;
    }

    private static int get414Flags() {
        int flags = 0;
        if (UnitConfig.isModulePresent(1)) {
            flags |= 1;
        }
        if (UnitConfig.isModulePresent(2)) {
            flags |= 2;
        }
        if (UnitConfig.isModulePresent(3)) {
            flags |= 4;
        }
        return flags;
    }

    private static boolean isModulePresent(int moduleIndex) {
        boolean isPresent;
        String moduleIndexRegistryString = String.format("externals/deviceorder/typefb_%d", moduleIndex);
        String address = JANOS.getRegistryString((String)moduleIndexRegistryString, (String)"");
        boolean bl = isPresent = !"".equals(address);
        if (isPresent) {
            String presentModules = JANOS.getRegistryString((String)"externals/$present", (String)"");
            isPresent = -1 != presentModules.indexOf(address);
        }
        return isPresent;
    }

    public static String getHostname() {
        return JANOS.getRegistryString((String)"IpConfig/Hostname", (String)("jr" + JANOS.getSerialNumber()));
    }

    public static String getIpAddress() {
        return JANOS.getRegistryString((String)"ipconfig/ipaddress", (String)"");
    }
}

