/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.dmx;

import com.integpg.dmx.UdpConnectionListener;
import com.integpg.dmx.client.IClient;
import com.integpg.janoslib.logging.AppLog;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;

public class UdpServer
implements Runnable,
IClient {
    private final int _port;
    private Thread _thd = null;
    private UdpConnectionListener _listener;
    private String _socketInfo;

    public UdpServer(int port) {
        this._port = port;
    }

    public void setListener(UdpConnectionListener listener) {
        this._listener = listener;
    }

    public void start() {
        if (null == this._thd) {
            this._thd = new Thread(this);
            this._thd.setName("UDP Server " + this._port);
            this._thd.setDaemon(true);
            this._thd.start();
        }
    }

    @Override
    public void run() {
        try {
            AppLog.info("Listening for DMX clients on udp port " + this._port);
            DatagramSocket serverSocket = new DatagramSocket(this._port);
            while (true) {
                byte[] data = new byte[128];
                DatagramPacket packet = new DatagramPacket(data, data.length);
                serverSocket.receive(packet);
                this._socketInfo = packet.getAddress().getHostAddress() + ":" + packet.getPort() + " (udp)";
                data = packet.getData();
                String s = new String(data, 0, packet.getLength());
                if (null == this._listener) continue;
                this._listener.processMessage(this, serverSocket, packet);
            }
        }
        catch (SocketException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void send(String s) {
    }

    @Override
    public String getSocketInfo() {
        return this._socketInfo;
    }
}

