/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.dmx.actions;

import com.integpg.dmx.DmxMain;
import com.integpg.dmx.actions.At;
import com.integpg.dmx.actions.Command;
import com.integpg.dmx.effects.ExponentialFadeEffect;
import com.integpg.dmx.lexer.Lexer;
import com.integpg.dmx.lexer.Token;
import com.integpg.dmx.lexer.TokenStream;
import com.integpg.janoslib.collections.Queue;
import com.integpg.janoslib.logging.AppLog;
import java.util.ArrayList;

public class FadeChannelCommand
extends Command {
    private final String _scriptName;
    private final String _commandString;
    private TokenStream _tokenStream = null;
    private ArrayList<Integer> _channels = new ArrayList();
    private ArrayList<Integer> _values = new ArrayList();
    private double _duration = 1000.0;
    private int _minChannel = 512;
    private int _maxChannel = 0;
    private byte[] _byteArray = null;
    private byte[] _channelMask = null;

    public FadeChannelCommand(String scriptName, String commandString) throws Exception {
        this._scriptName = scriptName;
        this._commandString = commandString;
        System.out.println("Fade Channel Command String: " + this._commandString);
        this.tokens.clear();
        try {
            Lexer.parse(this.tokens, commandString);
            this._tokenStream = new TokenStream(this.tokens);
            this.parseCommand();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public String getCommandString() {
        return this._commandString;
    }

    private void nextToken() {
        this._tokenStream.nextToken();
    }

    private void printTokens(Queue tokens) {
        try {
            System.out.println("Parser found " + tokens.size() + " tokens");
            for (int i = 0; i < tokens.size(); ++i) {
                Token token = (Token)tokens.elementAt(i);
                System.out.println("token: " + token);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void parseCommand() {
        if (null == this._tokenStream.getCurrent()) {
            throw new RuntimeException("Missing Tokens");
        }
        this.getChannels();
        this.getValues();
        this.getDuration();
    }

    private void getChannels() {
        Token token;
        do {
            int channel;
            int endingChannel = channel = this.getChannel();
            if (this._minChannel > channel) {
                this._minChannel = channel;
            }
            if (this._maxChannel < channel) {
                this._maxChannel = channel;
            }
            this._channels.add(channel);
            token = this._tokenStream.nextToken();
            switch (this._tokenStream.getCurrent().type) {
                case 61: {
                    break;
                }
                case 3: {
                    endingChannel = this.getChannel();
                    if (0 < endingChannel) {
                        throw new RuntimeException("Range Expected");
                    }
                    endingChannel = Math.abs(endingChannel);
                    break;
                }
                case 45: {
                    endingChannel = this.getChannel();
                    break;
                }
                case 44: {
                    this.nextToken();
                    break;
                }
                default: {
                    throw new RuntimeException("Expected ASSIGNMENT, COMMA, or RANGE");
                }
            }
            if (endingChannel == channel) continue;
            if (this._minChannel > endingChannel) {
                this._minChannel = endingChannel;
            }
            if (this._maxChannel < endingChannel) {
                this._maxChannel = endingChannel;
            }
            ++channel;
            while (channel <= endingChannel) {
                this._channels.add(channel);
                ++channel;
            }
            this.nextToken();
        } while (null != (token = this._tokenStream.getCurrent()) && 61 != token.type);
        this.nextToken();
    }

    private int getChannel() {
        try {
            Token token = this._tokenStream.getCurrent();
            if (3 != token.type) {
                throw new RuntimeException("Numeric Channel Expected");
            }
            int channel = Integer.parseInt(token.content);
            return channel;
        }
        catch (Exception ex) {
            AppLog.error("Error getting channel", ex);
            throw ex;
        }
    }

    private void getValues() {
        do {
            int value = this.getValue();
            this._values.add(value);
            this.nextToken();
            switch (this._tokenStream.getCurrent().type) {
                case 58: {
                    break;
                }
                case 44: {
                    this.nextToken();
                    break;
                }
                default: {
                    throw new RuntimeException("Expected COLON, or COMMA");
                }
            }
        } while (null != this._tokenStream.getCurrent() && 58 != this._tokenStream.getCurrent().type);
        this.nextToken();
    }

    private int getValue() {
        try {
            Token token = this._tokenStream.getCurrent();
            if (3 != token.type) {
                throw new RuntimeException("Numeric Value Expected");
            }
            int value = Integer.parseInt(token.content);
            return value;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            AppLog.error("Error getting channel", ex);
            return Integer.MIN_VALUE;
        }
    }

    private void getDuration() {
        try {
            Token token = this._tokenStream.getCurrent();
            if (3 != token.type) {
                throw new RuntimeException("Numeric Value Expected");
            }
            this._duration = Double.valueOf(token.content);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            AppLog.error("Error getting duration", ex);
        }
    }

    @Override
    public void execute(At at) {
        Integer[] channelsArray = (Integer[])this._channels.toArray();
        int[] channels = new int[channelsArray.length];
        for (int i = 0; i < channels.length; ++i) {
            channels[i] = channelsArray[i];
        }
        Integer[] valuesArray = (Integer[])this._values.toArray();
        int[] values = new int[channelsArray.length];
        for (int i = 0; i < channelsArray.length; ++i) {
            values[i] = valuesArray[i % valuesArray.length];
        }
        ExponentialFadeEffect exponentialFadeEffect = new ExponentialFadeEffect(channels, values, (int)(this._duration * 1000.0));
        exponentialFadeEffect.setParentScriptName(this._scriptName);
        DmxMain.EFFECTS.addEffect(exponentialFadeEffect);
    }
}

