/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.dmx;

import com.integpg.dmx.DmxMain;
import com.integpg.dmx.ScriptExecutor;
import com.integpg.dmx.ScriptFile;
import com.integpg.dmx.ScriptFileCollection;
import com.integpg.dmx.effects.SceneEffect;
import com.integpg.dmx.scenes.SceneFile;
import com.integpg.dmx.scenes.SceneManager;
import com.integpg.janoslib.logger.FileLog;
import com.integpg.janoslib.logger.LogOptions;
import com.integpg.janoslib.logger.Logger;
import com.integpg.janoslib.net.IClient;
import com.integpg.janoslib.system.Application;
import java.util.StringTokenizer;

public class DmxCommandLine {
    private static final Logger LOG = FileLog.getHalfBackupLog(new LogOptions(Application.getAppName() + "_commandline.log").setMaxFileSizeInKb(32));

    static void process(IClient client, String commandString) {
        LOG.info(commandString);
        try {
            ScriptFile scriptFile;
            StringTokenizer tokenizer = new StringTokenizer(commandString, " ()");
            String command = tokenizer.nextToken();
            boolean shouldRepeat = false;
            boolean repeatForever = false;
            int repeatCount = 0;
            String scriptName = null;
            while (tokenizer.hasMoreTokens()) {
                String argument = tokenizer.nextToken();
                if ("-r".equalsIgnoreCase(argument)) {
                    shouldRepeat = true;
                    if (!tokenizer.hasMoreTokens()) {
                        throw new RuntimeException("Missing repeat count argument");
                    }
                    repeatCount = Integer.valueOf(tokenizer.nextToken());
                    continue;
                }
                if ("-f".equalsIgnoreCase(argument)) {
                    shouldRepeat = true;
                    repeatForever = true;
                    continue;
                }
                scriptName = argument.toLowerCase();
            }
            LOG.info("command: " + command + ", scriptName: " + scriptName);
            if ("script".equalsIgnoreCase(command) || "go".equalsIgnoreCase(command)) {
                if (ScriptFileCollection.containsKey(scriptName)) {
                    scriptFile = ScriptFileCollection.get(scriptName);
                    if (null != scriptFile) {
                        ScriptExecutor scriptExecutor;
                        if (!ScriptExecutor.isScriptExecuting(scriptName)) {
                            LOG.info("shouldRepeat: " + shouldRepeat + ", repeatForever: " + repeatForever + ", repeatCount: " + repeatCount);
                            scriptExecutor = new ScriptExecutor(scriptFile);
                            if (repeatForever) {
                                scriptExecutor.setRepeatCount(-1);
                                client.send("executing " + scriptName + " forever");
                            } else if (0 != repeatCount) {
                                scriptExecutor.setRepeatCount(repeatCount);
                                client.send("executing " + scriptName + " script " + repeatCount + " times");
                            } else {
                                client.send("executing " + scriptName + " script");
                            }
                            scriptExecutor.start();
                        } else {
                            scriptExecutor = ScriptExecutor.getByName(scriptName);
                            if (null != scriptExecutor) {
                                if (repeatForever) {
                                    scriptExecutor.setRepeatCount(-1);
                                    client.send("executing " + scriptName + " forever");
                                    LOG.info("Setting " + scriptName + " to repeat forever");
                                    scriptExecutor.setRepeatCount(repeatCount);
                                } else if (0 != repeatCount) {
                                    LOG.info("Setting repeat count for " + scriptName + " to " + repeatCount);
                                    scriptExecutor.setRepeatCount(repeatCount);
                                } else {
                                    ScriptExecutor newScriptExecutor = new ScriptExecutor(scriptFile);
                                    newScriptExecutor.setRepeatCount(repeatCount);
                                    newScriptExecutor.start();
                                }
                            }
                        }
                    }
                } else {
                    System.out.println("command file not found for: " + scriptName);
                    client.send("script file not found for " + scriptName);
                }
            }
            if ("scene".equalsIgnoreCase(command)) {
                if (SceneManager.containsKey(scriptName)) {
                    SceneFile sceneFile = SceneManager.getSceneByName(scriptName.toLowerCase());
                    if (null != sceneFile) {
                        LOG.info("shouldRepeat: " + shouldRepeat);
                        LOG.info("repeatForever: " + repeatForever);
                        LOG.info("repeatCount: " + repeatCount);
                        SceneEffect sceneEffect = new SceneEffect(scriptName, 1, repeatCount);
                        DmxMain.EFFECTS.addEffect(sceneEffect);
                        client.send("executing " + scriptName + " scene " + repeatCount + " times");
                    }
                } else {
                    System.out.println("command file not found for: " + scriptName);
                    client.send("scene file not found for " + scriptName);
                }
            } else if ("abort".equalsIgnoreCase(command)) {
                if (null != scriptName) {
                    if (ScriptExecutor.isScriptExecuting(scriptName)) {
                        ScriptExecutor.abort(scriptName);
                        client.send("aborting " + scriptName + " script");
                    } else {
                        client.send(scriptName + " is not currently executing");
                    }
                    scriptFile = ScriptFileCollection.get(scriptName);
                    DmxMain.EFFECTS.abortEffectFromScript(scriptFile.getFilename());
                } else {
                    LOG.info("Aborting all");
                    client.send("aborting all running scripts");
                    ScriptExecutor.abortAll();
                }
            }
        }
        catch (Exception ex) {
            LOG.error("Error processing GO <Command File> message", ex);
        }
    }
}

