/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.dmx;

import com.integ.janoslib.messagepump.MessagePumpEngine;
import com.integ.janoslib.messagepump.MessagePumpListener;
import com.integpg.dmx.DmxDimmer;
import com.integpg.dmx.TenVoltModule;
import com.integpg.janoslib.externalio.TypeF9;
import com.integpg.janoslib.externalio.TypeFD;
import com.integpg.janoslib.system.Application;
import com.integpg.janoslib.utils.RegistryUtils;
import com.integpg.janoslib.utils.StringUtils;
import com.integpg.system.JANOS;
import com.integpg.system.SystemMsg;

public class Config {
    private static double MAX_FADE_DURATION = 1.0;
    private static TypeF9[] F9_DEVICES;
    private static DmxDimmer[] DMX_DIMMERS;
    private static TypeFD[] FD_DEVICES;
    private static TenVoltModule[] TEN_VOLT_MODULES;

    public static void init() {
        Config.loadDefaultKeys();
        MessagePumpEngine.addListener(new MessagePumpListener(){

            @Override
            public void messageReceived(SystemMsg systemMsg) {
                String applicationRegistryRoot;
                String registryKey;
                if (64 == systemMsg.type && (registryKey = new String(systemMsg.msg)).startsWith(applicationRegistryRoot = Application.getRegistryRoot())) {
                    int applicationRegistryRootLength = Application.getRegistryRoot().length();
                    String applicationRegistryKey = registryKey.substring(applicationRegistryRootLength);
                    if ("MaxFadeDuration".equalsIgnoreCase(applicationRegistryKey)) {
                        MAX_FADE_DURATION = JANOS.getRegistryDouble((String)registryKey, (double)MAX_FADE_DURATION);
                        System.out.println("MAX_FADE_DURATION: " + MAX_FADE_DURATION);
                    } else if (applicationRegistryKey.toLowerCase().endsWith("dmxstartaddress")) {
                        String dmxDimmerAddress = applicationRegistryKey.substring(0, applicationRegistryKey.indexOf("/"));
                        for (int i = 0; i < DMX_DIMMERS.length; ++i) {
                            if (null == DMX_DIMMERS[i] || !DMX_DIMMERS[i].TypeF9.AddressString.equalsIgnoreCase(dmxDimmerAddress)) continue;
                            DMX_DIMMERS[i].StartAddress = JANOS.getRegistryInt((String)registryKey, (int)DMX_DIMMERS[i].StartAddress);
                            DMX_DIMMERS[i].Dirty = true;
                        }
                    } else {
                        String registryValue = JANOS.getRegistryString((String)registryKey, (String)"");
                        System.out.println("unhandled registry key: " + registryKey + " = " + registryValue);
                    }
                }
            }
        });
    }

    private static void loadDefaultKeys() {
        int i;
        System.out.println("Get F9 devices");
        F9_DEVICES = TypeF9.getDeviceArray();
        DMX_DIMMERS = new DmxDimmer[F9_DEVICES.length];
        for (i = 0; i < F9_DEVICES.length; ++i) {
            TypeF9 f9 = F9_DEVICES[i];
            if (null == f9) continue;
            Config.DMX_DIMMERS[i] = new DmxDimmer(f9);
        }
        System.out.println("Get FD devices");
        FD_DEVICES = TypeFD.getDeviceArray();
        TEN_VOLT_MODULES = new TenVoltModule[FD_DEVICES.length];
        for (i = 0; i < FD_DEVICES.length; ++i) {
            TypeFD fd = FD_DEVICES[i];
            if (null == fd) continue;
            Config.TEN_VOLT_MODULES[i] = new TenVoltModule(fd);
        }
        Config.getMaxFadeDuration();
        Config.getTcpServerPort();
        Config.getTerminationBytes();
        Config.getWebServerPort();
    }

    public static TypeF9[] getF9Devices() {
        return F9_DEVICES;
    }

    public static DmxDimmer[] getDmxDimmers() {
        return DMX_DIMMERS;
    }

    public static TenVoltModule[] getTenVoltModules() {
        return TEN_VOLT_MODULES;
    }

    public static double getMaxFadeDuration() {
        return RegistryUtils.getRegistryKey("AppData/Dmx/MaxFadeDuration", -1);
    }

    public static byte[] getTerminationBytes() {
        String terminationBytesString = RegistryUtils.getRegistryKey("AppData/Dmx/TerminationBytes", "\\r\\n");
        return StringUtils.getEscapedBytes(terminationBytesString);
    }

    public static int getTcpServerPort() {
        return RegistryUtils.getRegistryKey("AppData/Dmx/TcpServerPort", 10000);
    }

    public static int getWebServerPort() {
        return RegistryUtils.getRegistryKey("AppData/Dmx/WebServerPort", 8080);
    }
}

