/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.dmx.scenes;

import com.integpg.system.ArrayUtils;

public class Channels {
    private final byte[] _channelMask = new byte[64];
    private final byte[] _channelValues = new byte[512];
    private short _minChannel = Short.MAX_VALUE;
    private short _maxChannel = Short.MIN_VALUE;

    public void setChannel(int channel, int value) {
        if (this._minChannel > channel) {
            this._minChannel = (short)channel;
        }
        if (this._maxChannel < channel) {
            this._maxChannel = (short)channel;
        }
        this._channelValues[--channel] = (byte)value;
        int bytePos = channel / 8;
        int bitPos = channel % 8;
        int n = bytePos;
        this._channelMask[n] = (byte)(this._channelMask[n] | (byte)(1 << bitPos));
    }

    public short getStartChannel() {
        return this._minChannel;
    }

    byte[] getChannelMask() {
        if (this._maxChannel >= this._minChannel) {
            int startByte = (this._minChannel - 1) / 8;
            int endByte = (this._maxChannel - 1) / 8;
            int byteCount = endByte - startByte + 1;
            byte[] channelMask = new byte[byteCount];
            ArrayUtils.arraycopy((Object)this._channelMask, (int)startByte, (Object)channelMask, (int)0, (int)byteCount);
            return channelMask;
        }
        return new byte[0];
    }

    byte[] getChannelValues() {
        if (this._maxChannel >= this._minChannel) {
            int channelCount = this._maxChannel - this._minChannel + 1;
            byte[] channelValues = new byte[channelCount];
            ArrayUtils.arraycopy((Object)this._channelValues, (int)(this._minChannel - 1), (Object)channelValues, (int)0, (int)channelCount);
            return channelValues;
        }
        return new byte[0];
    }
}

