/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.net.http.server;

import com.integpg.janoslib.logging.AppLog;
import com.integpg.janoslib.logging.Logger;
import com.integpg.janoslib.net.http.HttpConnection;
import com.integpg.janoslib.net.http.server.AcceptHttpConnection;
import com.integpg.janoslib.net.http.server.HttpListener;
import com.integpg.janoslib.net.http.server.HttpRequest;
import com.integpg.janoslib.net.http.server.HttpResponse;
import com.integpg.janoslib.net.tcp.TcpServer;
import com.integpg.janoslib.net.tcp.TcpServerEvent;
import com.integpg.janoslib.net.tcp.TcpServerListener;
import com.integpg.janoslib.system.Application2;
import com.integpg.janoslib.text.QuickDateFormat;
import com.integpg.janoslib.threading.ThreadPool;
import java.io.IOException;
import java.net.Socket;
import java.text.DecimalFormat;
import java.util.Hashtable;
import java.util.Vector;

public class HttpServer
extends TcpServer
implements TcpServerListener {
    private static final QuickDateFormat DATE_FORMAT = new QuickDateFormat("MM-dd-yyyy HH:mm:ss zzz");
    protected static final Logger WebServerLog = Logger.getLogger(Application2.getAppName() + "_webserver.log");
    private Vector<HttpListener> _listeners = new Vector();
    private final DecimalFormat DF = new DecimalFormat("0.000");
    private final Hashtable<String, Integer> ConnectionsByIpAddress = new Hashtable();
    private final Hashtable<String, Long> BlocklistByIpAddress = new Hashtable();
    private final Hashtable<String, Integer> BlocksByIpAddress = new Hashtable();

    public HttpServer(int port) {
        super("HttpServer", port);
        super.setTcpServerListener(this);
    }

    @Override
    public void start() {
        super.start();
        WebServerLog.info("HttpServer started");
    }

    public void addListener(HttpListener httpListener) {
        this._listeners.addElement(httpListener);
    }

    public Vector<HttpListener> getListeners() {
        return this._listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clientConnected(TcpServerEvent evt) {
        Socket socket = evt.getSocket();
        String hostAddress = socket.getInetAddress().getHostAddress();
        WebServerLog.info(String.format("client connected from %s", hostAddress));
        Hashtable<String, Number> hashtable = this.ConnectionsByIpAddress;
        synchronized (hashtable) {
            if (!this.ConnectionsByIpAddress.containsKey(hostAddress)) {
                this.ConnectionsByIpAddress.put(hostAddress, 0);
            }
            int connections = this.ConnectionsByIpAddress.get(hostAddress);
            this.ConnectionsByIpAddress.put(hostAddress, ++connections);
            WebServerLog.debug(String.format("%s has connected %d times", hostAddress, connections));
        }
        hashtable = this.BlocklistByIpAddress;
        synchronized (hashtable) {
            if (this.BlocklistByIpAddress.containsKey(hostAddress)) {
                long expirationTime = this.BlocklistByIpAddress.get(hostAddress);
                if (System.currentTimeMillis() >= expirationTime) {
                    this.BlocklistByIpAddress.remove(hostAddress);
                    WebServerLog.warn(String.format("offending host %s removed from blocklist", hostAddress));
                } else {
                    try {
                        this.blocklistHostAddress(hostAddress);
                        HttpConnection httpConnection = new HttpConnection(this, socket);
                        HttpRequest httpRequest = new HttpRequest(httpConnection);
                        httpRequest.processFirstLine();
                        HttpResponse httpResponse = new HttpResponse(httpRequest);
                        httpResponse.sendResponse(429);
                        WebServerLog.warn(String.format("close the connection to the offending host %s", hostAddress));
                        try {
                            socket.close();
                        }
                        catch (IOException ex) {
                            WebServerLog.error("error closing socket", ex);
                        }
                        return;
                    }
                    catch (IOException ex) {
                        AppLog.error(ex);
                    }
                }
            }
        }
        AcceptHttpConnection acceptHttpConnection = new AcceptHttpConnection(this, evt.getSocket());
        ThreadPool.execute(acceptHttpConnection);
    }

    public Logger getLog() {
        return WebServerLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blocklistHostAddress(String offendingHost) {
        Hashtable<String, Long> hashtable = this.BlocklistByIpAddress;
        synchronized (hashtable) {
            if (!this.BlocksByIpAddress.containsKey(offendingHost)) {
                this.BlocksByIpAddress.put(offendingHost, 0);
            }
            int blockCount = this.BlocksByIpAddress.get(offendingHost);
            this.BlocksByIpAddress.put(offendingHost, ++blockCount);
            if (!this.BlocklistByIpAddress.containsKey(offendingHost)) {
                this.BlocklistByIpAddress.put(offendingHost, System.currentTimeMillis());
            }
            long expirationTime = this.BlocklistByIpAddress.get(offendingHost);
            if (System.currentTimeMillis() > expirationTime) {
                expirationTime = System.currentTimeMillis();
            }
            expirationTime = (long)((double)expirationTime + Math.pow(2.0, blockCount) * 1000.0);
            this.BlocklistByIpAddress.put(offendingHost, expirationTime);
            WebServerLog.warn(String.format("offending host %s has been blocked %d time(s) and is blocked until %s", offendingHost, blockCount, DATE_FORMAT.format(expirationTime)));
        }
    }
}

