/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.dmx.effects;

import com.integpg.dmx.DmxMain;
import com.integpg.dmx.effects.Effect;

public class CosEffect
extends Effect {
    private final int _channelNumber;
    private final int _periodInSeconds;
    private final long _startTime = System.currentTimeMillis();

    public CosEffect(int channelNumber, int periodInSeconds) {
        this._channelNumber = channelNumber;
        this._periodInSeconds = periodInSeconds;
    }

    @Override
    public void update() {
        long now = System.currentTimeMillis();
        long elapsed = now - this._startTime;
        double value = -this.cosWave(elapsed, this._periodInSeconds);
        value = (int)((value + 1.0) * 127.5);
        DmxMain.DMX_PORTS[0].setChannel(this._channelNumber, (byte)value);
    }

    @Override
    public boolean isComplete() {
        return false;
    }

    private double cosWave(double elapsed, long periodInSeconds) {
        double period = periodInSeconds * 1000L;
        double x = elapsed % period / period;
        double rad = Math.PI * 2 * x;
        double value = Math.cos(rad);
        return value;
    }
}

