/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.system;

import com.integpg.janoslib.logger.AppLog;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

public final class ExceptionHandler
extends ThreadGroup {
    private static final StringWriter SW = new StringWriter(256);
    private static final PrintWriter PW = new PrintWriter((Writer)SW, false);

    public ExceptionHandler() {
        super("Exception Handler");
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        System.err.println(t + " caused: " + ExceptionHandler.getStackTrace(e));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStackTrace(Throwable ex) {
        StringWriter stringWriter = SW;
        synchronized (stringWriter) {
            SW.getBuffer().setLength(0);
            ex.printStackTrace(PW);
            return SW.toString();
        }
    }

    public static synchronized void logException(int code, Throwable ex) {
        ExceptionHandler.logException(code, null, ex);
    }

    public static synchronized void logException(int code, String desc, Throwable ex) {
        AppLog.error(desc + " (" + code + ")", ex);
    }
}

