/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.dmx.fixtures;

import com.integpg.dmx.fixtures.FixtureType;
import com.integpg.dmx.fixtures.FixtureTypeFile;
import com.integpg.janoslib.logger.AppLog;
import java.io.File;
import java.util.Hashtable;

public class FixtureTypeManager {
    private static final Hashtable<Integer, FixtureType> FIXTURE_TYPE_COLLECTION = new Hashtable();

    public static void loadFixtureTypes() {
        AppLog.info("Loading Fixture Types");
        File file = new File("flash/dmx/fixtures/fixture-types.json");
        if (file.exists()) {
            try {
                FixtureTypeFile fixtureTypeFile = new FixtureTypeFile(file);
                fixtureTypeFile.process();
                for (FixtureType fixtureType : fixtureTypeFile.getFixtureTypes()) {
                    FIXTURE_TYPE_COLLECTION.put(fixtureType.getId(), fixtureType);
                }
            }
            catch (Exception ex) {
                AppLog.error("error loading fixture types", ex);
            }
            AppLog.info(FIXTURE_TYPE_COLLECTION.size() + " fixture types loaded");
        }
    }

    public static FixtureType getById(int id) {
        return FIXTURE_TYPE_COLLECTION.get(id);
    }
}

