/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.dmx.effects;

import com.integpg.dmx.DmxMain;
import com.integpg.dmx.effects.Effect;

public class LinearFadeEffect
extends Effect {
    private final int _channelNumber;
    private final int _periodInSeconds;
    private final long _startTime = System.currentTimeMillis();

    public LinearFadeEffect(int channelNumber, int periodInSeconds) {
        this._channelNumber = channelNumber;
        this._periodInSeconds = periodInSeconds;
    }

    @Override
    public void update() {
        long now = System.currentTimeMillis();
        long elapsed = now - this._startTime;
        double value = this.linearFade(elapsed, 5);
        DmxMain.DMX_PORTS[0].setChannel(this._channelNumber, (byte)(value *= 255.0));
    }

    @Override
    public boolean isComplete() {
        return false;
    }

    private double linearFade(long elapsed, int periodInSeconds) {
        double period = periodInSeconds * 1000;
        double x = (double)elapsed % period / period;
        return x;
    }
}

