/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.dmx;

import com.integpg.janoslib.system.ExceptionHandler;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Json;

public class JsonSender {
    private final Socket _socket;
    private final OutputStream _outStream;
    private final ByteArrayOutputStream _baos = new ByteArrayOutputStream();
    private final DataOutputStream _dos = new DataOutputStream(this._baos);

    public JsonSender(Socket socket) throws IOException {
        this._socket = socket;
        this._outStream = this._socket.getOutputStream();
    }

    public synchronized void send(Json json) throws IOException {
        try {
            this._baos.reset();
            String jsonString = json.toString();
            this._dos.writeShort(jsonString.length());
            this._dos.writeBytes(jsonString);
            if (this._outStream != null) {
                this._outStream.write(this._baos.toByteArray());
                this._outStream.flush();
            }
        }
        catch (IOException ex) {
            ExceptionHandler.logException(0, ex);
        }
    }

    void close() throws IOException {
        this._outStream.close();
    }
}

