/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.dmx;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.Json;

public class JsonReceiver {
    private final Socket _socket;
    private final DataInputStream _din;
    private byte[] _inBuffer = new byte[1024];

    public JsonReceiver(Socket socket) throws IOException {
        this._socket = socket;
        this._din = new DataInputStream(this._socket.getInputStream());
    }

    public Json getJson() throws IOException {
        short len = this._din.readShort();
        if (this._inBuffer.length < len) {
            this._inBuffer = new byte[len];
        }
        this._din.readFully(this._inBuffer, 0, len);
        return new Json(new String(this._inBuffer, 0, (int)len));
    }

    void close() throws IOException {
        this._din.close();
    }
}

