/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.dmx.actions;

import com.integpg.dmx.actions.Command;
import com.integpg.janoslib.logger.AppLog;
import com.integpg.janoslib.text.QuickDateFormat;
import java.util.ArrayList;

public class At {
    private static final QuickDateFormat QDF = new QuickDateFormat("hh:mm:ss.fff");
    private final long _atTime;
    public final ArrayList<Command> Commands = new ArrayList();
    public Command[] _commands = null;
    private boolean _shouldAbort = false;
    private long _lastActionTime;

    public At(long atTime) {
        this._atTime = atTime;
    }

    public long getLastActionTime() {
        return this._lastActionTime;
    }

    public void commit() {
        this._commands = (Command[])this.Commands.toArray();
    }

    public void execute(long startTime) throws InterruptedException {
        this._shouldAbort = false;
        this._lastActionTime = startTime;
        try {
            long executeTime = startTime + this._atTime;
            while (System.currentTimeMillis() < executeTime) {
                if (this._shouldAbort) {
                    throw new InterruptedException("user aborted");
                }
                Thread.sleep(1L);
            }
            if (this._shouldAbort) {
                throw new InterruptedException("user aborted");
            }
            for (int i = 0; i < this._commands.length; ++i) {
                if (this._shouldAbort) {
                    throw new InterruptedException("user aborted");
                }
                long preCommandTime = System.currentTimeMillis();
                this._commands[i].execute(this);
                this._lastActionTime = preCommandTime;
            }
        }
        catch (InterruptedException ex) {
            throw ex;
        }
        catch (Exception ex) {
            AppLog.error(ex);
        }
    }

    public void abort() {
        this._shouldAbort = true;
    }
}

