/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.dmx.scenes;

import com.integpg.dmx.scenes.SceneFile;
import com.integpg.janoslib.logger.AppLog;
import com.integpg.janoslib.utils.StringUtils;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;

public class SceneManager {
    private static final Hashtable<String, SceneFile> SCENE_COLLECTION = new Hashtable();

    public static void loadScenes() {
        AppLog.info("Loading Scenes");
        try {
            String[] fileNames;
            File scenesDirectory = new File("/flash/dmx/scenes/");
            AppLog.info(scenesDirectory + " exists: " + scenesDirectory.exists());
            if (!scenesDirectory.exists()) {
                AppLog.info("create " + scenesDirectory);
                scenesDirectory.mkdir();
            }
            for (String filename : fileNames = scenesDirectory.list()) {
                if (filename.startsWith("~")) continue;
                try {
                    SceneFile sceneFile = new SceneFile(scenesDirectory.getPath() + filename);
                    sceneFile.process();
                    String sceneName = sceneFile.getName();
                    AppLog.info("sceneName: " + sceneName);
                    sceneName = StringUtils.replaceAll(sceneName, " ", "-");
                    AppLog.info("sceneName: " + sceneName);
                    SCENE_COLLECTION.put(sceneName, sceneFile);
                }
                catch (Exception ex) {
                    AppLog.error("error loading scene: " + filename, ex);
                }
            }
        }
        catch (Exception ex) {
            AppLog.error("error loading scenes", ex);
        }
        AppLog.info(SCENE_COLLECTION.size() + " scene files");
    }

    public static SceneFile[] getScenes() {
        SceneFile[] sceneFiles = new SceneFile[SCENE_COLLECTION.size()];
        Enumeration<SceneFile> e = SCENE_COLLECTION.elements();
        int index = 0;
        while (e.hasMoreElements()) {
            sceneFiles[index++] = e.nextElement();
        }
        return sceneFiles;
    }

    public static SceneFile getSceneByName(String sceneName) {
        AppLog.info("get scene: " + sceneName);
        return SCENE_COLLECTION.get(sceneName);
    }

    public static void executeScene(String sceneName) {
        SceneFile sceneFile = SceneManager.getSceneByName(sceneName);
        if (null != sceneFile) {
            try {
                System.out.println(System.currentTimeMillis() + " execute " + sceneName);
                sceneFile.execute();
            }
            catch (InterruptedException ex) {
                AppLog.error(ex);
            }
        } else {
            System.out.println("scene file not found for " + sceneName);
        }
    }

    public static boolean containsKey(String scriptName) {
        return SCENE_COLLECTION.containsKey(scriptName);
    }
}

