/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.dmx;

import com.integpg.dmx.DmxMain;
import com.integpg.dmx.ScriptFileCollection;
import com.integpg.dmx.TriggerManager;
import com.integpg.janoslib.messagepump.MessagePumpEngine;
import com.integpg.janoslib.messagepump.MessagePumpListener;
import com.integpg.janoslib.utils.HexUtils;
import com.integpg.system.SystemMsg;
import java.util.Json;

public class WebPageListener
implements MessagePumpListener {
    private static final Json APP_INFO_JSON = new Json();

    @Override
    public void messageReceived(final SystemMsg systemMsg) {
        if (1401 == systemMsg.type) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    String contentJsonString = new String(systemMsg.msg);
                    Json contentJson = new Json(contentJsonString);
                    String commandString = contentJson.getString("Command");
                    System.out.println("commandString: " + commandString);
                    if ("get-channel-values".equalsIgnoreCase(commandString)) {
                        long start = System.currentTimeMillis();
                        Json json = new Json();
                        json.put("Message", (Object)"channel-update");
                        json.put("Min", 1);
                        json.put("Max", 512);
                        json.put("Channels", (Object)HexUtils.bytesToHex(DmxMain.DMX_PORTS[0].getChannels()));
                        WebPageListener.this.sendMessageString(json.toString());
                        long elapsed = System.currentTimeMillis() - start;
                        System.out.println(commandString + " elapsed " + elapsed);
                    } else if ("exec-script".equalsIgnoreCase(commandString)) {
                        String scriptNameString = contentJson.getString("ScriptName");
                        System.out.println("scriptNameString: " + scriptNameString);
                        int repeatCount = 1;
                        if (contentJson.containsKey("RepeatCount")) {
                            repeatCount = contentJson.getInt("RepeatCount");
                        }
                        ScriptFileCollection.executeScript(scriptNameString, repeatCount);
                    } else if ("update-script".equalsIgnoreCase(commandString)) {
                        String scriptNameString = contentJson.getString("ScriptName");
                        System.out.println("scriptNameString: " + scriptNameString);
                        ScriptFileCollection.loadScript("/flash/dmx/scripts/" + scriptNameString);
                    } else if ("update-triggers".equalsIgnoreCase(commandString)) {
                        TriggerManager.load();
                    } else if ("get-app-info".equalsIgnoreCase(commandString)) {
                        WebPageListener.this.sendMessageString(APP_INFO_JSON.toString());
                    }
                }
            }).start();
        }
    }

    private void sendMessageString(String messageString) {
        this.sendMessage(messageString.getBytes());
        System.out.println(String.format("posted '%s' to the message pump", messageString));
    }

    private void sendMessageBytes(byte[] messageBytes) {
        this.sendMessage(messageBytes);
        System.out.println("posted " + messageBytes.length + " bytes to the message pump");
    }

    private void sendMessage(byte[] messageBytes) {
        SystemMsg responseMsg = new SystemMsg();
        responseMsg.type = 1401;
        responseMsg.msg = messageBytes;
        MessagePumpEngine.postMessage(responseMsg);
    }

    static {
        APP_INFO_JSON.put("Message", (Object)"app-info");
        APP_INFO_JSON.put("Name", (Object)DmxMain.ASSEMBLY_INFO.getName());
        APP_INFO_JSON.put("Version", (Object)DmxMain.ASSEMBLY_INFO.getVersion());
        APP_INFO_JSON.put("BuildTime", (Object)DmxMain.ASSEMBLY_INFO.getBuildTime());
    }
}

