function JnrWebsocket() {
    var _service = this;

    _service.onLoggedIn = null;
    _service.onReplyMessage = null;

    var _registryReadPromises = [];
    var _fileListPromises = [];
    var _readFilePromises = [];
    var _writeFilePromises = [];
    var _renameFilePromises = [];
    var _removeFilePromises = [];

    // our websocket communication object
    var _comm;
    var _loggedIn = false;
    var _appId;
    var _pingAcknowledged = true;
    var _nextPing = new Date().getTime();

    _service.onOpened = function () { };
    _service.onClosed = function () { };
    _service.onError = function () { };
    _service.pingFailed = null;

    _service.initPing = function (appId) {
        _appId = appId;
        setInterval(_service.sendPing, 5000);
    };

    _service.sendPing = function () {
        // if the websocket connection is good then there is a connection with JANOS.  here we need to check 
        // to see that the ping was acknowledged by the application.  if not then there is an error
        if (_comm && 1 === _comm.ws.readyState) {
            if (!_pingAcknowledged) {
                console.log('ping not acknolwedged');
                if (_service.pingFailed) {
                    _service.pingFailed();
                }
            }


            var currentTime = new Date().getTime();
            // if there is a conn object and it is ready then send the ping
            if (_nextPing <= currentTime) {
                console.log('send ping');
                _service.postMessage(_appId, 'ping');
                _pingAcknowledged = false;
                _nextPing += 15000;
            }
        }
    };

    var onmessage = function (evt) {
        var json = JSON.parse(evt.data);
        console.log(json);

        if (json.Message === "Monitor") {
            if (!_loggedIn) {
                _loggedIn = true;
                if (_service.onLoggedIn) {
                    _service.onLoggedIn();
                }
            }
        }

        //
        else if (json.Message === "File List Response") {
            if (json.Status === "Fail") {
            } else {
                var folder = json.Folder;
                folder = folder.trimStrEnd('/');
                var deferred = _fileListPromises[folder];
                if (null !== deferred) {
                    deferred.resolve(json);
                    _fileListPromises[folder] = null;
                }
            }
        }

        //
        else if (json.Message === "Registry Response") {
            for (var key in json.Keys) {
                if (json.Keys.hasOwnProperty(key)) {
                    var value = json.Keys[key];
                    var deferred = _registryReadPromises[key];
                    if (null !== deferred) {
                        deferred.resolve(key, value);
                        _registryReadPromises[key] = null;
                    }
                }
            }
        }

        //
        else if (json.Message === "File Read Response") {
            if (json.Status === "Fail") {
            } else {
                var file = json.File;
                var deferred = _readFilePromises[file];
                if (null !== deferred) {
                    deferred.resolve(json);
                    _readFilePromises[file] = null;
                }
            }
        }

        // 
        else if (json.Message === "File Write Response") {
            var filename = json.File;
            var deferred = _writeFilePromises[filename];
            if (null !== deferred) {
                deferred.resolve(json);
                _writeFilePromises[filename] = null;
            }
        }

        // 
        else if (json.Message === "File Rename Response") {
            var filename = json.Old;
            var deferred = _renameFilePromises[filename];
            if (null !== deferred) {
                deferred.resolve(json);
                _renameFilePromises[filename] = null;
            }
        }

        //
        else if (json.Message === "File Remove Response") {
            var filename = json.Succeed[0];
            var deferred = _removeFilePromises[filename];
            if (null !== deferred) {
                deferred.resolve(json);
                _removeFilePromises[filename] = null;
            }
        }

        //
        else if (json.Message === "Reply Message") {
//            if (_appId === json.Number) {
                if ("ping-resp" === json.Content) {
                    console.log('ping acknolwedged');
                } else {
                    _service.onReplyMessage(json);
                }
                // any message received from the application should acknowledge the ping
                _pingAcknowledged = true;
//            }
        }
    };


    _service.connect = function () {
        _comm = new Comm();
        _comm.onopen = _service.onOpened;
        _comm.onclose = function () {
            _loggedIn = false;
            if (_service.onClosed)
                _service.onClosed();
        };
        _comm.onerror = _service.onError;
        _comm.onmessage = onmessage;
        _comm.connect();
    };


    _service.registryRead = function (key) {
        var deferred = $.Deferred();
        _registryReadPromises[key] = deferred;
        var jsonRequest = {
            "Message": "Registry Read",
            "Keys": [key]
        };
        _comm.sendJson(jsonRequest);
        return deferred.promise();
    };


    _service.registryWrite = function (key, value) {
        var jsonRequest = {
            "Message": "Registry Write",
            "Keys": {}
        };
        jsonRequest.Keys[key] = value;
        _comm.sendJson(jsonRequest);
    };


    _service.getFileListing = function (folder) {
        folder = folder.trimStrEnd('/');
        var deferred = $.Deferred();
        _fileListPromises[folder] = deferred;
        var jsonRequest = {Message: "File List", Folder: folder};
        _comm.sendJson(jsonRequest);
        return deferred.promise();
    };


    _service.readFile = function (filename) {
        if (!filename.startsWith('/')) {
            filename = '/' + filename;
        }
        var deferred = $.Deferred();
        _readFilePromises[filename] = deferred;
        var jsonRequest = {Message: "File Read", File: filename};
        _comm.sendJson(jsonRequest);
        return deferred.promise();
    };


    _service.downloadFile = function (filename) {
        if (!filename.startsWith('/')) {
            filename = '/' + filename;
        }
        var deferred = $.Deferred();
        _readFilePromises[filename] = deferred;

        var requestid = Math.floor(Math.random() * 1000000000000000);
        var url = document.baseURI;
        if (!url)
            url = location.href;
        var pos = url.indexOf("//");
        if (pos > 0) {
            pos = url.indexOf("/", pos + 2);
            if (pos > 0)
                url = url.substring(0, pos);
            url += "/query.cgi?request=" + requestid;
        }

        var jsonRequest = {Message: "File Read", Meta: url, File: filename, RequestID: requestid};
        _comm.sendJson(jsonRequest);
        return deferred.promise();
    };


    _service.writeFile = function (filename, content) {
        var deferred = $.Deferred();
        _writeFilePromises[filename] = deferred;
        var fileData = btoa(content);
        var jsonRequest = {
            Message: "File Write",
            File: filename,
            Size: content.length,
            Encoding: "base64",
            Data: fileData};
        _comm.sendJson(jsonRequest);
        return deferred.promise();
    };


    _service.renameFile = function (oldFilename, newFilename) {
        var deferred = $.Deferred();
        _renameFilePromises[oldFilename] = deferred;
        var jsonRequest = {Message: "File Rename", Old: oldFilename, New: newFilename};
        _comm.sendJson(jsonRequest);
        return deferred.promise();
    };


    _service.removeFile = function (filename) {
        var deferred = $.Deferred();
        _removeFilePromises[filename] = deferred;
        var jsonRequest = {Message: "File Remove", Files: [filename]};
        _comm.sendJson(jsonRequest);
        return deferred.promise();
    };


    _service.postMessage = function (number, message) {
        var jsonRequest = {Message: "Post Message", Number: number, Content: message};
        _comm.sendJson(jsonRequest);
    };

}