/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.dmx;

import com.integpg.dmx.AssemblyInfo;
import com.integpg.dmx.Config;
import com.integpg.dmx.DmxDimmer;
import com.integpg.dmx.DmxDimmers;
import com.integpg.dmx.UpdatedChannels;
import com.integpg.janoslib.logging.AppLog;
import com.integpg.janoslib.logging.Logger;
import com.integpg.system.ArrayUtils;
import com.integpg.system.Immutable;

public class DmxPort {
    private static final Logger LOG = Logger.getLogger("/temp/" + AssemblyInfo.getName() + "_dmxport.log").setMaxSizeKB(128);
    private static final Object LOCK = new Object();
    private byte[] _dmxChannels;
    private UpdatedChannels _updatedChannels = new UpdatedChannels();

    public DmxPort() {
        this._dmxChannels = Immutable.getByteArray((String)"DMX512_1");
        if (null == this._dmxChannels) {
            AppLog.info("create dmx immutable buffer");
            this._dmxChannels = Immutable.createByteArray((String)"DMX512_1", (int)512);
        } else {
            AppLog.info("opened dmx immutable buffer");
        }
        DmxDimmers.updateDimmers(this._dmxChannels);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getChannels(int startChannel, int length) {
        byte[] channels = new byte[length];
        Object object = LOCK;
        synchronized (object) {
            ArrayUtils.arraycopy((Object)this._dmxChannels, (int)startChannel, (Object)channels, (int)0, (int)length);
        }
        return channels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChannel(int channel, byte val) {
        Object object = LOCK;
        synchronized (object) {
            this._dmxChannels[channel - 1] = val;
            this._updatedChannels.updateChannelRange(channel, channel);
        }
        if (0 < Config.getDmxDimmers().length) {
            boolean writeToDimmers = false;
            for (DmxDimmer dmxDimmer : Config.getDmxDimmers()) {
                if (-1 == dmxDimmer.StartAddress || channel >= dmxDimmer.getEndAddress() || channel < dmxDimmer.StartAddress) continue;
                dmxDimmer.Dirty = true;
                writeToDimmers = true;
            }
            if (writeToDimmers) {
                DmxDimmers.updateDimmers(this._dmxChannels);
            }
        }
    }

    public void setChannels(int startChannel, byte[] bytes) {
        this.setChannels(startChannel, bytes, 0, bytes.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChannels(int startChannel, byte[] bytes, int offset, int length) {
        int endChannel = startChannel + length - 1;
        Object object = LOCK;
        synchronized (object) {
            ArrayUtils.arraycopy((Object)bytes, (int)offset, (Object)this._dmxChannels, (int)(startChannel - 1), (int)length);
            this._updatedChannels.updateChannelRange(startChannel, endChannel);
        }
        if (0 < Config.getDmxDimmers().length) {
            boolean writeToDimmers = false;
            for (DmxDimmer dmxDimmer : Config.getDmxDimmers()) {
                if (-1 == dmxDimmer.StartAddress || startChannel >= dmxDimmer.getEndAddress() || endChannel < dmxDimmer.StartAddress) continue;
                dmxDimmer.Dirty = true;
                writeToDimmers = true;
            }
            if (writeToDimmers) {
                DmxDimmers.updateDimmers(this._dmxChannels);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChannels(int startChannel, byte[] channelStates, byte[] channelMask) {
        Object object = LOCK;
        synchronized (object) {
            for (int i = 0; i < channelStates.length; ++i) {
                int channelOffset = i + startChannel - 1;
                int channelMaskBit = channelMask[channelOffset / 8] >> channelOffset % 8 & 1;
                if (1 == channelMaskBit) continue;
                channelStates[i] = this._dmxChannels[i + startChannel - 1];
            }
        }
        this.setChannels(startChannel, channelStates);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void adjustChannels(int startChannel, int[] channelDelta, byte[] channelMask) {
        byte[] channelStates = new byte[channelDelta.length];
        Object object = LOCK;
        synchronized (object) {
            for (int i = 0; i < channelDelta.length; ++i) {
                int channelOffset = i + startChannel - 1;
                int channelMaskBit = channelMask[channelOffset / 8] >> channelOffset % 8 & 1;
                if (1 == channelMaskBit) {
                    int newValue = (this._dmxChannels[i + startChannel - 1] & 0xFF) + channelDelta[i];
                    if (0 > newValue) {
                        newValue = 0;
                    }
                    if (255 < newValue) {
                        newValue = 255;
                    }
                    channelStates[i] = (byte)newValue;
                    continue;
                }
                channelStates[i] = this._dmxChannels[i + startChannel - 1];
            }
        }
        this.setChannels(startChannel, channelStates);
    }

    public byte[] getChannels() {
        return this._dmxChannels;
    }

    public UpdatedChannels getUpdatedChannelsStructure() {
        return this._updatedChannels;
    }
}

