/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.dmx.effects;

import com.integpg.dmx.DmxMain;
import com.integpg.dmx.effects.Effect;

public class MarchEffect
extends Effect {
    private final int _channelNumber;
    private final byte[] _bytes;
    private final int _stepIncrement;
    private final long _startTime = System.currentTimeMillis();
    private int _lastStep = -1;

    public MarchEffect(int channelNumber, byte[] bytes) {
        this._channelNumber = channelNumber;
        this._bytes = bytes;
        this._stepIncrement = 1;
    }

    public MarchEffect(int channelNumber, byte[] bytes, int stepIncrement) {
        this._channelNumber = channelNumber;
        this._bytes = bytes;
        this._stepIncrement = stepIncrement;
    }

    @Override
    public void update() {
        long now = System.currentTimeMillis();
        long elapsed = now - this._startTime;
        int steps = (int)(elapsed / 250L);
        if (this._lastStep != steps) {
            this._lastStep = steps;
            steps = (int)((double)steps % ((double)this._bytes.length / (double)this._stepIncrement));
            if (0 != (steps *= this._stepIncrement)) {
                DmxMain.DMX_PORTS[0].setChannels(this._channelNumber, this._bytes, this._bytes.length - steps, steps);
            }
            DmxMain.DMX_PORTS[0].setChannels(this._channelNumber + steps, this._bytes, 0, this._bytes.length - steps);
        }
    }

    @Override
    public boolean isComplete() {
        return false;
    }
}

