/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.dmx.fixtures;

import com.integpg.dmx.fixtures.Fixture;
import com.integpg.dmx.fixtures.FixtureFile;
import com.integpg.janoslib.logging.AppLog;
import java.io.File;
import java.util.Hashtable;

public class FixtureManager {
    private static final Hashtable<Integer, Fixture> FIXTURE_COLLECTION = new Hashtable();

    public static void loadFixtures() {
        AppLog.info("Loading Fixtures");
        File file = new File("flash/dmx/fixtures/fixtures.json");
        if (file.exists()) {
            try {
                FixtureFile fixtureFile = new FixtureFile(file);
                fixtureFile.process();
                for (Fixture fixture : fixtureFile.getFixtures()) {
                    FIXTURE_COLLECTION.put(fixture.getId(), fixture);
                }
            }
            catch (Exception ex) {
                AppLog.error("error loading fixtures", ex);
            }
            AppLog.info(FIXTURE_COLLECTION.size() + " fixtures loaded");
        }
    }

    public static Fixture getById(int id) {
        return FIXTURE_COLLECTION.get(id);
    }
}

