/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.dmx.actions;

import com.integpg.dmx.DmxMain;
import com.integpg.dmx.actions.At;
import com.integpg.dmx.actions.Command;
import com.integpg.system.ArrayUtils;

public class TestCommand
extends Command {
    private final int _startingAddress;

    public TestCommand(String parameters) {
        System.out.println("test command: " + parameters);
        this._startingAddress = Integer.parseInt(parameters);
    }

    @Override
    public void execute(At at) {
        try {
            byte[] newPreviousChannelValues = DmxMain.DMX_PORTS[0].getChannels(this._startingAddress, 3);
            int previsousChannelOffset = 0;
            byte[] previousChannelValues = null;
            byte[] green = new byte[]{0, 64, 0};
            for (int j = 0; j < 19; ++j) {
                int newChannelOffset = this._startingAddress + (j * 3 + 1);
                if (previsousChannelOffset + 3 == newChannelOffset) {
                    byte[] channelValues = new byte[6];
                    ArrayUtils.arraycopy(previousChannelValues, (int)0, (Object)channelValues, (int)0, (int)3);
                    ArrayUtils.arraycopy((Object)green, (int)0, (Object)channelValues, (int)3, (int)3);
                    DmxMain.DMX_PORTS[0].setChannels(previsousChannelOffset, channelValues);
                } else {
                    if (null != previousChannelValues) {
                        DmxMain.DMX_PORTS[0].setChannels(previsousChannelOffset, previousChannelValues);
                    }
                    DmxMain.DMX_PORTS[0].setChannels(newChannelOffset, green);
                }
                previousChannelValues = newPreviousChannelValues;
                previsousChannelOffset = newChannelOffset;
                Thread.sleep(100L);
            }
            if (null != previousChannelValues) {
                DmxMain.DMX_PORTS[0].setChannels(previsousChannelOffset, previousChannelValues);
            }
        }
        catch (InterruptedException ex) {
            ex.printStackTrace(System.err);
        }
    }
}

