var JnrWebsocket = new JnrWebsocket();

var app = angular.module('DmxApp', []);

var DmxScope;
var DmxController;
app.controller('DmxController', ['$scope', '$compile', function ($scope, $compile) {
    DmxScope = $scope;
    DmxController = this;

    DmxController.AllChannels = [];
    for (var i = 0; i < 512; i++) {
        DmxController.AllChannels[i] = i + 1;
    }

    DmxController.Fixtures = null;
    DmxController.SceneName = getParameterByName("sceneName");

    DmxController.Scene = {};
    DmxController.Scene.Name = "";
    DmxController.Scene.StepInterval = 100;
    DmxController.Scene.Steps = [];

    DmxController.SavedScene = angular.copy(DmxController.Scene);
    DmxController.StepIndex = 0;


    DmxController.activateView = function (ele) {
        $compile(ele.contents())($scope);
        $scope.$apply();
    };


    DmxController.hasChanged = function () {
        var hasChanged = !angular.equals(DmxController.Scene, DmxController.SavedScene);
        return hasChanged;
    };


    DmxController.save = function () {
        var Scene = {};
        Scene.Name = DmxController.Scene.Name;
        Scene.StepInterval = DmxController.Scene.StepInterval;
        Scene.Steps = [];
        for (var stepIndex = 0; stepIndex < DmxController.Scene.Steps.length; stepIndex++) {
            var step = DmxController.Scene.Steps[stepIndex];
            var Channels = [];

            var previousChannel;
            var previousChannelValue;

            for (var channelIndex = 0; channelIndex < step.Channels.length; channelIndex++) {
                var channel = step.Channels[channelIndex];
                if (channel.UseChannel) {
                    Channels.push({ Channel: channelIndex + 1, Value: channel.Value });
                }
            }
            Scene.Steps.push({ Channels: Channels });
        }
        var sceneContentString = JSON.stringify(Scene, null, 2);
        JnrWebsocket.writeFile("/flash/dmx/scenes/" + Scene.Name + ".json", sceneContentString).then(writeFileComplete);
    };


    var writeFileComplete = function (json) {
        var filename = json.File;
        if (filename.startsWith("/flash/dmx/scenes/")) {
            alert(filename + " saved");

            JnrWebsocket.postMessage(1401, {
                Command: "update-script",
                ScriptName: filename
            });
        }
    };


    DmxController.getChannels = function (row, group) {
        var channels = [];
        if (DmxController.StepIndex < DmxController.Scene.Steps.length) {
            var step = DmxController.Scene.Steps[DmxController.StepIndex];
            var startChannel = (row * 100) + (group * 10);
            for (var i = startChannel; i < 512 && i < startChannel + 10; i++) {
                channels.push(step.Channels[i]);
            }
        }
        return channels;
    };


    JnrWebsocket.onLoggedIn = function () {
        JnrWebsocket.readFile("/flash/dmx/fixtures/fixtures.json").then(fixtureFileRead);
        if (DmxController.SceneName && null != DmxController.SceneName) {
            JnrWebsocket.readFile("/flash/dmx/scenes/" + DmxController.SceneName).then(sceneFileRead);
        }
    };


    // DmxController.addStep = function () {
    //     var channels = [];
    //     for (var i = 0; i < 512; i++) {
    //         channels[i] = new SceneChannel(); // { UseChannel: false, Value: null.toLong(), changed: validateChannelValue };
    //     }
    //     DmxController.Scene.Steps.push({ Channels: channels });
    // };


    DmxController.insertBeforeStep = function () {
        var channels = [];
        for (var i = 0; i < 512; i++) {
            channels[i] = new SceneChannel();
        }
        DmxController.Scene.Steps.splice(DmxController.StepIndex, 0, { Channels: channels });
        DmxController.StepIndex++;
    };


    DmxController.insertAfterStep = function () {
        var channels = [];
        for (var i = 0; i < 512; i++) {
            channels[i] = new SceneChannel();
        }
        DmxController.Scene.Steps.splice(DmxController.StepIndex + 1, 0, { Channels: channels });
    };


    DmxController.removeStep = function () {
        DmxController.Scene.Steps.splice(DmxController.StepIndex, 1);
    };


    DmxController.prevStep = function () {
        DmxController.StepIndex--;
    };


    DmxController.setStep = function (stepIndex) {
        DmxController.StepIndex = stepIndex;
    };


    DmxController.nextStep = function () {
        DmxController.StepIndex++;
    };


    DmxController.PlayTimer = null;
    DmxController.playScene = function () {
        DmxController.PlayTimer = setInterval(function () {
            DmxController.StepIndex++;
            if (DmxController.Scene.Steps.length == DmxController.StepIndex) {
                DmxController.StepIndex = 0;
            }
            $scope.$apply();
        }, DmxController.Scene.StepInterval);
    };


    DmxController.stopScene = function () {
        if (null != DmxController.PlayTimer) {
            clearInterval(DmxController.PlayTimer);
            DmxController.PlayTimer = null;
        }
    };


    function validateChannelValue() {
        this.UseChannel = true;
        if (!this.Value) this.Value = 0;
        if (0 > this.Value)
            this.Value = 0;
        if (255 < this.Value)
            this.Value = 255;
    }


    var fixtureFileRead = function (json) {
        var filename = json.File;
        if (filename.endsWith("flash/dmx/fixtures/fixtures.json")) {
            var fileContent = Base64.decode(json.Data);
            console.log(fileContent);
            var fixtureJson = JSON.parse(fileContent);
            DmxController.Fixtures = fixtureJson.Fixtures;

            $scope.$apply();
        }
    };


    var sceneFileRead = function (json) {
        var filename = json.File;
        if (filename.includes("flash/dmx/scenes")) {
            var fileContent = Base64.decode(json.Data);
            console.log(fileContent);
            var sceneJson = JSON.parse(fileContent).scene;

            var steps = [];
            for (var stepIndex in sceneJson.steps) {
                var stepJson = sceneJson.steps[stepIndex];
                var channels = processStep(stepJson);
                steps.push({ Channels: channels });
            }

            DmxController.Scene = {};
            DmxController.Scene.Name = sceneJson.name;
            DmxController.Scene.StepInterval = sceneJson.stepInterval;
            DmxController.Scene.Steps = steps;

            DmxController.SavedScene = angular.copy(DmxController.Scene);

            $scope.$apply();
        }
    };


    function SceneChannel() {
        this.UseChannel = false;
        this.Value;
        this.changed = validateChannelValue;
    }


    function ChannelsJson() {
        this.StartChannel;
        this.EndChannel;
        this.Value;
    }


    var processStep = function (stepJson) {
        var channels = [];
        for (var i = 0; i < 512; i++) {
            channels[i] = new SceneChannel(); // { UseChannel: false, Value: 0, changed: validateChannelValue };
        }

        for (var channelsIndex in stepJson.channels) {
            var channelsJson = stepJson.channels[channelsIndex];

            if (channelsJson.channel) {
                var channel = channelsJson.channel - 1;

                if (channelsJson.Value) {
                    channels[channel].UseChannel = true;
                    channels[channel].Value = channelsJson.Value;

                } else if (channelsJson.Values) {
                    for (var valueIndex in channelsJson.Values) {
                        channels[channel].UseChannel = true;
                        channels[channel++].Value = channelsJson.Values[valueIndex];
                    }
                }
            } else {
                if (channelsJson.StartChannel) {
                    // var channels = channelsJson; //new Channels();
                    //channels.parseJson(channelsJson);

                    var startChannel = channelsJson.StartChannel - 1;
                    // var endChannel = channelsJson.EndChannel - 1;
                    while (startChannel < channelsJson.EndChannel) {
                        channels[startChannel].UseChannel = true;
                        channels[startChannel++].Value = channelsJson.Value;
                    }
                }
            }
        }

        return channels;
    };


    JnrWebsocket.onReplyMessage = function (replyContentJson) {
        var contentJson = JSON.parse(replyContentJson.Content);
        if ("channel-update" === contentJson.Message) {
            var channelsString = contentJson.Channels;
            var channel = contentJson.Min - 1;
            for (var c = 0; c < channelsString.length; c += 2) {
                var channelValue = parseInt(channelsString.substr(c, 2), 16);
                DmxController.Channels[channel++] = channelValue;
            }

        } else {
            var content = replyContentJson.Content;
            var fields = content.split(",");
            var channel = fields[0];
            var value = fields[1];
            DmxController.Channels[channel] = value;
        }

        $scope.$apply();
    };


    DmxController.getChannelName = function (channel) {
        if (null !== DmxController.Fixtures) {
            for (var i = 0; i < DmxController.Fixtures.length; i++) {
                var fixture = DmxController.Fixtures[i];
                if (fixture.StartChannel <= channel && (fixture.StartChannel + fixture.ChannelCount - 1) >= channel) {
                    return fixture.Name;
                }
            }
        }
        return "no fixture defined";
    };


    JnrWebsocket.connect();
    if (!DmxController.SceneName || null === DmxController.SceneName) {
        DmxController.insertBeforeStep();
    }
}
]);

