/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.dmx;

import com.integpg.dmx.ArtNet;
import com.integpg.dmx.AssemblyInfo;
import com.integpg.dmx.ChannelUpdater;
import com.integpg.dmx.Config;
import com.integpg.dmx.DmxCommandLine;
import com.integpg.dmx.DmxPort;
import com.integpg.dmx.JniorProtocolListener;
import com.integpg.dmx.PingHandler;
import com.integpg.dmx.ScriptFile;
import com.integpg.dmx.ScriptFileCollection;
import com.integpg.dmx.TriggerManager;
import com.integpg.dmx.UdpServer;
import com.integpg.dmx.WebPageListener;
import com.integpg.dmx.client.ClientConnection;
import com.integpg.dmx.client.ClientConnectionListener;
import com.integpg.dmx.effects.EffectExecutor;
import com.integpg.dmx.fixtures.FixtureManager;
import com.integpg.dmx.fixtures.FixtureTypeManager;
import com.integpg.dmx.scenes.SceneManager;
import com.integpg.dmx.web.ChaseWebHandler;
import com.integpg.dmx.web.SceneWebHandler;
import com.integpg.dmx.web.ScriptWebHandler;
import com.integpg.janoslib.logging.AppLog;
import com.integpg.janoslib.logging.Logger;
import com.integpg.janoslib.messagepump.MessagePumpEngine;
import com.integpg.janoslib.net.IClient;
import com.integpg.janoslib.net.NullClient;
import com.integpg.janoslib.net.http.server.WebHandlerServer;
import com.integpg.janoslib.net.tcp.TcpServer;
import com.integpg.janoslib.net.tcp.TcpServerEvent;
import com.integpg.janoslib.net.tcp.TcpServerListener;
import com.integpg.janoslib.system.JanosApplication;
import com.integpg.janoslib.threading.ThreadPool;
import com.integpg.system.JANOS;
import com.integpg.system.MessagePump;
import com.integpg.system.SystemMsg;
import com.integpg.system.Watchdog;
import java.io.File;
import java.net.Socket;

public class DmxMain
extends JanosApplication
implements TcpServerListener,
ClientConnectionListener {
    private Watchdog _watchdog = null;
    public static final DmxPort[] DMX_PORTS = new DmxPort[1];
    public static final EffectExecutor EFFECTS = new EffectExecutor();

    public static void main(String[] args) {
        try {
            DmxMain.exec(new DmxMain(), new AssemblyInfo(), args);
        }
        catch (Exception ex) {
            AppLog.error(ex);
            System.exit(-1);
        }
    }

    @Override
    public boolean shouldPreventDuplicateInstance() {
        return true;
    }

    @Override
    public void initWatchdog() {
        this._watchdog = new Watchdog(AssemblyInfo.getName());
        this._watchdog.setAction(0);
        this._watchdog.setDuration(120000);
        this._watchdog.activate();
    }

    @Override
    public void init(String[] args) {
        String[] fileNames;
        File scriptsDirectory;
        File dmxFixturesDirectory;
        Config.init();
        DmxMain.DMX_PORTS[0] = new DmxPort();
        File dmxDirectory = new File("/flash/dmx");
        if (!dmxDirectory.exists()) {
            AppLog.info("create " + dmxDirectory);
            dmxDirectory.mkdir();
        }
        if (!(dmxFixturesDirectory = new File("/flash/dmx/fixtures")).exists()) {
            AppLog.info("create " + dmxFixturesDirectory);
            dmxFixturesDirectory.mkdir();
        }
        if (!(scriptsDirectory = new File("/flash/dmx/scripts")).exists()) {
            AppLog.info("create " + scriptsDirectory);
            scriptsDirectory.mkdir();
        }
        long scriptLoadStart = JANOS.uptimeMillis();
        for (String filename : fileNames = scriptsDirectory.list()) {
            if (!filename.endsWith(".script") || filename.startsWith("~")) continue;
            ScriptFile scriptFile = new ScriptFile("/flash/dmx/scripts/" + filename);
            scriptFile.loadFile();
            String scriptName = scriptFile.getFile().getName();
            scriptName = scriptName.substring(0, scriptName.indexOf("."));
            ScriptFileCollection.put(scriptName.toLowerCase(), scriptFile);
        }
        long scriptLoadElapsed = JANOS.uptimeMillis() - scriptLoadStart;
        AppLog.info(String.format("took %.2f to load %d script files", (double)scriptLoadElapsed / 1000.0, ScriptFileCollection.size()));
        FixtureTypeManager.loadFixtureTypes();
        FixtureManager.loadFixtures();
        SceneManager.loadScenes();
        this.startUdpServer();
        this.startTcpServer();
        TriggerManager.load();
        Thread thd = new Thread(new Runnable(){

            @Override
            public void run() {
                MessagePump pump = new MessagePump();
                pump.open();
                while (true) {
                    DmxMain.this._watchdog.refresh();
                    System.out.print(".");
                    try {
                        SystemMsg systemMsg = pump.getMessage(1400);
                        pump.postMessage(systemMsg);
                        String text = new String(systemMsg.msg);
                        int pos = text.indexOf(",");
                        if (-1 == pos) continue;
                        String sliderChannelString = text.substring(0, pos);
                        int val = Integer.parseInt(text.substring(pos + 1));
                        System.out.println("sliderChannelString: " + sliderChannelString);
                        int chan = Integer.parseInt(sliderChannelString);
                        System.out.println("chan: " + chan);
                        if (chan <= 0 || chan > 512) continue;
                        DMX_PORTS[0].setChannel(chan, (byte)val);
                        continue;
                    }
                    catch (Exception ex) {
                        AppLog.error(ex);
                        continue;
                    }
                    break;
                }
            }
        });
        thd.setName("Panel");
        thd.start();
        MessagePumpEngine.addListener(new PingHandler());
        MessagePumpEngine.addListener(new WebPageListener());
        MessagePumpEngine.addListener(new JniorProtocolListener());
        MessagePumpEngine.start();
        ChannelUpdater channelUpdater = new ChannelUpdater();
        channelUpdater.start();
        this.initWebServer();
        EFFECTS.start();
        AppLog.info("DMX ready...", true);
        if (0 < args.length) {
            System.out.println("args[0] = " + args[0]);
            DmxCommandLine.process(NullClient.getInstance(), args[0]);
        }
    }

    private void startUdpServer() {
        UdpServer udpServer = new UdpServer(6454);
        udpServer.setListener(new ArtNet());
        udpServer.start();
    }

    private void startTcpServer() {
        try {
            Config.getTerminationBytes();
            int tcpServerPort = Config.getTcpServerPort();
            TcpServer tcpServer = new TcpServer("DMX Tcp Server", tcpServerPort);
            tcpServer.setTcpServerListener(this);
            tcpServer.start();
        }
        catch (Exception ex) {
            AppLog.error(ex);
            JANOS.logfile((String)"errors.log", (String)String.format("[%s] %s", AssemblyInfo.getName(), ex.getMessage()));
        }
    }

    @Override
    public void clientConnected(TcpServerEvent evt) {
        Socket socket = evt.getSocket();
        Logger.getLogger("test").info(String.format("dmx client connected: %s:%d", socket.getInetAddress().getHostAddress(), socket.getPort()));
        ClientConnection clientConnection = new ClientConnection(socket);
        clientConnection.setListener(this);
        ThreadPool.execute(clientConnection);
    }

    @Override
    public void processMessage(IClient client, String message) {
        DmxCommandLine.process(client, message);
    }

    @Override
    public void run() throws InterruptedException {
        System.out.println("run...");
        while (true) {
            this._watchdog.refresh();
            Thread.sleep(30000L);
        }
    }

    private void initWebServer() {
        WebHandlerServer webHandlerServer = new WebHandlerServer();
        webHandlerServer.addWebHandler("/chase", new ChaseWebHandler());
        webHandlerServer.addWebHandler("/scene", new SceneWebHandler());
        webHandlerServer.addWebHandler("/script", new ScriptWebHandler());
        int webServerPort = Config.getWebServerPort();
        webHandlerServer.start(webServerPort);
    }

    protected void finalize() throws Throwable {
        try {
            AppLog.notice("DMX terminating...");
        }
        finally {
            super.finalize();
        }
    }
}

