/* global bootbox, DmxApp */

DmxApp.controller('ScriptController', function ($scope, $compile, ScriptService) {
    var _this = this;


    _this.getScripts = function () {
        return ScriptService.Config.Scripts;
    };



    _this.hasScriptBeenRemoved = function (script) {
        return (script.Removed);
    };


    _this.hasScriptChanged = function (script) {
        return (script.OldName && script.OldName !== script.Name)
            || (script.OldContent && script.OldContent !== script.Content);
    };

    
    _this.save = function () {
        ScriptService.save();
    };


    _this.addScript = function () {
        bootbox.prompt({
            title: "What is the name of the new script?",
            callback: function (result) {
                if (result) {
                    if (!result.endsWith(".script"))
                        result += ".script";

                    if (ScriptService.Config.Scripts) {
                        for (var i = 0; i < ScriptService.Config.Scripts.length; i++) {
                            if (ScriptService.Config.Scripts[i].name === result)
                                return;
                        }
                    }

                    if (null === ScriptService.Config.Scripts) {
                        ScriptService.Config.Scripts = [];
                    }
                    var newScriptContent = "// new script";
                    JnrWebsocket.writeFile("/flash/dmx/scripts/" + result, newScriptContent).then(ScriptService.writeFileComplete);
                    ScriptService.ScriptsByName[result] = { Name: result, Content: newScriptContent, OldContent: "//" };

                    var re = new RegExp("^(\/\/[^\n]*\n?)*");
                    var match = re.exec(newScriptContent);
                    console.log(match);
                    ScriptService.ScriptsByName[result].Comment = match[0].replaceAll("//", "");

                    ScriptService.Config.Scripts.push(ScriptService.ScriptsByName[result]);

                    $scope.$apply();
                }
            }
        });
    };


    _this.addActionToDialog = function (actionToAdd, hidden, disabled) {
        var actionElement = "<a href='javascript: void(0)' ";
        if (hidden)
            actionElement += "style='display:none;' ";
        if (disabled)
            actionElement += "class='disabled' ";
        actionElement += "onclick='addActionToEditor(this)'>" + actionToAdd + "</a>";
        if (!hidden)
            actionElement += "<br />";
        return actionElement;
    };


    addActionToEditor = function (element) {
        var editor = $("#actions-text")[0];

        var selectionStart = editor.selectionStart;
        if (-1 !== selectionStart && editor.value.length !== selectionStart) {
            var textBefore = editor.value.substr(0, selectionStart);
            var beginningOfCurrentLine = textBefore.lastIndexOf("\n") + 1;
            editor.selectionStart = beginningOfCurrentLine;
            if (editor.value.length === editor.selectionStart) {
                insert(editor, "\n");
            }
        }

        insertText(editor, element.innerText + "\n");
    };


    _this.editScript = function (script) {
        var dialog = bootbox.dialog({
            className: "fullscreen",
            title: "Edit Actions",
            message: "<div style='float: right; width: 500px; height: calc(100% + 30px); margin: -15px; overflow-y: scroll;'>"
                + "<h3>Timing</h3>"
                + _this.addActionToDialog('delay( seconds )')
                + _this.addActionToDialog('delayMillis(milliseconds)')
                + _this.addActionToDialog('@( seconds )')
                + "<h3>DMX Operations</h3>"
                + "<b>set a channel to a value</b><br>"
                + _this.addActionToDialog('set(channel = value)')
                + "<b>set a range of channels at once to a single value</b><br>"
                + _this.addActionToDialog('set(startchannel-endchannel = value)')
                + "<b>set multiple channels at once to a single value</b><br>"
                + _this.addActionToDialog('set(channel1, channel2, channel3 = value)')
                + "<b>set multiple channels at once to multiple values</b><br>"
                + _this.addActionToDialog('set(channel1, channel2, channel3 = value1, value2, value3)')
                + "<b>fade a channel to a value over a duration</b><br>"
                + _this.addActionToDialog('fade(channel = value : duration)')
                + "<b>fade a range of channels at once to a single value over a duration</b><br>"
                + _this.addActionToDialog('fade(startchannel-endchannel = value : duration)')
                + "<b>fade multiple channels at once to a single value over a duration</b><br>"
                + _this.addActionToDialog('fade(channel1, channel2, channel3 = value : duration)')
                + "<b>fade multiple channels at once to multiple values over a duration</b><br>"
                + _this.addActionToDialog('fade(channel1, channel2, channel3 = value1, value2, value3 : duration)')
                + _this.addActionToDialog('scene(scenename)', hidden = true)
                + _this.addActionToDialog('scene(scenename)', hidden = true)
                + "</div>"
                + "<textarea id='actions-text' style='background-color: #fff; border: 0; margin: -15px; width: calc(100% - 500px); height: calc(100% + 30px); padding: 8px;'></textarea>",
            buttons: {
                cancel: {
                    label: 'Cancel',
                    className: 'btn-default'
                },
                confirm: {
                    label: 'Set',
                    className: 'btn-primary',
                    callback: function () {
                        var content = $("#actions-text").val();

                        if (content !== script.Content) {
                            if (!script.OldContent) {
                                script.OldContent = script.Content;
                            }

                            script.Content = content;

                            var re = new RegExp("^(\/\/[^\n]*\n?)*");
                            var match = re.exec(script.Content);
                            console.log(match);
                            script.Comment = match[0].replaceAll("//", "");

                            $scope.$apply();
                        }
                    }
                }
            }
        });
        dialog.init(function () {
            $(".modal-header").css("background-color", "#428bca");
            $(".modal-header").css("color", "#fff");
            $(".modal-body").css("overflow-y", "hidden");

            if (script.Content) {
                $("#actions-text").val(script.Content);
            }
        });
    };


    _this.renameScript = function (script) {
        var oldName = script.Name;

        bootbox.prompt({
            title: "What is the new name of the script file?",
            value: oldName,
            callback: function (result) {
                if (result) {
                    if (!result.endsWith(".script"))
                        result += ".script";

                    if (result !== script.Name) {
                        if (!script.OldName) {
                            script.OldName = script.Name;
                        }
                        script.Name = result;

                        $scope.$apply();
                    }
                }
            }
        }).init(function () {
            $(".modal-header").css("background-color", "#428bca");
            $(".modal-header").css("color", "#fff");
        });
    };


    _this.removeScript = function (script) {
        var dialog = bootbox.confirm({
            title: "Are you sure you want to remove " + script.Name,
            message: "<b>" + script.Name + "</b> will be removed when you click Save Changes.  Once you successfully "
                + "Save the Changes the script will be permenantly removed.",
            buttons: {
                cancel: {
                    label: 'Cancel',
                    className: 'btn-default'
                },
                confirm: {
                    label: 'Remove',
                    className: 'btn-danger'
                }
            },
            callback: function (result) {
                if (result) {
                    /**
                     * we are not going to delete the script but rather rename it so that it no longer shows up.
                     */
                    if (!script.OldName) {
                        script.OldName = script.Name;
                    }
                    script.Name += ".removed";
                    script.Removed = true;

                    $scope.$apply();
                }
            }
        });
        dialog.init(function () {
            $(".modal-header").css("background-color", "#d9534f");
            $(".modal-header").css("color", "#fff");
            $("#bootbox-confirm-btn").prop('disabled', false);
            $("#bootbox-cancel-btn").prop('disabled', false);
        });
    };


    _this.executeScript = function (script) {
        _this.ExecuteDialog = bootbox.confirm({
            title: "Execute " + script.Name,
            message: "How many times should <B>" + script.Name + "</b> repeat? <input type'number' id='repeat-count' class='form-control' value='1'>",
            buttons: {
                cancel: {
                    label: 'Cancel',
                    className: 'btn-default'
                },
                confirm: {
                    label: 'Execute',
                    className: 'btn-success'
                }
            },
            callback: function (result) {
                if (result) {
                    JnrWebsocket.postMessage(1401, JSON.stringify({
                        Command: "exec-script",
                        ScriptName: script.Name,
                        RepeatCount: $("#repeat-count").val()
                    }));
                }
            }
        });
        _this.ExecuteDialog.init(function () {
            $(".modal-header").css("background-color", "#5cb85c");
            $(".modal-header").css("color", "#fff");
            $("#repeat-count").focus();
        });
    };
});



DmxApp.service('ScriptService', function ($rootScope) {
    var _this = this;
    _this.Config = {};
    _this.Config.Scripts = [];
    _this.ScriptsByName = [];
    _this.SavedConfig = angular.copy(_this.Config);

    _this.EditDialog = null;
    _this.$scope = null;


    _this.hasChanged = function () {
        var hasChanged = !angular.equals(_this.Config, _this.SavedConfig);

        for (var index = 0; !hasChanged && index < _this.Config.Scripts.length; index++) {
            var script = _this.Config.Scripts[index];
            hasChanged |= (script.OldName && script.OldName !== script.Name)
                || (script.OldContent && script.OldContent !== script.Content);
        }

        return hasChanged;
    };


    _this.load = function ($scope) {
        _this.$scope = $scope;
        JnrWebsocket.getFileListing("/flash/dmx/scripts/").then(scriptsListingReceived);
    };


    var scriptsListingReceived = function (json) {
        if (json.Folder === "/flash/dmx/scripts") {
            _this.Config.Scripts = [];

            for (var fileIndex in json.Content) {
                var scriptName = json.Content[fileIndex].Name;
                if (scriptName.endsWith(".script")) {
                    console.log(scriptName);
                    _this.ScriptsByName[scriptName] = { "Name": scriptName, "Content": "" };
                    _this.Config.Scripts.push(_this.ScriptsByName[scriptName]);

                    JnrWebsocket.readFile("/flash/dmx/scripts/" + scriptName).then(scriptFileReceived);
                }
            }

            _this.Config.Scripts.sort(function (a, b) {
                var nameA = a.Name.toUpperCase(); // ignore upper and lowercase
                var nameB = b.Name.toUpperCase(); // ignore upper and lowercase
                if (nameA < nameB) {
                    return -1;
                }
                if (nameA > nameB) {
                    return 1;
                }

                // names must be equal
                return 0;
            });

            if (_this.$scope && _this.$scope.CancelDialog) {
                _this.$scope.CancelDialog.modal('hide');
                _this.$scope.CancelDialog = null;
            }

            $rootScope.$apply();

            var scriptCollapsers = $(".script-collapser");
            scriptCollapsers.click(function (event) {
                var $collapseIcon = $(event.target);
                if ($collapseIcon.hasClass("fa-expand")) {
                    $collapseIcon.addClass("fa-compress").removeClass("fa-expand");
                } else {
                    $collapseIcon.addClass("fa-expand").removeClass("fa-compress");
                }
            });

        }
    };


    var scriptFileReceived = function (json) {
        var scriptName = json.File;
        scriptName = scriptName.substring(scriptName.lastIndexOf("/") + 1);
        if (scriptName.endsWith(".script")) {
            fileData = Base64.decode(json.Data);
            console.log(fileData);

            var re = new RegExp("^(\/\/[^\n]*\n?)*");
            var match = re.exec(fileData);
            console.log(match);
            _this.ScriptsByName[scriptName].Comment = match[0].replaceAll("//", "");
            _this.ScriptsByName[scriptName].Content = fileData;

            _this.SavedConfig = angular.copy(_this.Config);
            $rootScope.$apply();
        }
    };


    _this.save = function ($scope) {
        _this.$scope = $scope;

        /** 
          * go through each script and check to see if it has been renamed or if the script content 
          * has been modified
          */
        for (var i = _this.Config.Scripts.length - 1; i >= 0; i--) {
            var script = _this.Config.Scripts[i];

            // handle the renames.
            if (script.OldName && script.OldName !== script.Name) {
                JnrWebsocket.renameFile("/flash/dmx/scripts/" + script.OldName, "/flash/dmx/scripts/" + script.Name).then(scriptRenamed);

                if (script.Removed) {
                    _this.Config.Scripts.splice(i, 1);
                    _this.ScriptsByName[script.Name] = null;
                }
            }

            // handle if the script content was modified
            if (script.OldContent && script.OldContent !== script.Content) {
                //                    script.Content = script.Content.replaceAll("\r\n", "\n");
                //                    script.Content = script.Content.replaceAll("\n", "\r\n");
                JnrWebsocket.writeFile("/flash/dmx/scripts/" + script.Name, script.Content).then(writeFileComplete);
            }
        }
        $rootScope.$apply();

        if (null !== _this.$scope.SaveDialog) {
            _this.$scope.SaveDialog.modal('hide');
            _this.$scope.SaveDialog = null;
        }
    };


    var scriptRenamed = function (json) {
        var filename = json.Old;
        if (filename.startsWith("/flash/dmx/scripts/"))
            filename = filename.substring(filename.lastIndexOf("/") + 1);
        for (var i = _this.Config.Scripts.length - 1; i >= 0; i--) {
            if (_this.Config.Scripts[i].OldName && _this.Config.Scripts[i].OldName === filename) {
                var newFilename = json.New;
                if (newFilename.startsWith("/flash/dmx/scripts/"))
                    newFilename = newFilename.substring(newFilename.lastIndexOf("/") + 1);

                var script = _this.Config.Scripts[i];
                script.Name = newFilename;
                script.OldName = null;

                _this.ScriptsByName[newFilename] = script;
                _this.ScriptsByName[filename] = null;

                _this.SavedConfig = angular.copy(_this.Config);
                $rootScope.$apply();

                return;
            }
        }
    };


    var writeFileComplete = function (json) {
        var filename = json.File;
        if (filename.startsWith("/flash/dmx/scripts/")) {
            filename = filename.substring(filename.lastIndexOf("/") + 1);
            for (var i = _this.Config.Scripts.length - 1; i >= 0; i--) {
                if (_this.Config.Scripts[i].Name === filename) {
                    var script = _this.Config.Scripts[i];
                    script.OldContent = null;

                    _this.SavedConfig.Scripts = angular.copy(_this.Config.Scripts);
                    $rootScope.$apply();

                    JnrWebsocket.postMessage(1401, JSON.stringify({
                        Command: "update-script",
                        ScriptName: filename
                    }));

                    return;
                }
            }
        }
    };
});



var lastFocused;

//http://stackoverflow.com/questions/1064089/inserting-a-text-where-cursor-is-using-javascript-jquery
function insertText(input, text) {
    console.log(input);
    if (input === undefined) {
        return;
    }
    var scrollPos = input.scrollTop;
    var pos = 0;
    var browser = ((input.selectionStart || input.selectionStart === "0") ?
        "ff" : (document.selection ? "ie" : false));
    if (browser === "ie") {
        input.focus();
        var range = document.selection.createRange();
        range.moveStart("character", -input.value.length);
        pos = range.text.length;
    } else if (browser === "ff") {
        pos = input.selectionStart;
    }

    var front = (input.value).substring(0, pos);
    var back = (input.value).substring(pos, input.value.length);
    input.value = front + text + back;
    pos = pos + text.length;
    if (browser === "ie") {
        input.focus();
        var range = document.selection.createRange();
        range.moveStart("character", -input.value.length);
        range.moveStart("character", pos);
        range.moveEnd("character", 0);
        range.select();
    } else if (browser === "ff") {
        input.selectionStart = pos;
        input.selectionEnd = pos;
        input.focus();
    }
    input.scrollTop = scrollPos;
}