/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.dmx.effects;

import com.integpg.dmx.DmxMain;
import com.integpg.dmx.effects.Effect;

public class ExponentialFadeEffect
extends Effect {
    private long _lastUpdate = 0L;
    private final int[] _channels;
    private final int[] _initialValues;
    private final int[] _newValues;
    private final byte[] _bytes;
    private final int _duration;
    private final boolean _repeat = false;
    private final long _startTime = System.currentTimeMillis();
    private int _updates = 0;

    public ExponentialFadeEffect(int[] channels, int[] newValues, int duration) {
        this._channels = channels;
        this._newValues = newValues;
        this._bytes = new byte[this._channels.length];
        this._duration = duration;
        this._initialValues = new int[newValues.length];
        byte[] dmxChannels = DmxMain.DMX_PORTS[0].getChannels();
        for (int i = 0; i < this._channels.length; ++i) {
            this._initialValues[i] = dmxChannels[channels[i] - 1] & 0xFF;
        }
    }

    @Override
    public void update() {
        this._lastUpdate = System.currentTimeMillis();
        long elapsed = this._lastUpdate - this._startTime;
        double ascendingFadePercentage = this.exponentialFade(elapsed, this._duration);
        double decendingFadePercentage = this.exponentialFade((long)this._duration - elapsed, this._duration);
        int minChannel = 512;
        for (int i = 0; i < this._channels.length; ++i) {
            if (minChannel > this._channels[i]) {
                minChannel = this._channels[i];
            }
            int channelDelta = this._newValues[i] - this._initialValues[i];
            int channelDeltaPercentage = 0;
            channelDeltaPercentage = this._newValues[i] > this._initialValues[i] ? (int)(ascendingFadePercentage * (double)channelDelta) : channelDelta - (int)(decendingFadePercentage * (double)channelDelta);
            int value = this._initialValues[i] + channelDeltaPercentage;
            this._bytes[i] = (byte)value;
        }
        DmxMain.DMX_PORTS[0].setChannels(minChannel, this._bytes);
        ++this._updates;
    }

    @Override
    public boolean isComplete() {
        boolean complete;
        if (this._abort) {
            return true;
        }
        long elapsed = this._lastUpdate - this._startTime;
        boolean bl = complete = (long)this._duration < elapsed;
        if (complete) {
            System.out.println(this._updates + " updates");
        }
        return complete;
    }

    private double exponentialFade(long elapsed, int period) {
        double value = 1.0;
        if (0 != period) {
            double x = (double)elapsed / (double)period;
            if (1.0 < x) {
                x = 1.0;
            }
            value = Math.pow(x, 2.0);
        }
        return value;
    }
}

