/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.dmx;

import com.integpg.dmx.ScriptExecutor;
import com.integpg.dmx.ScriptFile;
import com.integpg.janoslib.logger.AppLog;
import java.util.Enumeration;
import java.util.Hashtable;

public class ScriptFileCollection {
    private static final Hashtable<String, ScriptFile> _scriptFiles = new Hashtable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int size() {
        Hashtable<String, ScriptFile> hashtable = _scriptFiles;
        synchronized (hashtable) {
            return _scriptFiles.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void put(String filename, ScriptFile scriptFile) {
        filename = filename.toLowerCase();
        Hashtable<String, ScriptFile> hashtable = _scriptFiles;
        synchronized (hashtable) {
            _scriptFiles.put(filename, scriptFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean containsKey(String filename) {
        filename = filename.toLowerCase();
        Hashtable<String, ScriptFile> hashtable = _scriptFiles;
        synchronized (hashtable) {
            boolean containsKey = _scriptFiles.containsKey(filename);
            System.out.println("_scriptFiles.containsKey(" + filename + "): " + containsKey);
            return containsKey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ScriptFile get(String filename) {
        filename = filename.toLowerCase();
        Hashtable<String, ScriptFile> hashtable = _scriptFiles;
        synchronized (hashtable) {
            return _scriptFiles.get(filename);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Enumeration keys() {
        Hashtable<String, ScriptFile> hashtable = _scriptFiles;
        synchronized (hashtable) {
            return _scriptFiles.keys();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Enumeration elements() {
        Hashtable<String, ScriptFile> hashtable = _scriptFiles;
        synchronized (hashtable) {
            return _scriptFiles.elements();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void remove(String scriptFilename) {
        Hashtable<String, ScriptFile> hashtable = _scriptFiles;
        synchronized (hashtable) {
            _scriptFiles.remove(scriptFilename);
        }
    }

    public static void loadScript(String filename) {
        AppLog.info(filename + " has changed");
        ScriptFile scriptFile = new ScriptFile(filename);
        scriptFile.processFile();
        String scriptName = scriptFile.getFile().getName();
        AppLog.info("scriptName: " + scriptName);
        scriptName = scriptName.substring(0, scriptName.indexOf("."));
        AppLog.info("scriptName: " + scriptName);
        ScriptFileCollection.put(scriptName, scriptFile);
        AppLog.info(ScriptFileCollection.size() + " script files");
    }

    public static void executeScript(String scriptName, int repeatCount) {
        AppLog.info("scriptName: " + scriptName);
        if (scriptName.contains("/")) {
            scriptName = scriptName.substring(scriptName.lastIndexOf("/") + 1);
        }
        AppLog.info("scriptName: " + scriptName);
        if (scriptName.contains(".")) {
            scriptName = scriptName.substring(0, scriptName.indexOf("."));
        }
        AppLog.info("scriptName: " + scriptName);
        AppLog.info("containsKey(" + scriptName + "): " + ScriptFileCollection.containsKey(scriptName));
        if (ScriptFileCollection.containsKey(scriptName)) {
            ScriptFile scriptFile = ScriptFileCollection.get(scriptName);
            if (null != scriptFile) {
                ScriptExecutor scriptExecutor = new ScriptExecutor(scriptFile);
                scriptExecutor.setRepeatCount(repeatCount);
                scriptExecutor.start();
            }
        } else {
            Enumeration e = ScriptFileCollection.keys();
            while (e.hasMoreElements()) {
                AppLog.info("scriptFilename: " + e.nextElement().toString());
            }
        }
    }

    public static void abortScript(String scriptName) {
        if (null != scriptName) {
            AppLog.info("scriptName: " + scriptName);
            if (scriptName.contains("/")) {
                scriptName = scriptName.substring(scriptName.lastIndexOf("/") + 1);
            }
            AppLog.info("scriptName: " + scriptName);
            if (scriptName.contains(".")) {
                scriptName = scriptName.substring(0, scriptName.indexOf("."));
            }
            AppLog.info("scriptName: " + scriptName);
            ScriptExecutor.abort(scriptName);
        } else {
            AppLog.info("Aborting all");
            ScriptExecutor.abortAll();
        }
    }
}

