/* global Base64, bootbox, DmxApp */



DmxApp.controller('DmxController', function ($scope, $location, $compile, $sce, FixtureService, FixtureTypeService, ScriptService, SceneService, TriggerService) {
    var _this = this;

    _this.WebVersion = "please wait...";
    _this.JniorVersion = "please wait...";

    _this.View = null;

    _this.Config = {};
    _this.Config.Fixtures = [];

    _this.SavedConfig = angular.copy(_this.Config);

    _this.SaveDialog = null;
    _this.CancelDialog = null;

    _this.ApplicationRunning = true;



    // watch for changes to our $location.url() object.
    $scope.$watch(function () {
        return $location.url();
    }, function (url) {
        if (url) {
            var view = $location.search().view;
            if (view) {
                _this.setView(view);
            } else {
                _this.setView(null);
            }
        }
    });


    // push the view selection to our $location.url() object.
    _this.setView = function (view) {
        _this.View = view;
        if (null != view) {
            var path = $location.path();
            $location.url(path + '?view=' + view);

            _this.load();
        }
    };


    _this.activateView = function (ele) {
        $compile(ele.contents())($scope);
        $scope.$apply();
    };


    _this.getHtmlSafeContent = function (script) {
        if (script.Content) {
            var safeHtml = script.Content.replaceAll('\n', '<br>');
            return $sce.trustAsHtml(safeHtml);
        }
    };


    _this.getHtmlSafe = function (content) {
        if (content) {
            var safeHtml = content.replaceAll('\n', '<br>');
            return $sce.trustAsHtml(safeHtml);
        }
    };


    _this.moveScriptUp = function (currentIndex) {
        array_move(_this.Config.Scripts, currentIndex, currentIndex - 1);
    };


    _this.moveScriptDown = function (currentIndex) {
        array_move(_this.Config.Scripts, currentIndex, currentIndex + 1);
    };


    _this.hasChanged = function () {
        var changed = false;

        if (null === _this.View || "fixture-types" === _this.View) {
            changed = FixtureTypeService.hasChanged();
        } else if ("fixtures" === _this.View) {
            changed = FixtureService.hasChanged();
        } else if ("scripts" === _this.View) {
            changed = ScriptService.hasChanged();
        } else if ("scenes" === _this.View) {
            changed = SceneService.hasChanged();
        } else if ("chases" === _this.View) {
            // changed = ChaseService.hasChanged();
        } else if ("triggers" === _this.View) {
            changed = TriggerService.hasChanged();
        }

        return changed;
    };


    //    _this.hasChanged = function (config, savedConfig) {
    //        var changed = !angular.equals(config, savedConfig);
    //        return changed;
    //    };


    _this.schemaUpdated = function (file) {
        var fileSchemaArray = file.schema.split(',');
        file.schema = fileSchemaArray;
    };


    _this.saveChangesRequest = function () {
        _this.SaveDialog = bootbox.confirm({
            title: "Are you sure you want to save your changes?",
            message: "Saving your changes will take effect immediately",
            buttons: {
                cancel: {
                    label: 'Cancel',
                    className: 'btn-default'
                },
                confirm: {
                    label: 'Save',
                    className: 'btn-success'
                }
            },
            callback: function (result) {
                if (result) {
                    _this.saveChanges();
                    return false;
                }
            }
        });
        _this.SaveDialog.init(function () {
            $(".modal-header").css("background-color", "#5cb85c");
            $(".modal-header").css("color", "#fff");
            $("#bootbox-confirm-btn").prop('disabled', false);
            $("#bootbox-cancel-btn").prop('disabled', false);
        });
    };


    _this.saveChanges = function () {
        $("#bootbox-confirm-btn").html("Saving...");
        $("#bootbox-confirm-btn").prop('disabled', true);
        $("#bootbox-cancel-btn").prop('disabled', true);

        setTimeout(function () {
            if (null === _this.View || "fixture-types" === _this.View) {
                FixtureTypeService.save(_this);
            } else if ("fixtures" === _this.View) {
                FixtureService.save(_this);
            } else if ("scripts" === _this.View) {
                ScriptService.save(_this);
            } else if ("scenes" === _this.View) {
                SceneService.save(_this);
            } else if ("chases" === _this.View) {
                // ChaseService.save(_this);
            } else if ("triggers" === _this.View) {
                TriggerService.save(_this);
            }
        }, 1000);
    };


    _this.cancelChangesRequest = function () {
        _this.CancelDialog = bootbox.confirm({
            title: "Are you sure you want to cancel your changes?",
            message: "Cancelling your changes will reload the last saved settings",
            buttons: {
                cancel: {
                    label: 'Keep Changes',
                    className: 'btn-default'
                },
                confirm: {
                    label: 'Cancel Changes',
                    className: 'btn-warning'
                }
            },
            callback: function (result) {
                if (result) {
                    _this.cancelChanges();
                    return false;
                }
            }
        });
        _this.CancelDialog.init(function () {
            $(".modal-header").css("background-color", "#f0ad4e");
            $(".modal-header").css("color", "#fff");
            $("#bootbox-confirm-btn").prop('disabled', false);
            $("#bootbox-cancel-btn").prop('disabled', false);
        });
    };


    _this.cancelChanges = function () {
        $("#bootbox-confirm-btn").html("Reverting...");
        $("#bootbox-confirm-btn").prop('disabled', true);
        $("#bootbox-cancel-btn").prop('disabled', true);

        setTimeout(function () {
            if (null === _this.View || "fixture-types" === _this.View) {
                FixtureTypeService.load(_this);
            } else if ("fixtures" === _this.View) {
                FixtureService.load(_this);
            } else if ("scripts" === _this.View) {
                ScriptService.load(_this);
            } else if ("scenes" === _this.View) {
                SceneService.load(_this);
            } else if ("chases" === _this.View) {
                // ChaseService.load(_this);
            } else if ("triggers" === _this.View) {
                TriggerService.load(_this);
            }
        }, 1000);
    };



    JnrWebsocket.onLoggedIn = function () {
        _this.load();

        JnrWebsocket.onReplyMessage = function (replyContentJson) {
            console.log('reply message: ', replyContentJson);

            let contentJson = JSON.parse(replyContentJson.Content);
            console.log('reply message content: ', contentJson);

            let message = contentJson.Message;
            console.log('reply message: ', message);

            _this.JniorVersion = contentJson.Version;
            _this.BuildTime = contentJson.BuildTime;
            $scope.$apply();

            // we have our version.  call the function that will check for an update
            checkForUpdate('dmx-application', _this.JniorVersion, function (latest_version_json) {
                //
                //  I like the following popup but we thought it was too in your face so we reverted 
                // to the more subtile help menu item
                //

                // let alert_message = `<p>Version ${latest_version_json.version} was released on ${latest_version_json.date}`
                //     + ` - <a href="${latest_version_json.url}">${latest_version_json.filename}</a></p>`
                //     + '<p>'
                //     // + `<a href="${latest_version_json.url}">${latest_version_json.filename}</a> - `
                //     + `File Size: (${Math.floor(latest_version_json.size / 1024)} KB)<br>`
                //     + `MD5: ${latest_version_json.md5}`
                //     + '</p>'
                //     + `<p>Click the link above to download the update project.  Then open `
                //     + 'the update project in the support tool to update your JNIOR.</p>';
                // bootbox.alert({
                //     title: 'Update Available',
                //     message: alert_message,
                //     className: 'bb-success',
                // });

                _this.UpdateAvailable = latest_version_json;
                $scope.$apply();
            });
        }

        // "get-app-info"
        JnrWebsocket.postMessage(1401, JSON.stringify({
            Command: "get-app-info",
        }));



        // get links to display in Links dropdown menu
        JnrWebsocket.getRegistryListing("Applications", function (registryPath, registryKeys) {
            _this.links = [];

            // this first call will return all of the application folders
            registryKeys.forEach(function (applicationFolderKey) {
                console.log(`app name: ${applicationFolderKey}`);
                if (applicationFolderKey != "Applications/DMX/") {

                    // try to get the applications config web page
                    JnrWebsocket.readRegistryKey(applicationFolderKey + "Config", function (registryKey, registryValue) {
                        console.log("    " + registryKey + " = " + registryValue);
                        if (registryValue) {
                            const applicationsConfigRegEx = /Applications\/(\w+)\//;
                            const match = applicationFolderKey.match(applicationsConfigRegEx);
                            var applicationName = match[1];
                            _this.links.push({ 'name': applicationName, 'link': registryValue });
                            $scope.$apply();
                        }
                    });
                }
            });
        });
    };


    _this.load = function () {
        // FixtureTypeService.load(_this);
        // FixtureService.load(_this);
        // ScriptService.load(_this);
        // SceneService.load(_this);
        // // ChaseService.load(_this);


        setTimeout(function () {
            if (null === _this.View || "fixture-types" === _this.View) {
                FixtureTypeService.load(_this);
            } else if ("fixtures" === _this.View) {
                FixtureService.load(_this);
            } else if ("scripts" === _this.View) {
                ScriptService.load(_this);
            } else if ("scenes" === _this.View) {
                SceneService.load(_this);
            } else if ("chases" === _this.View) {
                // ChaseService.load(_this);
            } else if ("triggers" === _this.View) {
                TriggerService.load(_this);
            }
        }, 100);
    };


    JnrWebsocket.connect();
    JnrWebsocket.initPing(1400);


    window.addEventListener("beforeunload", function (e) {
        var confirmationMessage = "You have unsaved changes.  Are you sure you want to leave this page?";

        var pendingChanges = false;
        pendingChanges |= FixtureTypeService.hasChanged();
        pendingChanges |= FixtureService.hasChanged();
        pendingChanges |= ScriptService.hasChanged();
        pendingChanges |= SceneService.hasChanged();
        pendingChanges |= TriggerService.hasChanged();

        if (pendingChanges) {
            e.returnValue = confirmationMessage;     // Gecko, Trident, Chrome 34+
            return confirmationMessage;              // Gecko, WebKit, Chrome <34
        }
    });
});



function array_move(arr, old_index, new_index) {
    if (new_index >= arr.length) {
        var k = new_index - arr.length + 1;
        while (k--) {
            arr.push(undefined);
        }
    }
    arr.splice(new_index, 0, arr.splice(old_index, 1)[0]);
    return arr; // for testing
}



var validate_alphanumeric = function ($elem) {
    if (!$elem) {
        alert('validate_alphanumeric element not found');
    }

    $elem.keypress(function (evt) {
        if (evt.which != 13) {
            var char = String.fromCharCode(evt.which);

            if ('$' == char &&
                (this.selectionStart == 0 || this.selectionStart == 1)) {
                // allow it

            } else {
                // replace a space with and underscore
                var newChar = char.replace(/ /g, '_');

                // remove digits at the beginning of the name
                if (0 == this.selectionStart) {
                    newChar = newChar.replace(/\d/, '');
                }

                // remove all non alphanumeric characters
                newChar = newChar.replace(/([^#a-zA-Z0-9_\-\.])/, '');

                // if the character was nullified then return.  else replace 
                //  the character in the selection range
                if ('' == newChar) return false;
                if (newChar != char) {
                    this.setRangeText(newChar, this.selectionStart, this.selectionEnd, "end");
                    return false;
                }
            }
        }
    });


    $elem.keyup(function (evt) {
        if (evt.which != 13) {
            var char = String.fromCharCode(evt.which);

            if ('$' == char &&
                (this.selectionStart == 0 || this.selectionStart == 1)) {
                // allow it

            } else {
                // replace a space with and underscore
                var newChar = char.replace(/ /g, '_');

                // remove digits at the beginning of the name
                if (0 == this.selectionStart) {
                    newChar = newChar.replace(/\d/, '');
                }

                // remove all non alphanumeric characters
                newChar = newChar.replace(/([^#a-zA-Z0-9_\-\.])/, '');

                // if the character was nullified then return.  else replace 
                //  the character in the selection range
                if ('' == newChar) return false;
                if (newChar != char) {
                    this.setRangeText(newChar, this.selectionStart - 1, this.selectionEnd, "end");
                    return false;
                }
            }
        }
    });
}