/* global bootbox */

var JnrWebsocket = new JnrWebsocket();

var app = angular.module('DmxApp', []);

var DmxScope;
var DmxController;
app.controller('DmxController', ['$scope', '$compile', function ($scope, $compile) {
    DmxScope = $scope;
    DmxController = this;

    DmxController.Channels = [];
    for (var i = 0; i < 512; i++) {
        DmxController.Channels[i] = 0;
    }
    DmxController.FixtureTypes = null;
    DmxController.Fixtures = null;

    DmxController.activateView = function (ele) {
        $compile(ele.contents())($scope);
        $scope.$apply();
    };


    JnrWebsocket.onLoggedIn = function () {
        JnrWebsocket.getFileListing("/flash/dmx/scripts/").then(scriptsListingReceived);
        JnrWebsocket.readFile("/flash/dmx/fixtures/fixture-types.json").then(fixtureFileRead);
        JnrWebsocket.readFile("/flash/dmx/fixtures/fixtures.json").then(fixtureFileRead);

        // ask for the current value for all of the channels
        JnrWebsocket.postMessage(1401, JSON.stringify({
            Command: "get-channel-values"
        }));
    };


    var scriptsListingReceived = function (json) {
        if (json.Folder === "/flash/dmx/scripts") {
            DmxController.ScriptNames = [];

            for (var fileIndex in json.Content) {
                var scriptName = json.Content[fileIndex].Name;
                var scriptIndex = scriptName.indexOf(".script");
                if (-1 !== scriptIndex && !scriptName.endsWith(".removed")) {
                    scriptName = scriptName.substring(0, scriptIndex);
                    DmxController.ScriptNames.push(scriptName);
                }
            }

            DmxController.ScriptNames.sort(function (a, b) {
                if (!a || !b)
                    return 1;
                console.log(a + " " + b);
                if (a > b)
                    return 1;
                else if (a < b)
                    return -1;
                else
                    return 0;
            });

            $scope.$apply();
        }
    };


    var fixtureFileRead = function (json) {
        var filename = json.File;
        if (filename.endsWith("flash/dmx/fixtures/fixture-types.json")) {
            var fileContent = Base64.decode(json.Data);
            console.log(fileContent);
            var fixtureTypeJson = JSON.parse(fileContent);
            DmxController.FixtureTypes = fixtureTypeJson.FixtureTypes;
            $scope.$apply();
        } else if (filename.endsWith("flash/dmx/fixtures/fixtures.json")) {
            var fileContent = Base64.decode(json.Data);
            console.log(fileContent);
            var fixtureJson = JSON.parse(fileContent);
            DmxController.Fixtures = fixtureJson.Fixtures;
            $scope.$apply();
        }
    };


    JnrWebsocket.onReplyMessage = function (replyContentJson) {
        var contentJson = JSON.parse(replyContentJson.Content);
        if ("channel-update" === contentJson.Message) {
            var channelsString = contentJson.Channels;
            var channel = contentJson.Min - 1;
            for (var c = 0; c < channelsString.length; c += 2) {
                var channelValue = parseInt(channelsString.substr(c, 2), 16);
                DmxController.Channels[channel++] = channelValue;
            }

        } else {
            var content = replyContentJson.Content;
            var fields = content.split(",");
            var channel = fields[0];
            var value = fields[1];
            DmxController.Channels[channel] = value;
        }

        $scope.$apply();
    };


    DmxController.getFixtureTypeById = function (id) {
        if (null !== DmxController.FixtureTypes) {
            for (var i = 0; i < DmxController.FixtureTypes.length; i++) {
                var fixtureType = DmxController.FixtureTypes[i];
                if (id == fixtureType.Id) {
                    return fixtureType;
                }
            }
        }

    };


    DmxController.getChannelStyle = function (channel) {
        var fixtureIndex = -1;
        var fixtureType = null;
        if (null !== DmxController.Fixtures) {
            for (var i = 0; i < DmxController.Fixtures.length; i++) {
                var fixture = DmxController.Fixtures[i];
                if (fixture.FixtureTypeId) {
                    fixtureType = DmxController.getFixtureTypeById(fixture.FixtureTypeId);
                    if (fixture.StartChannel <= channel && (fixture.StartChannel + fixtureType.ChannelCount - 1) >= channel) {
                        fixtureIndex = i;
                        break;
                    }
                }
            }
        }

        var style = {};
        if (-1 !== fixtureIndex && null != fixtureType) {
            var fixture = DmxController.Fixtures[fixtureIndex];
            if (fixture.StartChannel === channel)
                style["border-left"] = '1px solid #eee';
            else if (0 === ((channel - 1) % 10))
                style["border-left"] = '1px solid #eee';

            if (fixture.StartChannel + fixtureType.ChannelCount - 1 === channel)
                style["border-right"] = '1px solid #eee';
            else if (0 === (channel % 10))
                style["border-right"] = '1px solid #eee';

            // is first row?
            if (Math.floor((fixture.StartChannel - 1) / 10) === Math.floor((channel - 1) / 10))
                style["border-top"] = '1px solid #eee';

            // is second row and is the channel within the first 10 channels?
            else {
                if (Math.floor((fixture.StartChannel - 1) / 10) === Math.floor((channel - 11) / 10) &&
                    (fixture.StartChannel + 10) > channel)
                    style["border-top"] = '1px solid #eee';
            }

            // is it the last row?
            if (Math.floor((fixture.StartChannel + fixtureType.ChannelCount - 2) / 10) === Math.floor((channel - 1) / 10))
                style["border-bottom"] = '1px solid #eee';

            // is this the second to last row and is the channel within the last 10?
            else {
                if (Math.floor((fixture.StartChannel + fixtureType.ChannelCount - 2) / 10) === Math.floor((channel + 9) / 10) &&
                    (fixture.StartChannel + fixtureType.ChannelCount - 11) < channel)
                    style["border-bottom"] = '1px solid #eee';
            }

            if (0 === (fixtureIndex % 2)) {
                style["background-color"] = '#999';
            } else {
                style["background-color"] = '#aaa';
            }
        }

        return style;
    };


    DmxController.getFixtureName = function (channel) {
        if (null !== DmxController.Fixtures) {
            for (var i = 0; i < DmxController.Fixtures.length; i++) {
                var fixture = DmxController.Fixtures[i];
                var fixtureType = null;
                if (fixture.FixtureTypeId) {
                    fixtureType = DmxController.getFixtureTypeById(fixture.FixtureTypeId);
                    if (fixture.StartChannel <= channel && (fixture.StartChannel + fixtureType.ChannelCount - 1) >= channel) {
                        return fixture.Name;
                    }
                }
            }
        }
        return "no fixture defined";
    };


    DmxController.channelClicked = function (channel) {
        var fixtureIndex = -1;
        if (null !== DmxController.Fixtures) {
            for (var i = 0; i < DmxController.Fixtures.length; i++) {
                var fixture = DmxController.Fixtures[i];
                var fixtureType = null;
                if (fixture.FixtureTypeId) {
                    fixtureType = DmxController.getFixtureTypeById(fixture.FixtureTypeId);
                    if (fixture.StartChannel <= channel && (fixture.StartChannel + fixtureType.ChannelCount - 1) >= channel) {
                        fixtureIndex = i;
                        break;
                    }
                }
            }
        }

        if (-1 !== fixtureIndex) {
            var fixture = DmxController.Fixtures[fixtureIndex];
            var fixtureType = null;
            if (fixture.FixtureTypeId) {
                fixtureType = DmxController.getFixtureTypeById(fixture.FixtureTypeId);
            }

            //                bootbox.dialog({
            //                    backdrop: false,
            ////                    closeButton: false,
            //                    //                    title: fixture.Name,
            ////                    className: "modeless",
            //                    message: DmxController.addChannelsToDialog(fixture, 16),
            //                    buttons: {
            //                        cancel: {
            //                            label: 'Done',
            //                            className: 'btn-primary'
            //                        }
            //                    }
            //                }).init(function () {
            //
            //                    $(".modal-dialog").css("width", (Math.floor(((fixtureType.ChannelCount - 1) / 16) + 1) * 300) + "px");
            //                    $(".modal-dialog").draggable({
            //                        handle: ".modal-body"
            //                    });
            //
            //
            //                    $(".modal-body").css("padding-top", "0");
            //                    $(".modal-body").css("padding-bottom", "0");
            //                    $(".bootbox-close-button").css("color", "#286090");
            //                    $(".bootbox-close-button").css("opacity", "1");
            //                    DmxController.activateView($(".modal-body"));
            //                });

            windowObjectReference = window.open(
                "panel/fixture.html?fixtureName=" + fixture.Name,
                fixture.Name,
                "width=" + (Math.floor(((fixtureType.ChannelCount - 1) / 16) + 1) * 290) + ",height=700,resizable,scrollbars=no,status=0,location=0"
            );


        } else {
            bootbox.prompt({
                title: "What is value of channel " + channel + "?",
                value: DmxController.Channels[channel - 1],
                callback: function (result) {
                    if (result) {
                        DmxController.Channels[channel - 1] = result;
                        JnrWebsocket.postMessage(1400, channel + "," + result);

                        $scope.$apply();
                    }
                }
            }).init(function () {
                $(".modal-body input").focus();
                $(".modal-body input").select();
            });
        }
    };


    DmxController.addChannelsToDialog = function (fixture, channelsPerColumn) {
        var fixtureType = null;
        if (fixture.FixtureTypeId) {
            fixtureType = DmxController.getFixtureTypeById(fixture.FixtureTypeId);
        }

        var box = document.createElement('div');
        //                        box.className = 'wf-box faders';
        //                        box.id = 'fixture-' + fixtureName.toLowerCase().replaceAll(' ', '-');

        var fixtureNameElement = document.createElement("h3");
        fixtureNameElement.innerHTML = fixture.Name;
        box.appendChild(fixtureNameElement);

        var table = document.createElement('table');
        box.appendChild(table);

        var trElement = document.createElement("tr");
        table.appendChild(trElement);

        for (var i = 0; i <= Math.floor((fixtureType.ChannelCount - 1) / channelsPerColumn); i++) {
            var tdElement = document.createElement("td");
            tdElement.style.verticalAlign = 'top';
            trElement.appendChild(tdElement);

            //            for (var channelIndex = fixture.StartChannel; channelIndex < fixture.StartChannel + fixtureType.ChannelCount; channelIndex++) {
            var startChannel = i * channelsPerColumn + 1;
            var endChannel = (i + 1) * channelsPerColumn;
            if (endChannel > fixtureType.ChannelCount)
                endChannel = (i * channelsPerColumn) + (fixtureType.ChannelCount % channelsPerColumn);

            for (var j = startChannel; j <= endChannel; j++) {
                DmxController.addChannelToDialog(tdElement, fixture, fixture.StartChannel + j - 1);
            }
        }

        //            for (var channelIndex = fixture.StartChannel; channelIndex < fixture.StartChannel + fixtureType.ChannelCount; channelIndex++) {
        //                DmxController.addChannelToDialog(box, fixture, channelIndex);
        //            }
        return box;
    };

    //        var _waterfall;


    DmxController.addChannelToDialog = function (parentFaderBank, fixture, channel) {
        var label = "Channel " + channel;

        var channelElement = document.createElement("div");
        channelElement.className = "channel";
        parentFaderBank.appendChild(channelElement);

        var channelLabel = document.createElement("div");
        channelLabel.className = "channel-label";
        channelLabel.innerHTML = label;
        channelElement.appendChild(channelLabel);

        var channelSliderElement = document.createElement("div");
        channelSliderElement.className = "channel-slider";
        channelElement.appendChild(channelSliderElement);

        var channelSlider = document.createElement("input");
        channelSlider.id = channel;
        channelSlider.setAttribute("type", "range");
        channelSlider.setAttribute("value", "0");
        channelSlider.setAttribute("min", "0");
        channelSlider.setAttribute("max", "255");
        channelSlider.setAttribute("ng-model", "dmx.Channels[" + (channel - 1) + "]");
        channelSlider.addEventListener("input", function (event) {
            DmxController.slide(event);
        });
        channelSlider.addEventListener("change", function (event) {
            DmxController.slide(event);
        });
        channelSliderElement.appendChild(channelSlider);

        var channelValue = document.createElement("div");
        channelValue.className = "channel-value";
        channelValue.innerHTML = "0";
        channelValue.setAttribute("ng-bind", "dmx.Channels[" + (channel - 1) + "]");
        channelElement.appendChild(channelValue);

        //            DmxController.activateView(angular.element(channelElement));
    };


    DmxController.slide = function (evt) {
        var val = evt.target.value;
        var channel = evt.target.id;

        var parent = document.getElementById(channel).parentElement.parentElement;
        var channelValue = parent.getElementsByClassName("channel-value")[0];
        channelValue.innerHTML = val;

        //        if (JnrWebsocket.open) {
        //            var request = new Object();
        //            request['Message'] = "Post Message";
        //            request['Number'] = 1400;
        //            request['Content'] = channel + "," + val;
        //            JnrWebsocket.sendJson(request);

        JnrWebsocket.postMessage(1400, channel + "," + val);
        //        }
    };


    DmxController.executeScript = function (script) {
        DmxController.ExecuteDialog = bootbox.confirm({
            title: "Execute " + script.Name,
            message: "How many times should <B>" + script + "</b> repeat? <input type'number' id='repeat-count' class='form-control' value='1'>",
            buttons: {
                cancel: {
                    label: 'Cancel',
                    className: 'btn-default'
                },
                confirm: {
                    label: 'Execute',
                    className: 'btn-success'
                }
            },
            callback: function (result) {
                if (result) {
                    JnrWebsocket.postMessage(1401, JSON.stringify({
                        Command: "exec-script",
                        ScriptName: script,
                        RepeatCount: $("#repeat-count").val()
                    }));
                }
            }
        });
        DmxController.ExecuteDialog.init(function () {
            $(".modal-header").css("background-color", "#5cb85c");
            $(".modal-header").css("color", "#fff");
            $("#repeat-count").focus();
        });
    };


    JnrWebsocket.connect();
    //        JnrWebsocket.initPing(1401);
}
]);

