async function checkForUpdate(appname, currentVersionString, callback) {

    try {
        var url = 'https://jnior.com/downloads/?appname=' + appname;
        let response = await fetch(url);
        let response_json = await response.json();

        console.log('fetched from ', url, ': ', response_json);

        let latest_version_json = response_json.downloads[appname].latest_version;

        if (latest_version_json.version > currentVersionString) {
            console.log(latest_version_json);
            if (callback) callback(latest_version_json);
        }

        // console.log('GET: ' + url);
        // var httpRequest = new XMLHttpRequest();
        // httpRequest.open('GET', url);
        // httpRequest.onreadystatechange = function () {
        //     if (httpRequest.readyState == 4) {
        //         if (httpRequest.status == 200) {
        //             var response = httpRequest.responseText;
        //             var json = JSON.parse(response);
        //             console.log(json);


        //             currentVersion = parseVersion(currentVersionString);
        //             console.log('version: ' + currentVersionString + ' ' + JSON.stringify(currentVersion));

        //             var latestVersionString = json.latest_version.version;
        //             latestVersion = parseVersion(latestVersionString);
        //             console.log('latest_version: ' + latestVersionString + ' ' + JSON.stringify(latestVersion));

        //             if (latestVersion.major > currentVersion.major || (
        //                 latestVersion.major == currentVersion.major
        //                 && latestVersion.minor > currentVersion.minor
        //             )) {
        //                 console.log(latestVersion);
        //                 if (callback) callback(json);
        //             }
        //         }
        //     }
        // }
        // httpRequest.send();
    } catch (err) {
        console.error(err);
    }

}



function parseVersion(str) {
    if (typeof (str) != 'string') { return false; }

    var arr = str.split('.');

    // parse int or default to 0
    var maj = parseInt(arr[0]) || 0;
    var min = parseInt(arr[1]) || 0;
    var rest = parseInt(arr[2]) || 0;
    return {
        major: maj,
        minor: min,
        build: rest
    }
}