/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.dmx.effects;

import com.integpg.dmx.DmxMain;
import com.integpg.dmx.effects.Effect;

public class LinearFadeEffect
extends Effect {
    private final int _channelNumber;
    private final int _periodInSeconds;
    private final long _period;
    private final long _startTime = System.currentTimeMillis();
    private long _lastElapsed = 0L;

    public LinearFadeEffect(int channelNumber, int periodInSeconds) {
        this._channelNumber = channelNumber;
        this._periodInSeconds = periodInSeconds;
        this._period = this._periodInSeconds * 1000;
    }

    @Override
    public void update() {
        long now = System.currentTimeMillis();
        long elapsed = now - this._startTime;
        if (elapsed < this._lastElapsed) {
            System.out.println("elapsed decreasing");
            System.exit(-99);
        }
        this._lastElapsed = elapsed;
        double value = this.linearFade(elapsed);
        DmxMain.DMX_PORTS[0].setChannel(this._channelNumber, (byte)(value *= 255.0));
    }

    @Override
    public boolean isComplete() {
        return false;
    }

    private double linearFade(long elapsed) {
        double x = elapsed / this._period;
        return x;
    }
}

