/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.dmx;

import com.integpg.dmx.AssemblyInfo;
import com.integpg.dmx.JsonReceiver;
import com.integpg.dmx.JsonSender;
import com.integpg.dmx.ScriptFile;
import com.integpg.dmx.ScriptFileCollection;
import com.integpg.janoslib.logging.Logger;
import com.integpg.system.JANOS;
import java.io.IOException;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Json;
import java.util.Vector;

public class JsonClientHandler
implements Runnable {
    public static Logger JSON_SERVER_LOG = Logger.getLogger("/temp/" + AssemblyInfo.getName() + "_jsonserver.log").setMaxSizeKB(32);
    private static final Vector<JsonClientHandler> CLIENT_HANDLERS = new Vector();
    private final Socket _socket;
    private final String _clientInfo;
    private boolean _quit = false;
    private final JsonReceiver _jsonRecevier;
    private final JsonSender _jsonSender;

    public JsonClientHandler(Socket socket) throws IOException {
        this._socket = socket;
        this._clientInfo = this._socket.getInetAddress().getHostAddress() + ":" + this._socket.getPort();
        this._jsonRecevier = new JsonReceiver(this._socket);
        this._jsonSender = new JsonSender(this._socket);
        CLIENT_HANDLERS.addElement(this);
    }

    @Override
    public void run() {
        JSON_SERVER_LOG.info("Client Connected: " + this._clientInfo);
        try {
            while (!this._quit) {
                Json jsonMessage = this._jsonRecevier.getJson();
                if (jsonMessage != null) {
                    this.messageReceived(jsonMessage);
                    continue;
                }
                JSON_SERVER_LOG.info(this._clientInfo + " disconnected");
                this._quit = true;
            }
        }
        catch (Exception ex) {
            JSON_SERVER_LOG.error(ex);
        }
        try {
            this._jsonRecevier.close();
            this._jsonSender.close();
            if (this._socket != null) {
                this._socket.close();
            }
        }
        catch (IOException ex) {
            JSON_SERVER_LOG.error(ex);
        }
        JSON_SERVER_LOG.info("Client Disconnected: " + this._clientInfo);
    }

    public boolean messageReceived(Json json) throws IOException {
        boolean result = false;
        JSON_SERVER_LOG.info(" <- " + json);
        String message = json.getString("Message");
        if ("GetInfo".equalsIgnoreCase(message)) {
            Json jsonResponse = new Json();
            jsonResponse.put("Message", (Object)"GetInfoResponse");
            jsonResponse.put("Information", (Object)("Cinema v" + AssemblyInfo.getVersion()));
            String hostname = JANOS.getRegistryString((String)"IpConfig/Hostname", (String)"");
            jsonResponse.put("Ident", (Object)hostname);
            this.send(jsonResponse);
        } else if ("GetMacroList".equalsIgnoreCase(message)) {
            this.sendScriptList();
        } else if ("RunMacro".equalsIgnoreCase(message)) {
            String scriptName = json.getString("MacroName");
            ScriptFileCollection.executeScript(scriptName, 1);
        } else if ("MacroAbort".equalsIgnoreCase(message)) {
            String scriptName = json.getString("MacroName");
            ScriptFileCollection.abortScript(scriptName);
        }
        return result;
    }

    public static void updateScriptList() {
        for (int i = 0; i < CLIENT_HANDLERS.size(); ++i) {
            JsonClientHandler client = CLIENT_HANDLERS.elementAt(i);
            client.sendScriptList();
        }
    }

    private void sendScriptList() {
        try {
            String[] scriptArray = new String[ScriptFileCollection.size()];
            int i = 0;
            Enumeration e = ScriptFileCollection.elements();
            while (e.hasMoreElements()) {
                ScriptFile scriptFile = (ScriptFile)e.nextElement();
                String scriptFilename = scriptFile.getFilename();
                scriptFilename = scriptFilename.substring(scriptFilename.indexOf("dmx/scripts") + 12);
                scriptArray[i++] = scriptFilename.substring(0, scriptFilename.lastIndexOf("."));
            }
            Json jsonResponse = new Json();
            jsonResponse.put("Message", (Object)"GetMacroListResponse");
            jsonResponse.put("MacroList", (Object)scriptArray);
            this.send(jsonResponse);
        }
        catch (IOException ex) {
            JSON_SERVER_LOG.error(ex);
        }
    }

    public synchronized void send(Json json) throws IOException {
        JSON_SERVER_LOG.info(" -> " + json.toString());
        try {
            this._jsonSender.send(json);
        }
        catch (IOException ex) {
            JSON_SERVER_LOG.error(ex);
            this._quit = true;
        }
    }
}

