/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.net.http;

import com.integpg.janoslib.debug.DEBUG;
import com.integpg.janoslib.net.http.HttpURL;
import com.integpg.janoslib.net.http.server.HttpServer;
import com.integpg.system.Security;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;

public class HttpConnection {
    private HttpURL _url;
    private HttpServer _httpServer;
    private Socket _socket;
    private String _type = "GET";
    private byte[] _data;
    private String _remoteAddress;
    private String _remoteAddressString;

    public HttpConnection(HttpURL url) {
        this._url = url;
    }

    public HttpConnection(HttpServer httpServer, Socket socket) {
        this._httpServer = httpServer;
        this._socket = socket;
        this._remoteAddress = this._socket.getInetAddress().getHostAddress();
        this._remoteAddressString = this._remoteAddress + ":" + this._socket.getPort();
    }

    public HttpServer getHttpServer() {
        return this._httpServer;
    }

    public void setRequestMethod(String type) {
        this._type = type;
    }

    public void setData(byte[] data) {
        this._data = data;
    }

    public void connect() throws IOException {
        System.out.println("connect");
        this._socket = new Socket(this._url.getHost(), this._url.getPort());
        this._socket.setSoTimeout(5000);
        this._remoteAddress = this._socket.getInetAddress().getHostAddress();
        this._remoteAddressString = this._remoteAddress + ":" + this._socket.getPort();
        System.out.println(this._url.toString());
        if (-1 != this._url.toString().toLowerCase().indexOf("https")) {
            System.out.println("set secure");
            this._socket.setSecure(true);
        }
    }

    public void sendHeaders() throws IOException {
        OutputStream out = this.getOutputStream();
        String headers = this._type + " /" + this._url.getFile() + this._url.getQuery() + " HTTP/1.1\r\nHost: " + this._url.getHost() + "\r\nConnection: keep-alive\r\nPragma: no-cache\r\nCache-Control: no-cache\r\nContent-Type: application/x-www-form-urlencoded\r\n";
        if (this._url.isCustomCredentials()) {
            String credentialsStirng = String.format("%s:%s", this._url.getUsername(), this._url.getPassword());
            byte[] encodedCredentialsBytes = Security.b64decode((byte[])credentialsStirng.getBytes(), (int)0, (int)credentialsStirng.length());
            headers = headers + "Authorization: Basic " + new String(encodedCredentialsBytes) + "\r\n";
        }
        if (-1 != this._url.toString().toLowerCase().indexOf("https")) {
            headers = headers + "Upgrade-Insecure-Requests: 1";
        }
        if (null != this._data) {
            headers = headers + "Content-Length: " + this._data.length + "\r\n";
        }
        System.out.println("request:\r\n" + headers);
        DEBUG.print("Request:\r\n");
        DEBUG.println(headers);
        out.write((headers + "\r\n").getBytes());
        out.flush();
    }

    public void sendData() throws IOException {
        if (null != this._data) {
            OutputStream out = this.getOutputStream();
            out.write(this._data);
            out.flush();
        }
    }

    public OutputStream getOutputStream() throws SocketException, IOException {
        if (this._socket == null) {
            throw new SocketException("Socket not yet connected");
        }
        return this._socket.getOutputStream();
    }

    public InputStream getInputStream() throws SocketException, IOException {
        if (this._socket == null) {
            throw new SocketException("Socket not yet connected");
        }
        return this._socket.getInputStream();
    }

    public void close() throws IOException {
        if (null != this._socket) {
            if (null != this.getInputStream()) {
                this.getInputStream().close();
            }
            if (null != this.getOutputStream()) {
                this.getOutputStream().close();
            }
            this._socket.close();
        }
    }

    public String getRemoteAddress() {
        return this._remoteAddress;
    }

    public String getRemoteAddressString() {
        return this._remoteAddressString;
    }
}

