 /*
  JNIOR Monitor/Configuration Page
  INTEG Process Group, Inc., 2919 E Hardies Rd, Gibsonia PA 
  724.933.9350
  
  File: folders.js
  
  The user is hereby granted license to use, modify, and redistribute the contents of this
  file for any purpose, commercial or otherwise. No prior authorization by INTEG Process 
  Group, Inc. is required.
*/ 

// segment size for uploading
var SEGMENT = 8192;

// bytes free in current folder
var free_space = 0;

// delete selection mode enabled
var delmode = false;

// download selection mode enabled
var downld = false;

// downloader scheduling
var dld_array = new Array();
var dld_timer = null;

// uploading cache array
var up_cache = new Array();

// selection set
var sel_array = new Array();

// handle click timing
var lastclick = null;
var rnclick = null;
var pending_id = null;

// triggers NewFolder rename activation
var creating_folder = false;

// update periodically
if (dopoll)
	window.setInterval(fupdate, 15000);

// message processing
var file_onmessage = chan.onmessage;
chan.onmessage = function(evt) {
	var jobj = JSON.parse(evt.data);

	if (jobj['Message'] === 'File List Response') {
		var meta = jobj['Meta'];
		var op = meta['Op'];
		
		if (op === "fileexpand") {
			var folder = meta['Folder'];
			var folderid = "Root" + folder;
			var expl = document.getElementById(folderid);
			var pad = parseInt(getComputedStyle(expl).getPropertyValue('padding-left')) + 10;
			
			var fspec = folder.length > 0 ? folder : "/";
			var fparent = fspec.substring(0, fspec.lastIndexOf('/'))
			fparent = fparent.length > 0 ? fparent : "/";
			var sfolder = folder.substring(folder.lastIndexOf('/') + 1);
			sfolder = sfolder.length > 0 ? sfolder : "/";

			var addr = document.getElementById("ffolder");
			var prior = "Root" + addr.innerHTML;
			if (prior.endsWith("//"))
				prior = prior.substring(0, prior.length - 1);
			var elem = document.getElementById(prior);
			if (elem)
				elem.className = "fexpl";
			
			addr.innerHTML = fspec;
			expl.className = "fsel";
			
			var cexpl = "<a href='' onclick='fileexpand(&quot;" + fspec + 
						"&quot;);return(false);'><img src='expanded.png' width='10' height='10'></img>" + sfolder + "</a>";

			var files = jobj['Content'];
			
			var ent = new Array();
			var k = 0;
			var dat = document.getElementById("filedata");
			var cdat = "<table class='ffiles'>";
			
			// sort keys
			for (n = 0; n < files.length - 1; n++) {
				var file1 = files[n]['Name'].toLowerCase();
				var file2 = files[n + 1]['Name'].toLowerCase();
				if (file1.endsWith("/") && !file2.endsWith("/"))
					continue;
				if ((!file1.endsWith("/") && file2.endsWith("/")) || file1 > file2) {
					var file = files[n];
					files[n] = files[n + 1];
					files[n + 1] = file;
					if (n > 0) n -= 2;
				}
			}
			
			// statistics
			var nbytes = 0;
			var rn_activate = false;
			var warning = false;
			
			for (n = 0; n < files.length; n++) {
				var file = files[n]['Name'];
				
				if (file.endsWith("/")) {
					var sfolder = file.substring(0, file.length - 1);
					var fspec = folder.length > 1 ? folder + "/" + sfolder : "/" + sfolder;
					cexpl += "<br><span class='fexpl' id='Root" + fspec + "' style='padding-left:" + pad + 
						"px'><a href='' onclick='fileexpand(&quot;" + fspec + 
						"&quot;);return(false);'><img src='collapsed.png' width='10' height='10' />" + 
						sfolder + "</a></span>";;
				}

				var fspec = folder.length > 1 ? folder + "/" + file : "/" + file;
				var entid = "Fname" + fspec;

				cdat += "<tr class='fileent' id='Drag" + fspec + "'";
				
				// draggable if not in delete mode. include checkbox in delete mode
				if (!delmode && !downld) 
					cdat += " draggable='true' ondragstart='fdragstart(event)'><td>";
				else {
					cdat += "><td><input type='checkbox' class='fsel' name='" + fspec + "' title=''";
					
					// determine if this was preselected
					for (var k = 0; k < sel_array.length; k++) {
						if (sel_array[k] == entid) {
							cdat += " checked";
							break;
						}
					}
					cdat += "></td><td>";
				}
				
				var filelc = file.toLowerCase();
				var fspeclc = fspec.toLowerCase();
				var folderlc = folder.toLowerCase();

				var fname = file;
				if (file.endsWith("/")) {
					cdat += "<img src='folder.png'></img>";
					fname = file.substring(0, file.length - 1);
				}
				else if (fspeclc == "/errors.log" || fspeclc == "/dump.log") {
					nbytes += files[n]['Size'];
					cdat += "<img src='warning.png'></img>";				
					warning = true;
				}
				else {
					nbytes += files[n]['Size'];
					cdat += "<img src='file.png'></img>";	
				}
				
				// limit long file names
				var scratch = document.getElementById("scratch");
				scratch.innerHTML = fname;
				var len = fname.length;
				while (scratch.clientWidth > 210)
					scratch.innerHTML = fname.substr(0, --len);
				var dsp_name = null;
				if (len != fname.length)
					dsp_name = fname.substr(0, len) + "...";
						
				// For the case where a NewFolder has been created we want to immedaiately prepare to rename it
				if (creating_folder && entid.endsWith("/NewFolder/")) {
					cdat += "</td><td id='" + entid + "'>" + 
							"<input class='frename' id='frename' name='" + fspec + "' type='text' style='width:100%;min-width:75px' value='" + fname + "'/>" + 
							"</td><td class='fsize'>" + 
							nformat(files[n]['Size']) + "</td><td class='fdate'>" + files[n]['Mod'] + "</td><td style='width:100%;'></td></tr>";
							
					// reset the mode
					rn_activate = true;
					creating_folder = false;
				}
				else {
					cdat += "</td><td class='ftext' id='" + entid + "' ondblclick='fdblclick(event);return false;' onclick='fclick(event)'>";
					if (dsp_name)
						cdat += "<span title='" + fname + "'>" + dsp_name + "</span>";
					else
						cdat += fname;
					
					cdat += "</td><td class='fsize' id='Fsize" + fspec + "'>" + 
							nformat(files[n]['Size']) + "</td><td class='fdate'id='Fdate" + fspec + "'>";
							
					// During uploads we will display a progress bar here instead of the last modification date.
					var i = 0;
					for (; i < up_cache.length; i++) {
						if (up_cache[i]['File'] == fspec) {
							cdat += bar_inner(fspec, up_cache[i]['Count'], up_cache[i]['Size']);
							break;
						}
					}
					if (i == up_cache.length)
						cdat += files[n]['Mod'];
					cdat += "</td><td style='width:100%;'></td></tr>";
				}
			}
			
			expl.innerHTML = cexpl;
			dat.className = "";
			dat.innerHTML = cdat + "</table>";
			
			// propagate waranig status to the tab
			var tab = document.getElementById("fwarn");
			if (tab) {
				if (warning)
					tab.innerHTML = "<img src='warning.png'></img>";
				else
					tab.innerHTML = "";
			}
			
			// activate NewFolder rename
			if (rn_activate) {
				var fld = document.getElementById("frename");
				fld.selectionStart = 0;
				fld.selectionEnd = fld.value.length;							
				fld.focus();
				fld.onblur = frename;
				fld.onkeydown = textKeydown;
			}			
		}

		// update stats
		stats = document.getElementById("filestats");
		if (jobj['BytesFree']) {
			free_space = jobj['BytesFree'];
			stats.innerHTML = files.length + " items (" + bytes_free(free_space) + ")";
		}
		else
			stats.innerHTML = files.length + " items";
	}

	else if (jobj['Message'] === 'File Write Response') {
		// locate cache entry
		for (var n = 0; n < up_cache.length; n++) {
			var resp = up_cache[n];
			if (resp['File'] != jobj['File'])
				continue;
				
			var elem_size = document.getElementById("Fsize" + resp['File']);
			var elem_date = document.getElementById("Fdate" + resp['File']);
			
			if (resp['Count'] == 0 || jobj['Status'] === "Fail") {
				// update file display
				if (elem_size)
					elem_size.innerHTML = nformat(jobj['Size']);
				if (elem_date) 
					elem_date.innerHTML = jobj['Mod'];
				up_cache.splice(n, 1);

				// restore console				
				if (transfer && up_cache.length == 0) {
						document.getElementById('screen').className = "screen";
						document.getElementById('status').innerHTML = "Transfer Complete";
						transfer = false;
				}
					
				// refresh on completion
				if (up_cache.length == 0)
					frefresh();
			}
			else {
				// update file display
				if (elem_size)
					elem_size.innerHTML = nformat(resp['Size'] - resp['Count']);
				if (elem_date)
					elem_date.innerHTML = bar_inner(resp['File'], resp['Count'], resp['Size']);

				// update console					
				if (transfer) {
					var cnt = 0;
					var tot = 0;
					var i = 0;
					for (; i < up_cache.length; i++) {
						if (up_cache[i]['Source'] == "cmd") {
							cnt += up_cache[i]['Count']
							tot += up_cache[i]['Size'];
						}
					}

					var perc = 100 - Math.floor(100 * cnt / tot);
					var elem = document.getElementById("xfer");
					if (elem)
						elem.style.width = perc + "%";						
				}
				
				var request = new Object();
				request['Message'] = "File Write";
				request['File'] = resp['File'];
				request['Append'] = true;
				
				var cnt = resp['Data'].length;
				if (resp['Count'] <= 3*SEGMENT) 
					request['Size'] = resp['Count'];
				else {
					request['Size'] = 3*SEGMENT;
					cnt = 4*SEGMENT;
				}
					
				request['Mod'] = resp['Mod'];;
				request['Encoding'] = resp['Encoding'];
				request['Data'] = resp['Data'].substr(resp['Offset'], cnt);
			  chan.sendJson(request);
			  
			  resp['Count'] -= request['Size'];
			  resp['Offset'] += cnt;
			}
		}
	}

	else if (jobj['Message'] === 'File Read Response') {
		if (jobj['Meta'] != undefined && jobj['Status'] === 'Ready')
		{
		  var scratch = document.getElementById("scratch");
		  scratch.innerHTML = "<a id='dnldlink' href='" + jobj['Meta'] + "' target='_blank' download>download</a>";
		  var link = document.getElementById("dnldlink");
		  link.click();
		}
	}
	
	if (file_onmessage)
		file_onmessage(evt);	// chain message processing
}


// free bytes formatting
function bytes_free(free) {
	if (free > 2*1024*1024) {
		var mb = Math.floor(10 * free/1024/1024);
		return nformat(mb/10) + " MB free";
	}
	
	if (free > 10*1024) {
		var kb = Math.floor(free/1024);
		return nformat(kb) + " KB free";
	}
	
	return nformat(free) + " bytes free";
}


// progress bar content
function bar_inner(file, count, size) {
	var perc = 100 - Math.floor(100 * count / size);
	return "<div class = 'progress'><div class='bar' style='width:" + perc + "%'></div></div>" +
			"<div class='fcancel'><a href='' onclick='fstop(\"" + file + "\");return false;'>" +
			"<img src='deletex.png' width='10' height='10' title='Cancel' /></a></div>";
}


// Called to refresh the currently displayed folder
function frefresh() {
	if (!delmode && !downld) {
		var curr = document.getElementById("ffolder").innerHTML;
		fileexpand(curr);
	}
}



// cancel upload
function fstop(file) {
	for (var n = 0; n < up_cache.length; n++) {
		if (up_cache[n]['File'] == file) {
			up_cache.splice(n, 1);
			
			var files = new Array();
			files[0] = file;
			
			var request = new Object();
			request['Message'] = "File Remove";
			request['Files'] = files;
		  chan.sendJson(request);
		  
		  frefresh();			
		}
		return false;	
	}
}



// Open the specified node
function fileexpand(folder) {
	if (chan.open) {
		var meta = new Object();
		meta['Op'] = "fileexpand";
		meta['Folder'] = folder;
		
		var request = new Object();
		request['Message'] = "File List";
		request['Meta'] = meta;
		request['Folder'] = folder;
	  chan.sendJson(request);
	}
}

function finit() {

	var droparea = document.getElementById('filedata');
	droparea.addEventListener('dragover', function(e) {
		e.dataTransfer.dropEffect = "copy";
		e.preventDefault();
		return false;
	});
	
	droparea.addEventListener('dragenter', function(e) {
		e.preventDefault();
		return false;
	});
	
	droparea.addEventListener('drop', function(e) {
		e.stopPropagation();
		e.preventDefault();
		
		var addr = document.getElementById("ffolder");
		var folder = addr.innerHTML;
		
		// check for sufficient space
		var space = free_space;
		var files = e.dataTransfer.files;
		for (var i = 0, file = null; file = files[i]; i++) 
			space -= file.size;
		if (space < 32*1024) {
			alert("There is not enough free file space for this operation!");
			return false;
		}
		
		for (var i = 0, file = null; file = files[i]; i++) {
			var reader = new FileReader();
			reader.onload = function(evt) {
				var data = evt.target.result;
				
				if (data.startsWith("data:"))
				{
					var fname = evt.target.fileFolder;
					if (!fname.endsWith("/"))
						fname += "/";
					fname += evt.target.fileName;

					// reject the event if the file is alreay transfering					
					var k = 0;
					for (; k < up_cache.length; k++) {
						if (up_cache[k]['File'] == fname) {
							break;
						}
					}
					if (k < up_cache.length)
						return false;
					
					var encpos = data.indexOf(";") + 1;
					var datpos = data.indexOf(",") + 1;
						
					if (evt.target.fileSize <= 3*SEGMENT) {
						var request = new Object();
						request['Message'] = "File Write";
						request['File'] = fname;
						request['Size'] = evt.target.fileSize;
						request['Mod'] = evt.target.lastModified;
						request['Encoding'] = data.substring(encpos, datpos - 1);
						request['Data'] = data.substring(datpos);
					  chan.sendJson(request);
					}
					else {
						var request = new Object();
						request['Message'] = "File Write";
						request['File'] = fname;
						request['Size'] = 3*SEGMENT;
						request['Mod'] = evt.target.lastModified;
						request['Encoding'] = data.substring(encpos, datpos - 1);
						request['Data'] = data.substr(datpos, 4*SEGMENT);
					  chan.sendJson(request);

						var xfer = new Object();
						xfer['File'] = fname;
						xfer['Size'] = evt.target.fileSize;
						xfer['Count'] = evt.target.fileSize - 3*SEGMENT;
						xfer['Mod'] = evt.target.lastModified;
						xfer['Encoding'] = data.substring(encpos, datpos - 1);
						xfer['Data'] = data.substr(datpos);
						xfer['Offset'] = 4*SEGMENT;
						up_cache[up_cache.length] = xfer;
					}
					
					var curr = document.getElementById("ffolder").innerHTML;
					fileexpand(curr);
				}
			}
			reader.fileFolder = folder;
			reader.fileName = file.name;
			reader.fileSize = file.size;
			reader.lastModified = file.lastModified;
			reader.readAsDataURL(file);
		}
	});

	var cmdarea = document.getElementById('screen');
	cmdarea.addEventListener('dragover', function(e) {
		e.dataTransfer.dropEffect = "copy";
		e.preventDefault();
		return false;
	});
	
	cmdarea.addEventListener('dragenter', function(e) {
		e.preventDefault();
		return false;
	});
	
	cmdarea.addEventListener('drop', function(e) {
		e.stopPropagation();
		e.preventDefault();
		
		// must be connected and at prompt
		var screen = document.getElementById("screen");
		content = screen.value;
		if (!connected || bfcharAt(caret - 2) != 62 || bfcharAt(caret - 1) != 32) {
			alert("Session must be active and at prompt!");
			return false;
		}
		
		var folder = "/temp/";
		
		// check for sufficient space
		var space = free_space;
		var files = e.dataTransfer.files;
		for (var i = 0, file = null; file = files[i]; i++) 
			space -= file.size;
		if (space < 32*1024) {
			alert("There is not enough free file space for this operation!");
			return false;
		}
		
		for (var i = 0, file = null; file = files[i]; i++) {
			var reader = new FileReader();
			reader.onload = function(evt) {
				var data = evt.target.result;
				
				if (data.startsWith("data:"))
				{
					var fname = evt.target.fileFolder;
					if (!fname.endsWith("/"))
						fname += "/";
					fname += evt.target.fileName;

					// reject the event if the file is alreay transfering					
					var k = 0;
					for (; k < up_cache.length; k++) {
						if (up_cache[k]['File'] == fname) {
							break;
						}
					}
					if (k < up_cache.length)
						return false;
					
					var encpos = data.indexOf(";") + 1;
					var datpos = data.indexOf(",") + 1;
						
					if (evt.target.fileSize <= 3*SEGMENT) {
						var request = new Object();
						request['Message'] = "File Write";
						request['File'] = fname;
						request['Size'] = evt.target.fileSize;
						request['Mod'] = evt.target.lastModified;
						request['Encoding'] = data.substring(encpos, datpos - 1);
						request['Data'] = data.substring(datpos);
					  chan.sendJson(request);

						var xfer = new Object();
						xfer['File'] = fname;
						xfer['Size'] = evt.target.fileSize;
						xfer['Count'] = 0;
						xfer['Mod'] = evt.target.lastModified;
						xfer['Encoding'] = data.substring(encpos, datpos - 1);
						xfer['Data'] = data.substr(datpos);
						xfer['Offset'] = 0;
						xfer['Source'] = "cmd";
						up_cache[up_cache.length] = xfer;
					}
					else {
						var request = new Object();
						request['Message'] = "File Write";
						request['File'] = fname;
						request['Size'] = 3*SEGMENT;
						request['Mod'] = evt.target.lastModified;
						request['Encoding'] = data.substring(encpos, datpos - 1);
						request['Data'] = data.substr(datpos, 4*SEGMENT);
					  chan.sendJson(request);

						var xfer = new Object();
						xfer['File'] = fname;
						xfer['Size'] = evt.target.fileSize;
						xfer['Count'] = evt.target.fileSize - 3*SEGMENT;
						xfer['Mod'] = evt.target.lastModified;
						xfer['Encoding'] = data.substring(encpos, datpos - 1);
						xfer['Data'] = data.substr(datpos);
						xfer['Offset'] = 4*SEGMENT;
						xfer['Source'] = "cmd";
						up_cache[up_cache.length] = xfer;
					}
					
					var curr = document.getElementById("ffolder").innerHTML;
					fileexpand(curr);
				}
			}
			reader.fileFolder = folder;
			reader.fileName = file.name;
			reader.fileSize = file.size;
			reader.lastModified = file.lastModified;
			reader.readAsDataURL(file);

			screen.className = "screen inactive";
			document.getElementById('status').innerHTML = "Transferring file to /temp <div class='transfer'><div class='bar' id='xfer' style='width:0'></div></div>";
			transfer = true;
		}
	});


}

// update when channel opens
var onopen_next = chan.onopen;
chan.onopen = function (evt) {
	fileexpand("/");
	if (onopen_next)
		onopen_next(evt);
}


// toggle hidden class
function toghide(c) {
	var elems = document.getElementsByClassName(c);
	for (var n = 0; n < elems.length; n++) {
		if (elems[n].className == c)
			elems[n].className = c + " hide";
		else
			elems[n].className = c;
	}
}


// Enables download selection mode
function fdownld() {
	if (!downld) {
		downld = true;

		// toggle memu display
		toghide("fmenu");
		toghide("fmenur");
		
		// obtain the selected set
		sel_array = new Array();
		var elems = document.getElementsByClassName("fileent");
		for (var n = 0; n < elems.length; n++) {
			if (elems[n].className == "fileent selected")
				sel_array[sel_array.length] = "Fname" + elems[n].id.substring(4);
		}

		var curr = document.getElementById("ffolder").innerHTML;
		fileexpand(curr);
	}
}


// Enables deletion select mode
function fdelete() {
	if (!delmode) {
		delmode = true;

		// toggle memu display
		toghide("fmenu");
		toghide("fmenur");

		// obtain the selected set
		sel_array = new Array();
		var elems = document.getElementsByClassName("fileent");
		for (var n = 0; n < elems.length; n++) {
			if (elems[n].className == "fileent selected")
				sel_array[sel_array.length] = "Fname" + elems[n].id.substring(4);
		}

		var curr = document.getElementById("ffolder").innerHTML;
		fileexpand(curr);
	}
}


// cancel selection mode
function fcancel() {
	delmode = false;
	downld = false;

	// toggle memu display
	toghide("fmenu");
	toghide("fmenur");
		
	frefresh();
}


// Complete the deletions
function fdone(evt) {
	evt.preventDefault();
	if (delmode) {
		delmode = false;

		// collect deletion requests
		var ckboxes = document.getElementsByClassName("fsel");
		var files = new Array();
		var list = "";
		var i = 0;
		for (var n = 0; n < ckboxes.length; n++) {
			if (ckboxes[n].checked) {
				var fspec = ckboxes[n].name;
				if (fspec.endsWith("/"))
					fspec = fspec.substring(0, fspec.length - 1);
				
				// The operation is not allowed if it is an upload in process
				for (var k = 0; k < up_cache.length; k++) {
					if (up_cache[k]['File'] == fspec) {
						alert("Upload is in progress for a selected file.");
						return false;
					}
				}
				
				files[i++] = fspec;

				// create list to display
				if (list.length == 0)
					list = ckboxes[n].name;
				else if (n == ckboxes.length - 1)
					list += " and " + ckboxes[n].name;
				else
					list += ", " + ckboxes[n].name
			}
		}
		
		// remove files
		if (files.length > 0) {
			if (evt.shiftKey || confirm("Remove " + list + "?")) {
				var request = new Object();
				request['Message'] = "File Remove";
				request['Files'] = files;
			  chan.sendJson(request);
			}
		}
		
		// toggle memu display
		toghide("fmenu");
		toghide("fmenur");
		frefresh();
	}
	
	else if (downld) {
		downld = false;

		// toggle memu display
		toghide("fmenu");
		toghide("fmenur");
		
		// hold downloading
		if (dld_timer) {
			clearTimeout(dld_timer);
			dld_timer = null;
		}
		
		// collect download requests
		var ckboxes = document.getElementsByClassName("fsel");
		var i = 0;
		for (var n = 0; n < ckboxes.length; n++) {
			if (ckboxes[n].checked) 
				dld_array[dld_array.length] = ckboxes[n].name;
		}
		
		// fire off downloading if we have added files
		if (dld_array.length > 0)
			dld_timer = setTimeout(downloader, 250);
		
		frefresh();
	}
}


// timer event to sequence downloads
function downloader() {
	// stop if nothing to do
	if (dld_array.length == 0) {
		dld_timer = null;
		return false;
	}
	
	// download next request
	download(dld_array[0]);
	dld_array.splice(0, 1);
	
	// reschedule if there are more
	if (dld_array.length > 0)
		dld_timer = setTimeout(downloader, 250);
	}
	

// Download a file
function download(fspec) {
		var requestid = Math.floor(Math.random() * 1000000000000000);

		var url = document.baseURI;
		if (!url)
			url = location.href;
		var pos = url.indexOf("//");
		if (pos > 0) {
			pos = url.indexOf("/", pos + 2);
			if (pos > 0)
				url = url.substring(0, pos);
			url += "/query.cgi?request=" + requestid;
		}
		
		var request = new Object();
		request['Message'] = "File Read";
		request['Meta'] = url;
		request['File'] = fspec;
		request['RequestID'] = requestid;
	  chan.sendJson(request);
}


// supports dragging files out of the DCP. This is called when you start to drag a row
//  out of the File Folders tab file/folder listing.
function fdragstart(e) {
	var file = e.target.id;
	if (!file.startsWith("Drag"))
		return;
		
	var requestid = Math.floor(Math.random() * 1000000000000000);
	
	file = file.substring(4);
	fname = file.substring(file.lastIndexOf("/") + 1);
	var url = e.target.baseURI;
	var pos = url.indexOf("//");
	if (pos > 0) {
		pos = url.indexOf("/", pos + 2);
		if (pos > 0)
			url = url.substring(0, pos);
		url += "/query.cgi?request=" + requestid;
	}
		
	var request = new Object();
	request['Message'] = "File Read";
	request['File'] = file;
	request['RequestID'] = requestid;
  chan.sendJson(request);
			
	e.dataTransfer.setData("DownloadURL", "text/plain:" + fname + ":" + url);	
	e.dataTransfer.dropEffect = "copy";
}


// double click event for folders
function fdblclick(evt) {
	// cancel any pending rename
	if (rnclick) {
		clearTimeout(rnclick);
		rnclick = null;
	}
	
	var fspec = evt.currentTarget.id;
	if (fspec.startsWith("Fname/")) {
		fspec = fspec.substring(5);
		if (fspec.endsWith("/")) {
			fspec = fspec.substring(0, fspec.length - 1);
			fileexpand(fspec);
		}
		else {
			if (lastclick)
				lastclick.className = "fileent selected";

			// hold downloading
			if (dld_timer) {
				clearTimeout(dld_timer);
				dld_timer = null;
			}
			
			dld_array[dld_array.length] = fspec;
			dld_timer = setTimeout(downloader, 250);
		}
	}
}


// rename file after changes
function frename(evt) {
	var fld = evt.currentTarget;
	var fspec = fld.name;
	if (fspec.endsWith("/"))
		fspec = fspec.substring(0, fspec.length - 1);
		
	var folder = fspec.substring(0, fspec.lastIndexOf("/"));
	if (fld.value != "undefined") {
		var nspec = folder + "/" + fld.value;
		
		if (nspec != fspec) {
			var request = new Object();
			request['Message'] = "File Rename";
			request['Old'] = fspec;
			request['New'] = nspec;
		  chan.sendJson(request);
		}
	}
	
	fileexpand(folder.length > 0 ? folder : "/");
}


// adds new folder
function fnewfolder(evt) {
	var folder = document.getElementById("ffolder").innerHTML;
	if (!folder.endsWith("/"))
		folder += "/";
	folder += "NewFolder";

	var request = new Object();
	request['Message'] = "File Mkdir";
	request['Folder'] = folder;
  chan.sendJson(request);
  
  // Sets us up to rename the new folder upon refresh.
  creating_folder = true;
  frefresh();
}

// click events for files
function fclick(evt) {
	var elem = evt.currentTarget;
	var row = document.getElementById("Drag" + evt.currentTarget.id.substring(5));
	var d = new Date();
	if (lastclick != row) {
		
		// cancel rename
		if (rnclick) {
			clearTimeout(rnclick);
			rnclick = null;
		}

		// onclick without Ctrl clears previous selections
		var elems = document.getElementsByClassName("fileent");
		if (!evt.ctrlKey) {
			for (var n = 0; n < elems.length; n++) 
				elems[n].className = "fileent";
		}
		
		// onclick with Shift selects range from lastclick
		var checking = false;
		if (evt.shiftKey) {
			for (var n = 0; n < elems.length; n++) {
				if (elems[n] == lastclick || elems[n] == row) {
					elems[n].className = "fileent selected";
					checking ^= true;
				}
				else if (checking)
					elems[n].className = "fileent selected";
			}			
		}
		lastclick = row;
		
		// click with Ctrl toggles the selection
		if (evt.ctrlKey && row.className == "fileent selected")
			row.className = "fileent";
		else
			row.className = "fileent selected";

		return false;
	}	
	
	//schedule rename
	pending_id = elem.id;
	rnclick = setTimeout(frnclick, 750);
}

function frnclick() {
	if (rnclick == null)
		return;
	rnclick = null;
	
	var fid = pending_id;
	var elem = document.getElementById(fid);
	
	if (fid.startsWith("Fname/")) {
		fspec = fid.substring(5);

		var fname = fspec;
		if (fspec.endsWith("/"))
			fname = fspec.substring(0, fspec.length - 1);
			
		var pos = fname.lastIndexOf("/");
		if (pos >= 0)
			fname = fname.substring(++pos);
			
		elem.innerHTML = "<input class='frename' id='frename' name='" + fspec + "' type='text' style='width:100%;min-width:150px' value='" + fname + "'/>";
		elem.onclick = null;
		elem.ondblclick = null;
		
		var fld = document.getElementById("frename");
		var pos = fname.lastIndexOf(".");
		fld.selectionStart = 0;
		fld.focus();
		fld.onblur = frename;
		fld.onkeydown = textKeydown;

		if (pos >= 0)
			fld.selectionEnd = pos;
		else
			fld.selectionEnd = fname.length;			
	}
}

// Prevent departure while uploads are in progress (message ignored these days)
window.onbeforeunload = function (e) {
	if (up_cache.length > 0)
	  return "Uploading in progress. Are you sure that you want to exit?";
};

// Refresh the page periodically if nothing selected
function fupdate() {
	var elems = document.getElementsByClassName("fileent");
	for (var n = 0; n < elems.length; n++) {
		if (elems[n].className == "fileent selected")
			return false;
	}
	
	frefresh();
}