 /*
  JNIOR Monitor/Configuration Page
  INTEG Process Group, Inc., 2919 E Hardies Rd, Gibsonia PA 
  724.933.9350
  
  File: analog.js
  
  The user is hereby granted license to use, modify, and redistribute the contents of this
  file for any purpose, commercial or otherwise. No prior authorization by INTEG Process 
  Group, Inc. is required.
*/ 

// Function returns HTML for the 10V and 4-20ma modules
function device_analog(key) {
	var id = module_keyToId[key];
	var type = id.substring(id.length - 2);
	var ma = (type == "FE" ? true : false);
	
	var modkey = "externals/" + id.toLowerCase() + "/";
	var key = modkey + "desc";
	var desc = getkey(key, !ma ? "Analog 10V" : "Analog 4-20ma");		
	
	var units = !ma ? "volts" : "mA";
	
	var inner = "<td name='analog'>";
	inner += "<p class='modname'><span name='" + key + "'>" + desc + "</span></p>";
	inner += "<p class='modaddr'>" + id + "</p>";
	inner += "<div class='modio'>";
	
	inner += "<table class='analoginput'>";
	for (var n = 0; n < 4; n++) {
		var idn = "ain:" + n + ":" + id;
		var ch = n + 1;
		var chkey = modkey + "ain" + ch + "/";
		
		// check for enabled channel
		var enab_key = chkey + "enable";
		var enab_val = istrue(getkey(enab_key, "enabled"));
		if (enab_val) {
			inner += "<tr><td class='reading' id='" + idn + "'></td>";

			// get input channel configuration details
			var desc_key = chkey + "desc";
			var desc_val = getkey(desc_key, "Channel " + ch);
			var units_key = chkey + "units";
			var units_val = getkey(units_key, ma ? "ma" : "V");
			inner += "<td class='units' name='" + units_key + "'>" + units_val + "</td>";
			inner += "<td name='" + desc_key + "'>" + desc_val + "</td>";
			inner += "</tr>";
		}
		else
			inner += "<tr><td colspan=3></td></tr>";
	}
	inner += "</table>";

	inner += "<table class='analogoutput'>";
	for (var n = 0; n < 2; n++) {
		var idn = "aout:" + n + ":" + id;
		var ch = n + 1;
		var chkey = modkey + "aout" + ch + "/";
		
		// check for enabled channel
		var enab_key = chkey + "enable";
		var enab_val = istrue(getkey(enab_key, "enabled"));
		if (enab_val) {
			inner += "<tr>";
			
			// get output channel configuration details
			var desc_key = chkey + "desc";
			var desc_val = getkey(desc_key, "Analog Output " + ch);
			var units_key = chkey + "units";
			var units_val = getkey(units_key, "%");
			inner += "<td name='" + desc_key + "'>" + desc_val + "</td>";
			inner += "<td class='reading' id='" + idn + "'></td>";
			inner += "<td class='units' name='" + units_key + "'>" + units_val + "</td>";
			inner += "<td class='setctrl'>";
			if (jnior_control) {
				inner += "<button onclick='";
				inner += "setAnalog(\"" + 
						chkey + "\",\"" + 
						id + "\",\"" + 
						n + "\",\"" + 
						desc + 
						"\");'>Set</button>";
			}
			inner += "</td></tr>";
		}
		else
			inner += "<tr><td colspan=4></td></tr>";
	}
	inner += "</table>";
	inner += "</div>";
	inner += "</td>";
	return inner;
}

// Function updates 10V and 4-20ma module block content
function update_analog(key) {
	var id = module_keyToId[key];
	
	var status = module_idToStatus[id];
	if (status == null)
		return;	

	var type = id.substring(id.length - 2);
	var ma = (type == "FE" ? true : false);
	var modkey = "externals/" + id.toLowerCase() + "/";
	
	// update input value
	for (var n = 0; n < 4; n++) {
		var idn = "ain:" + n + ":" + id;
		var ch = n + 1;
		var chkey = modkey + "ain" + ch + "/";

		var elem = document.getElementById(idn);
		if (elem) {
			var min_key = chkey + "min";
			var min_val = Number(getkey(min_key, ma ? "4.0" : "-10.0"));
			var max_key = chkey + "max";
			var max_val = Number(getkey(max_key, ma ? "20.0" : "10.0"));
			var dec_key = chkey + "decimals";
			var dec_val = Math.floor(Number(getkey(dec_key, "2")));
			
			var raw = parseInt(status.substring(4 * n, 4 * n + 4), 16);
			var reading = (max_val - min_val) * (raw / 0xfff0) + min_val;
			var value = reading.toFixed(dec_val);
			elem.innerHTML = value;
		}
	}
	
	// update output values
	for (var n = 0; n < 2; n++) {
		var idn = "aout:" + n + ":" + id;
		var ch = n + 1;
		var chkey = modkey + "aout" + ch + "/";

		var elem = document.getElementById(idn);
		if (elem) {
			var min_key = chkey + "min";
			var min_val = Number(getkey(min_key, "0.0"));
			var max_key = chkey + "max";
			var max_val = Number(getkey(max_key, "100.0"));
			var dec_key = chkey + "decimals";
			var dec_val = Math.floor(Number(getkey(dec_key, "2")));
			
			var raw = parseInt(module_idToStatus[id].substring(4 * n + 16, 4 * n + 20), 16);
			var reading = (max_val - min_val) * raw / 0xfff0 + min_val;
			var value = reading.toFixed(dec_val);
			elem.innerHTML = value;
		}
	}

	return true;
}


// Clicked Set for analog module. This initializes the popup and displays it.
function setAnalog(chkey, id, outn, desc) {
	var desc_key = chkey + "desc";
	var desc_val = getkey(desc_key, null);
	var units_key = chkey + "units";
	var units_val = getkey(units_key, "%");
	
	document.getElementById('ankey').innerHTML = chkey;
	document.getElementById('anid').innerHTML = id;
	document.getElementById('anchan').innerHTML = outn;
	document.getElementById('anmodule').innerHTML = desc;
	document.getElementById('anoutput').innerHTML = desc_val;
	document.getElementById('anunits').innerHTML = units_val;
	
	var idn = "aout:" + outn + ":" + id;
	var elem = document.getElementById(idn);
	if (elem) {
		var inp = document.getElementById('anvalue');
		if (inp)
			inp.value = elem.innerHTML;

		setan();
	
		inp.focus();
		inp.select();	
		inp.onkeyup = function (e) { if (e.keyCode == 13) setanOK(); };
	}
}

// Toggles visibility of the External Analog setting dialog
function setan() {
	el = document.getElementById('setan');
	el.style.display = getComputedStyle(el).getPropertyValue('display') == "none" ? "inherit" : "none";
}

// Clicked Cancel. Hide popup.
function setanCancel() {
	setan();
}

// Clicked OK. Determines action and does it. Popup is hidden.
function setanOK() {
	var chkey = document.getElementById('ankey').innerHTML;
	var id = document.getElementById('anid').innerHTML;
	var outn = document.getElementById('anchan').innerHTML;
	var value = document.getElementById('anvalue').value;
	setan();
	
	var min_key = chkey + "min";
	var min_val = Number(getkey(min_key, null));
	var max_key = chkey + "max";
	var max_val = Number(getkey(max_key, null));
	if (min_val == max_val)
		return false;

	if (value > max_val)
		value = max_val;
	else if (value < min_val)
		value = min_val;
	
	var raw = Math.floor((0xFFF0 * (value - min_val) / (max_val - min_val)));
	var hex = (raw + 0x10000).toString(16).substr(1);
	var status = module_idToStatus[id];
	if (outn == 1)
		var block = status.substr(status.length - 8, 4) + hex;
	else
		var block = hex + status.substr(status.length - 4);
	
	var device = new Object();
	device['Address'] = id;
	device['Hex'] = block;
	
	var request = new Object();
	request['Message'] = "Write Devices";
	request['Devices'] = new Array(device);
	chan.sendJson(request);	
	
	request['Message'] = "Read Devices";
	request['Devices'] = new Array(id);
	chan.sendJson(request);	
}