 /*
  JNIOR Monitor/Configuration Page
  INTEG Process Group, Inc., 2919 E Hardies Rd, Gibsonia PA 
  724.933.9350
  
  File: comm.js
  
  Javascript here creates a persistent Websocket connection back to the server. Initialize
  the connection as follows:
  
  	var web_socket = new Comm();
  
  The user is hereby granted license to use, modify, and redistribute the contents of this
  file for any purpose, commercial or otherwise. No prior authorization by INTEG Process 
  Group, Inc. is required.
*/

function Comm() {
	this.ws = null;
	this.onopen = null;
	this.onmessage = null;
	this.onclose = null;
	this.onerror = null;

	this.onauth = null;
	this.username = null;
	this.password = null;
	this.nonce = null;
	
	this.conn = 0;
	this.open = false;
	this.auth = 0;
	
	this.date = new Date();
	this.process_start = this.date.getTime();
	this.message_time = Date.now();

	// get current URI for the connection
	this.wsUri = "ws://" + window.location.host;
	if (window.location.protocol == "https:")
  	this.wsUri = "wss://" + window.location.host;
  	
	this.connect = function() {
		// TRUE once we are open and receiving Monitor packets
		this.open = false;
		this.auth = 0;
		
		// Indicates unique connection
		this.conn++;
		
		// establish the connection
		this.ws = new WebSocket(this.wsUri);
		//this.sendJson({'Message': ''});
		
		this.ws.onerror = function(evt) {
			if (this.onerror)
				this.onerror(evt);
		}.bind(this);
		
		this.ws.onmessage = function(evt) {
			this.message_time = Date.now();
			
	  	var uptime = new Date().getTime() - this.process_start;
			console.log("COMM" + this.conn + ": " + uptime + "  RECV <--:   " + evt.data);

		  var jobj = JSON.parse(evt.data);
		  if (jobj['Message'] === 'Error' && jobj['Text'] === '401 Unauthorized') {
		  	this.nonce = jobj['Nonce'];
	
		  	if (this.auth == 0 && this.username && this.password) 
					var digest = this.username + ":" + md5(this.username + ":" + this.nonce + ":" + this.password);
				else {
					if (this.onauth) 
						this.onauth(evt);
					return;
				}
					
				// can provide authentication now
		    var response = new Object();
		    response['Auth-Digest'] = digest;
		    this.sendJson(response);
		    this.auth++;
		  }
		  else {
		  	if (!this.open) {
		  		if (jobj['Message'] === 'Monitor') {
			  		// we are now open
			  		this.open = true;
			  		if (this.onopen)
			  			this.onopen(evt);
			  	}
			  	else 
						this.sendJson({'Message': 'Status'});
			  }
		  	if (this.onmessage)
		  		this.onmessage(evt);
		  }
		}.bind(this);
		
		// called to provide authentication
		this.authenticate = function(username, password) {
			if (this.nonce && username && password) {
				this.auth = 0;
				this.username = username;
				this.password = password;
				var digest = username + ":" + md5(username + ":" + this.nonce + ":" + password);

		    var response = new Object();
		    response['Auth-Digest'] = digest;
		    this.sendJson(response);
		    this.auth++;
		    this.nonce = null;
			}
		}.bind(this);

		// cause reconnect if we close		
		this.ws.onclose = function(evt) {
			if (this.onclose)
				this.onclose(evt);
			this.reconnect();
		}.bind(this);	

		var cookies = document.cookie.split(';');
		var text = '{"Cookies":[';
		for (var n = 0; n < cookies.length; n++) {
			var c = cookies[n];
			var p = c.indexOf("=");
			if (p > 0) {
				if (n > 0)
					text += ',';
				text += '{"' + c.substring(0, p).trim() + '":"' + c.substring(p + 1).trim() + '"}';
			}
		}
		text += ']}';
 		chan.sendJson(JSON.parse(text));
		
	};
	
	this.reconnect = function() {
		if (!this.ws || this.ws.readyState == 3) {
			document.getElementById("txt").innerHTML = "Reconnecting";
			this.connect();
		}
	}.bind(this);
	
	// background check to catch any odd disconnect
	setInterval(this.reconnect, 5000);

	this.sendJson = function(json) {
	  var message = JSON.stringify(json);
	
	  // wait for socket ready to send
	  this.socketWait(this.conn, function() {
	  	var uptime = new Date().getTime() - this.process_start;
			console.log("COMM" + this.conn + ": " + uptime + "  SEND -->:   " + message);	// $$$$$$$$$$
	    this.ws.send(message);
	  }.bind(this));
	}.bind(this);

	this.socketWait = function(conn, callback) {
		if (conn == this.conn) {
		  if (this.ws.readyState === this.ws.OPEN) {
		    if (callback != null)
		    callback();
		    return;
		  } 
		  else if (this.ws.readyState === this.ws.CONNECTING) 
		    setTimeout(function() {this.socketWait(conn, callback);}.bind(this), 1000);
		}
	}.bind(this);
};

function istrue(str) {
	var val = str.trim();
	val = val.toLowerCase();
	if (val === "1" || val === "on" || val === "yes" || val === "true" || val === "enable" || val === "enabled")
		return (true);
	return (false);
}

