<?php
  // Determine request type
  $help = $_GET['help'];
  $cat = $_GET['category'];
  $manual = ($help === '-manual' ? true : false);
  $topics = ($help === '*' ? true : false);
  setRegistryString("WebServer/Public/manpages", "/flash/manpages/include/");
?>
<html lang='en'>
  <head>
    <title>
      <?php
        // Give the page an appropriate title
        if ($manual)
          echo "JNIOR Users Manual";
        else if (strlen($help) == 0)
          echo "JANOS Command List";
        else if ($help === "*")
          echo "JANOS Help Topics";
        else
          echo "JANOS Help: ".$help;
      ?>
    </title>
    <style>
      <?php
        // Define DIV format
        if (!$manual)
          puts("div {font-family:monospace;white-space:pre;}");
        else {
          puts("div {font-family:monospace;white-space:pre;page-break-after:always;margin-top:1em;}");
          puts("@media screen {div {border:solid 1px #aaaaaa;width:92ch;padding:5em 0 5em 4ch;margin-left:0.5in;}}");
          
          // special binding settings
          puts("@page {margin:1.0in 0.75in 0 1.25in;}");
					if (getRegistryBoolean("Help/Binding", FALSE)) {
	          puts("@page :right{margin-right:0;margin-left:1.5in;}");
	          puts("@page :left{margin-left:0.5in;margin-right:0in;}");
	        }
        }
      ?>
      
      a, a:visited a:hover, a:active {color:#0000EE;}

      .container {
        visibility: hidden;
        position: fixed;
        left: 0px;
        top: 0px;
        z-index: 1000;
        width: 80ch;
        height: 16em;
      }

      .popup {
        margin: auto;
        width: 40ch;
        background-color: #f8f8f8;
        border:1px solid #000;
        border-radius: 4px;
        text-align:center;
        white-space: normal;
        padding: 0 0 10px 0;
      }

      .hdr {
        width: auto;
        border-radius: 4px 4px 0 0;
        border-bottom:1px solid #000;
        background-color: #eeeeee;
        text-align: right;
        font-weight: bold;
        margin: 0 0 10px 0;
        padding: 0 4px 0 0;
      }
      
      #loading {
      	width: 80ch;
      	font-family: monospace;
      	white-space: pre;
      	text-align: center;
      	border: 0;
      }
        
      #scale {
      	margin: auto;
      	margin-top: 5px;
      	width: 200px;
      	height: 8px;
      	padding: 0;
        border-radius: 3px;
      	border:1px solid #000;
      }
      
      #perc {
      	width: 0;
      	height: 100%;
      	margin: 0;
      	padding: 0;
        background-color: #aaaaaa;
        border: 0;
      }
    </style>

    <script>
    	time = 0;
    	duration = <?php=getRegistryString("Help/\$gentime", "45");?>;
    	timer = setInterval(tick, 2000);
    	
    	function tick() {
    		time += 2;
    		perc = (100 * time) / duration;
    		if (perc > 100)
    			perc = 100;
    		el = document.getElementById('perc');
    		if (el)
    			el.style.width = "" + perc + "%";
    		if (perc >= 100)
					clearInterval(timer);
    	}
    	
      function submitOnEnter(event) {
          if(event.which === 13)
            dosearch(2);
      }

      function dosearch(mode) {
        el = document.getElementById("search");
        switch (mode) {
          case 0: // cancel
            el.style.visibility = "hidden";
            break;

          case 1: //show

            el.addEventListener("keypress", submitOnEnter);
            el.style.visibility = "visible";
            document.getElementById("query").focus();
            break;

          case 2: // OK
            query = document.getElementById('query').value;
            el.style.visibility = "hidden";
            window.location.href="query.cgi?help=*" + query.trim();
            break;
        }
      }
    </script>
  </head>
  <body <?php=$manual ? "onload='ready()'" : "";?>>
    <?php
      // Standard header is used except with the manual
      if (!$manual) {
        puts("<div>JANOS Help System: ".
          "[<a href='query.cgi?help='>Commands</a>] ".
          "[<a href='query.cgi?help=*'>Topics</a>] ".
          "[<a href='query.cgi?help=Support'>Tech Support</a>] ".
          "[<a target='_blank' href='query.cgi?help=-manual' ".
          	"title='45-60 seconds to generate'".
          	">Printable Manual</a>] ".
          "[<a href=\"javascript:void(0);\" onclick=\"dosearch(1);\">Search</a>]".
          "\r\n\r\n</div>");

				// we include class filters when the topics list is requested
				if ($topics) {

					// if filtered we show what category
					if (!is_null($cat))
					{
						echo "<div><b>CATEGORY \"$cat\"</b>  ".
								"[<a href='query.cgi?help=*'>clear</a>]\r\n\r\n</div>";
						$result = manpages("*", TRUE, $cat);
						echo $result;
					}
							
					else {
						
						// obtain categories
						$result = manpages("-categories", FALSE);
						
						if (strlen($result) > 0) {
							
							echo "<div><b>AVAILABLE CATEGORIES</b>\r\n\r\n";
							
							// Count the number of categories reported and determine 
							//  the maximum width. This creates an array of categories so we
							//  can later pivot the ordering.
							$pos = 0;
							$ncats = 0;
							$width = 0;
							$cats = array();
		          while ($pos < strlen($result)) {
		          	$nl = strpos($result, "\r\n", $pos);
		          	if ($nl < 0)
		          		break;

								$cats[] = substr($result, $pos, $nl - $pos);
								$ncats++;
			          if ($nl - $pos > $width)
			          	$width = $nl - $pos;

		          	$pos = $nl + 2;
		          }
		          
		          // determine good looking numnber of columns for displaying 
		          //  categories. There should be at least 4 rows and we don't
		          //  want the last column to have just a single item.
		          $ncols = intval(80 / $width);
		          while ($ncols > 1 && intval($ncats / $ncols) < 3) 
		          	$ncols--;
		          $nrows = intval($ncats / $ncols) + 1;

							// turn each line into a link
		          for ($r = 0; $r < $nrows; $r++) {
		          	for ($c = 0; $c < $ncols; $c++) {
		          		$entry = $cats[$c * $nrows + $r];
		          		if (is_null($entry))
		          			break;

			          	$sep = strpos($entry, " ");
			          	$category = substr($entry, 0, $sep);
			          	$count = substr($entry, $sep + 1);

			          	echo "  <a href='query.cgi?help=*&category=$category'>$category</a>".
			          		" $count";

		          		for ($n = $width - strlen($entry); 0 <= $n; $n--)
		          			echo " ";
		          	}
		          	puts();
		          }
		          echo "\r\n</div>";
		        }

						$result = manpages("*", TRUE);
						echo $result;
					}
				}
				
				// otherwise lookup the requested item
				else {
					$result = manpages($help, TRUE);
					if (strlen($result) == 0) {
						if (!startsWith($help, "*"))
							$result = manpages("*$help", TRUE);
					}
					echo $result;
				}
      }

			// otherwise load the users manual 
      else {
      	// check for cache file and the need to update it
      	$cache = "/temp/_hlpcache";
      	if(file_exists($cache) && (manpages("-timestamp", FALSE) <= filemtime($cache))) {
      		echo fread($cache);
	        echo "<script>function ready() {}</script>";
      	}

				// otherwise we need to generate the document
				else {
					$start = time();

	        puts("<div id='loading'>".
	          "Generating Document<br>".
	          "<div id='scale'><div id='perc'></div></div></div>");
	        flush();

					// generate the document and cache it
		      $content = manpages($help, TRUE);
		      
	        // find the heading
	        $pos = strpos($content, "JNIOR");

	        // skip lines
	        for ($n = 8; $n >= 0; $n--)
	          $pos = strpos($content, "\n", $pos + 1);

	        // create the content inserting the IMG tag centered
	        $result = substr($content, 0, $pos);
	        $result .= "<img src='/manpages/integlogo.png' style='height:5em;margin-left:31ch;'>";

	        // skip lines
	        for ($n = 4; $n >= 0; $n--)
	          $pos = strpos($content, "\n", $pos + 1);

	        $result .= substr($content, $pos + 1);
	        fwrite($cache, $result);

					// serve the new document
	        echo $result;

					// calibrate progress bar for future reference	        	
	        setRegistryString('Help/$gentime', strval(time() - $start));

	        // remove loading message
	        echo "<script>function ready() {".
	        	"document.getElementById('loading').style.display = 'none';".
	        	"}</script>";
        }
      }
    ?>

    <div class="container">
      <div id="search" class="popup">
        <div class='hdr'><a href='javascript:void(0);' onclick='dosearch(0)'>X</a></div>
        <b>Search HELP Content</b><br><br>
        <input type='text' id='query' size="32"><br><br>
        <button onclick='dosearch(2)'>OK</button> <button onclick='dosearch(0)'>Cancel</button><br>
      </div>
    </div>

  </body>
</html>
