 /*
  JNIOR Monitor/Configuration Page
  INTEG Process Group, Inc., 2919 E Hardies Rd, Gibsonia PA 
  724.933.9350
  
  File: temperature.js
  
  The user is hereby granted license to use, modify, and redistribute the contents of this
  file for any purpose, commercial or otherwise. No prior authorization by INTEG Process 
  Group, Inc. is required.
*/ 

// Function returns HTML for a Temperature Sensor
function device_temp(key) {
	var id = module_keyToId[key];
	var idn = "temp:" + id;

	var modkey = "externals/" + id.toLowerCase() + "/";
	var desc_key = modkey + "Desc";
	var desc = getkey(desc_key, "Temperature Sensor");
	
	var status = module_idToStatus[id];
	var raw = parseInt(status.substr(0, 3), 16);
	var sign = raw & 0x100 ? -1 : 1;
	var exponent = (raw & 0x7FF) - 1023;
	var frac = sign * (parseInt(status.substr(3), 16) / 0x10000000000000 + 1.0);
	var reading = frac * Math.pow(2, exponent);
	var celsius = reading.toFixed(1);
	var fahrenheit = (9 * reading / 5 + 32.0).toFixed(1);
	
	var fahr = istrue(getkey(modkey + "Fahrenheit", "false"));
	
	var inner = "<td name='temp'>";
	inner += "<p class='modname' name='" + keystd(desc_key) + "'>" + desc + "</span></p>";
	inner += "<p class='modaddr'>" + id + "</p>";
	inner += "<div class='modio' id='" + idn + "'>";
	if (fahr) {
		inner += "<div class='temperature'>" + fahrenheit + "</div><div class='degrees'>&deg;F</div>";
		inner += "<div class='alttemp'>" + celsius + "&deg;C</div>";
	}
	else {
		inner += "<div class='temperature'>" + celsius + "</div><div class='degrees'>&deg;C</div>";
		inner += "<div class='alttemp'>" + fahrenheit + "&deg;F</div>";
	}
	inner += "</div>";
	inner += "</td>";
	return inner;
}

// Updates the Temperature Sensor block
function update_temp(key) {
	var id = module_keyToId[key];
	var idn = "temp:" + id;

	var modkey = "externals/" + id.toLowerCase() + "/";
	var fahr = istrue(getkey(modkey + "Fahrenheit", "false"));

	var status = module_idToStatus[id];
	var raw = parseInt(status.substr(0, 3), 16);
	var sign = raw & 0x100 ? -1 : 1;
	var exponent = (raw & 0x7FF) - 1023;
	var frac = sign * (parseInt(status.substr(3), 16) / 0x10000000000000 + 1.0);
	var reading = frac * Math.pow(2, exponent);
	var celsius = reading.toFixed(1);
	var fahrenheit = (9 * reading / 5 + 32.0).toFixed(1);

	var elem = document.getElementById(idn);
	if (elem) {
		if (fahr) {
			var inner = "<div class='temperature'>" + fahrenheit + "</div><div class='degrees'>&deg;F</div>";
			inner += "<div class='alttemp'>" + celsius + "&deg;C</div>";
			elem.innerHTML = inner;
		}
		else {
			var inner = "<div class='temperature'>" + celsius + "</div><div class='degrees'>&deg;C</div>";
			inner += "<div class='alttemp'>" + fahrenheit + "&deg;F</div>";
			elem.innerHTML = inner;
		}
	}
		
	return false;
	
}