 /*
  JNIOR Monitor/Configuration Page
  INTEG Process Group, Inc., 2919 E Hardies Rd, Gibsonia PA 
  724.933.9350
  
  File: registry.js
  
  This file contains the basic Javascript required by the main page. This handles dynamic
  updates and page controls.
  
  The user is hereby granted license to use, modify, and redistribute the contents of this
  file for any purpose, commercial or otherwise. No prior authorization by INTEG Process 
  Group, Inc. is required.
*/ 

// Open the specified node
function regexpand(node) {
	if (node == "/")
		node = "";

	// load the node/link line  
  var rnode = document.getElementById("regnode");
  if (rnode == null)
  	return;
  	
  if (node.length == 0)
	  rnode.innerHTML = "/";
	else
	  rnode.innerHTML = node;

	var meta = new Object();
	meta['Op'] = "regexpand";
	meta['Node'] = node;
	
	var request = new Object();
	request['Message'] = "Registry List";
	request['Meta'] = meta;
	request['Node'] = node;
  chan.sendJson(request);
}

// Collapse the specified node
function regcollapse(node) {
	if (node == "/")
		node = "";
		
	var nodeid = "Registry/" + node;
	
	var key = nodeid.substr(0, nodeid.length - 1);
	key = key.substr(key.lastIndexOf("/") + 1);
	if (key.length == 0)
		key = "Registry";

	document.getElementById(nodeid).innerHTML = "<a href='' onclick='regexpand(&quot;" + node + 
			"&quot;);return(false);'><img src='collapsed.png' width='10' height='10'></img>" + key + "</a>";
}

// process messages
var reg_onmessage = chan.onmessage;
chan.onmessage = function(evt) {
	var jobj = JSON.parse(evt.data);

	if (jobj['Message'] === 'Registry List Response') {
		var meta = jobj['Meta'];
		var op = meta['Op'];
		
		if (op === "regexpand") {
			var node = meta['Node'];
			var nodeid = "Registry/" + node;
			var expl = document.getElementById(nodeid);
			var pad = parseInt(getComputedStyle(expl).getPropertyValue('padding-left')) + 10;
			
			var key = nodeid.substr(0, nodeid.length - 1);
			key = key.substr(key.lastIndexOf("/") + 1);
			if (key.length == 0)
				key = "Registry";
			var cexpl = "<a href='' onclick='regcollapse(&quot;" + node + 
						"&quot;);return(false);'><img src='expanded.png' width='10' height='10'></img>" + key + "</a>";

			var keys = jobj['Keys'];
			
			var ent = new Array();
			var k = 0;
			var dat = document.getElementById("keydata");
			var cdat = "<table class='rkeys'><tr><th style='text-align:center'>Key</th><th style='text-align:center'>Content</th></tr>";
			
			// sort keys
			for (n = 0; n < keys.length - 1; n++) {
				var key1 = keys[n].toLowerCase();
				var key2 = keys[n + 1].toLowerCase();
				if (key1.endsWith("/") && !key2.endsWith("/"))
					continue;
				if ((!key1.endsWith("/") && key2.endsWith("/")) || key1 > key2) {
					var key = keys[n];
					keys[n] = keys[n + 1];
					keys[n + 1] = key;
					if (n > 0) n -= 2;
				}
			}
			
			for (n = 0; n < keys.length; n++) {
				var keynode = keys[n];
				var key = keynode.substr(node.length);
				
				if (key.endsWith("/")) {
					cexpl += "<br><span id='Registry/" + keynode + "' style='padding-left:" + pad + 
						"px'><a href='' onclick='regexpand(&quot;" + keynode + 
						"&quot;);return(false);'><img src='collapsed.png' width='10' height='10'></img>" + 
						key + "</a></span>";
				}
				else {
					cexpl += "<br><span style='padding-left:" + pad + "px'><img src='linked.png' width='10' height='10'></img>";

					if (keynode.startsWith("$")) {
						cexpl += key + "</span>";
						cdat += "<tr><th>" + key + 
							"</th><td class='static'><span name='" + keynode.toLowerCase() + "' title='" + keynode + "'></td></tr>";
					}
					else {
						cexpl += "<span ondblclick='newkey(&quot;" + keynode + 
							"&quot;);' title='dblclick: Advanced Edit'>" + key + "</span></span>";
							
						cdat += "<tr class='regent'><th><a href='' onclick='rmkey(&quot;" + keynode + "&quot;);return(false);'>" + 
							"<img class='regdel' src='deletex.png' width='10' height='10' title='Remove Key' /></a>" + 
							"<span ondblclick='newkey(&quot;" + keynode + "&quot;);' title='dblclick: Advanced Edit'>" + key + 
							"</span></th><td><input class='field' type='text' name='" + keynode.toLowerCase() + "' title='" + keynode +
							"' style='width:100%;'></td></tr>";
					}
					
					ent[k++] = keynode;			
				}
			}
			
			expl.innerHTML = cexpl;
			dat.innerHTML = cdat + "</table>";
			
			// request keys
			if (ent.length > 0) {
				// Assign events to newly added controls
				setevents();
				
				var request = new Object();
				request['Message'] = "Registry Read";
				request['Keys'] = ent;
			  chan.sendJson(request);
			}
		}
		
		// recursive seek & destroy
		else if (op === "regdestroy") {
			var ent = new Object();
			var keys = jobj['Keys'];
			for (n = 0; n < keys.length; n++) {
				var keynode = keys[n];
				if (keynode.endsWith("/")) {
					var request = new Object();
					request['Message'] = "Registry List";
					request['Meta'] = meta;
					request['Node'] = keynode;
				  chan.sendJson(request);
				}
				else {
					ent[keynode] = "";
				}				
			}	
			
			if (Object.keys(ent).length > 0) {
					// remove any keys found
					var request = new Object();
					request['Message'] = "Registry Write";
					request['Keys'] = ent;
				  chan.sendJson(request);
				  
				  // refresh the editor view
				  regrefresh();
			}		
		}
	}

	if (reg_onmessage)
		reg_onmessage(evt);	// chain message processing
}

function regrefresh() {
  var node = document.getElementById("regnode").innerHTML;
  
  var pos = 1;
  regexpand("");
  while ((pos = node.indexOf("/", pos) + 1) > 0) {
  	regexpand(node.substr(0, pos));
  }
}

function newkey(key) {
	var el = document.getElementById('newkey');
	el.style.display = getComputedStyle(el).getPropertyValue('display') == "none" ? "inherit" : "none";
	
	var nkkey = document.getElementById('nkkey');
	var nkdata = document.getElementById('nkdata');
	
	if (key == undefined) {
	  key = document.getElementById("regnode").innerHTML;
		nkkey.value = key;
		nkdata.value = "";
		nkkey.focus();
	}
	else {
		nkkey.value = key;
		nkdata.style.height = "20px";
		nkdata.value = registry_cache[key.toLowerCase()];
		nkdata.style.height = nkdata.scrollHeight + "px";
		nkdata.focus();
	}
}	

function newkeykey(evt) {
	if (evt.keyCode == 13)
		newkeyOK();
}

function newkeyOK() {
	key = document.getElementById('nkkey').value;
	keydata = document.getElementById('nkdata').value;
	newkey();
	
	if (!key.endsWith("/")) {
		var ent = new Object();
		ent[key] = keydata;
		
		var request = new Object();
		request['Message'] = "Registry Write";
		request['Keys'] = ent;
	  chan.sendJson(request);

		regrefresh();
	}
}

function regdelete() {
  var regnode = document.getElementById("regnode");
  var node = regnode.innerHTML;

	// cannot destroy the root or IpConfig
  if (node == "/" || node.toLowerCase() == "ipconfig/")
  	return;
	
	if (confirm("Remove Registry node '" + node + "' and all of its contents? This cannot be undone!")) {
		// perfrom recusive seek & destroy
		var meta = new Object();
		meta['Op'] = "regdestroy";
		
		var request = new Object();
		request['Message'] = "Registry List";
		request['Meta'] = meta;
		request['Node'] = node;
	  chan.sendJson(request);

		// we want to move off of this node
		var parent = "/" + node.substr(0, node.length - 1);
		parent = parent.substr(0, parent.lastIndexOf("/") + 1);
		if (parent == "/")
			regnode.innerHTML = "/";
		else
			regnode.innerHTML = parent.substr(1);
		regrefresh();
	}
}

function rmkey(key) {
	// keys we don't want you to delete
	var keylower = key.toLowerCase();
	if (keylower == "ipconfig/ipaddress" || keylower == "ipconfig/subnetmask" || keylower == "ipconfig/gatewayip")
		return;
		
	if (confirm("Remove '" + key + "'? This cannot be undone!")) {
		var ent = new Object();
		ent[key] = "";
		
		var request = new Object();
		request['Message'] = "Registry Write";
		request['Keys'] = ent;
	  chan.sendJson(request);

		regrefresh();
	}
	return;
}