<!--
 /*
  JNIOR Monitor/Configuration Page
  INTEG Process Group, Inc., 2919 E Hardies Rd, Gibsonia PA
  724.933.9350

  File: index.php

  This is a basic HTML/Javascript implementation supported by the JANOS server-side
  scripting lanquage closely modelled after PHP.

  The user is hereby granted license to use, modify, and redistribute the contents of this
  file for any purpose, commercial or otherwise. No prior authorization by INTEG Process
  Group, Inc. is required.
*/
-->

<!DOCTYPE html>
<html>
	<?php
		// pages version
		$appvers = "Dynamic Configuration Pages (WebUI) v3.0.1";

		$vers = getRegistryString("\$Version");
		$ff_support = substr($vers, 0, 6) >= "v1.6" ? true : false;

		// determine input/output configuration
		$model = getRegistryString("\$Model");
		if ($model === "410")
			$inp_cnt = 8;
		else if ($model === "412" || $model === "412DMX")
			$inp_cnt = 4;
		else
			$inp_cnt = 12;

		$out_cnt = 16 - $inp_cnt;
		$administrator = ($_SERVER['ADMINISTRATOR'] === "TRUE");
		$controller = ($_SERVER['CONTROL'] === "TRUE") || $administrator;
		$console = getRegistryBoolean("Websocket/Console", true);
		$filemgr = getRegistryBoolean("Websocket/Files", true);
		$registry = getRegistryBoolean("Websocket/Registry", true);
		$syslog = getRegistryBoolean("Websocket/Syslog", true);
		$peers = getRegistryBoolean("Websocket/Peers", true);
	?>

	<head>
		<base href="<?php=$_SERVER['REQUEST_LOC']?>">
		<title><?php=getRegistryString("IpConfig/IPAddress")?> <?php=getRegistryString("IpConfig/Hostname")?></title>
		<meta charset="UTF-8">

		<script>
			var jnior_model = "<?php=$model ?>";
			var jnior_outputs = <?php=$out_cnt ?>;
			var jnior_admin = <?php=$administrator?"true":"false" ?>;
			var jnior_control = <?php=$controller?"true":"false" ?>;
		</script>

		<link rel="icon" href="favicon.ico?v=2" />
	  <link rel="stylesheet" type="text/css" href="styles.css" />
	  <link id="pagestyle" rel="stylesheet" type="text/css" href="config.css.php" />
		<script src="tabs.js"></script>
		<script src="md5.js"></script>
		<script src="comm.js"></script>
		<script src="config.js"></script>
		<script src="modules.js"></script>
		<script src="relays.js"></script>
		<script src="analog.js"></script>
		<script src="dimmer.js"></script>
		<script src="panel.js"></script>
		<script src="temperature.js"></script>
		<script src="console.js"></script>
		<script src="folders.js"></script>
		<script src="registry.js"></script>
		<script src="syslog.js"></script>
		<script src="peers.js"></script>
		
	</head>

	<?php
		$serno = getRegistryString("\$SerialNumber");
		$hostname = getRegistryString("IpConfig/Hostname");
		$banner = $model . " (S/N " . $serno . ") JANOS " . $vers;

		function checkbox($key, $dflt, $attr, $desc) {
			$keylower = strtolower($key);
			echo "<td><input type='checkbox' name='$keylower' title='$key' ";
			if (getRegistryBoolean($key, $dflt))
				echo " checked ";
			if (!is_null($attr))
				echo $attr;
			echo ">";
			if (!is_null($desc))
				echo $desc;
			echo "</td>";
		}

		function textbox($key, $size, $dflt, $class) {
			$keylower = strtolower($key);
			$str = getRegistryString($key, $dflt);
			if (!is_string($class))
				$class = "";
			echo "<td><input class='field $class' type=";
			if (strpos($keylower, "password") >= 0)
				echo "'password'";
			else
				echo "'text'";
			echo " name='$keylower' title='$key' value='$str' ";
			echo $size > 0 ? "size='$size'" : "style='width:100%;'";
			echo "></td>";
		}

		function valuebox($key, $size, $dflt) {
			$keylower = strtolower($key);
			$str = getRegistryString($key, $dflt);
			echo "<td><input class='fieldc' type='text' name='$keylower' title='$key' value='$str' ";
			echo $size > 0 ? "size='$size'" : "style='width:100%;'";
			echo "></td>";
		}

		function selectbox($key, $keys, $vals, $dflt) {
			$keylower = strtolower($key);
			$v = intval(getRegistryString($key, $dflt));
			echo "<td><select class='field' name='$keylower' title='$key' dflt='$dflt'>";
			$cnt = count($keys);
			for ($n = 0; $n < $cnt; $n++) {
				if ($vals[$n] == $v)
					echo "<option value='$v' selected='selected'>$keys[$n]</option>";
				else
					echo "<option value='$vals[$n]'>$keys[$n]</option>";
			}
			echo "</select></td>";
		}

		function nformat($num) {
			$n = strpos($num, ".");
			if ($n < 0)
				$n = strlen($num);
			for($n -= 3; $n > 0; $n -= 3)
				$num = substr($num, 0, $n) . "," . substr($num, $n);
			return $num;
		}

		function inputblock($ofs) {
			global $controller;

			for ($n = $ofs; $n < $ofs + 4; $n++) {
				echo "<div class='io'><span class='spanio";
				if (!getRegistryBoolean("IO/Inputs/din$n/Enabled", TRUE))
					echo " hide";
				echo "' name='io/inputs/din$n/enabled'><div class='ioname'>$n - <span name='io/inputs/din$n/desc'>";
				echo getRegistryString("IO/Inputs/din$n/Desc", "Digital Input $n");
				echo "</span></div><div class='state on hide' id='dinon$n'><span name='io/inputs/din$n/closeddesc'>";
				echo getRegistryString("IO/Inputs/din$n/ClosedDesc", "ON");
				echo "</span></div><div class='state off' id='dinoff$n'><span name='io/inputs/din$n/opendesc'>";
				echo getRegistryString("IO/Inputs/din$n/OpenDesc", "OFF");
				echo "</span></div><div class='control";
				if (!$controller)
					echo " hide";
				echo "'><div class='release";
				if (!getRegistryBoolean("IO/Inputs/din$n/ShowControls", TRUE) || !getRegistryBoolean("IO/Inputs/din$n/Latching", FALSE))
					echo " hide";
				echo "' name='io/inputs/din$n/showcontrols'><button class='ctrlbtn' id='rel$n' onclick='release($n)'>Reset</button></div></div>";
				echo "<div class='meter'><span class='spanmeter";
				if (!getRegistryBoolean("IO/Inputs/din$n/ShowUsageMeter", TRUE))
					echo " hide";
				echo "' name='io/inputs/din$n/showusagemeter'><span name='io/inputs/din$n/\$hourmeter'>";
				echo nformat(getRegistryString("IO/Inputs/din$n/\$HourMeter", "0.00"));
				echo " </span> Hours</span></div><div class='counter'><span class='spancounter";
				if (!getRegistryBoolean("IO/Inputs/din$n/ShowCount", TRUE))
					echo " hide";
				echo "' name='io/inputs/din$n/showcount'><span name='counter$n'>0</span> <span name='io/inputs/din$n/count/units'>";
				echo getRegistryString("IO/Inputs/din$n/Count/Units", "Counts");
				echo "</span></span></div></span></div>";
			}
		}

		function outputblock($ofs) {
			global $controller;

			for ($n = $ofs; $n < $ofs + 4; $n++) {
				echo "<div class='io'><span class='spanio";
				if (!getRegistryBoolean("IO/Outputs/rout$n/Enabled", TRUE))
					echo " hide";
				echo "' name='io/outputs/rout$n/enabled'><div class='ioname'>$n - <span name='io/outputs/rout$n/desc'>";
				echo getRegistryString("IO/Outputs/rout$n/Desc", "Relay Output $n");
				echo "</span></div><div class='state on hide' id='routon$n'><span name='io/outputs/rout$n/closeddesc'>";
				echo getRegistryString("IO/Outputs/rout$n/ClosedDesc", "ON");
				echo "</span></div><div class='state off' id='routoff$n'><span name='io/outputs/rout$n/opendesc'>";
				echo getRegistryString("IO/Outputs/rout$n/OpenDesc", "OFF");
				echo "</span></div><div class='control";
				if (!$controller)
					echo " hide";
				echo "'><div class='toggle";
				$control = getRegistryString("IO/Outputs/rout$n/ShowControls", "0");
				if ($control != 0)
					echo " hide";
				echo "' name='io/outputs/rout$n/showcontrols'><button class='ctrlbtn' onclick='toggle($n)'>Toggle</button></div><div class='pulse";
				if ($control != 1)
					echo " hide";
				echo "' name='io/outputs/rout$n/showcontrols'><button class='ctrlbtn' onclick='pulse($n)'>Pulse</button></div></div>";
				echo "<div class='meter'><span class='spanmeter";
				if (!getRegistryBoolean("IO/Outputs/rout$n/ShowUsageMeter", TRUE))
					echo " hide";
				echo "' name='io/outputs/rout$n/showusagemeter'><span name='io/outputs/rout$n/\$hourmeter'>";
				echo nformat(getRegistryString("IO/Outputs/rout$n/\$HourMeter", "0.00"));
				echo " </span> Hours</span></div></span></div>";
			}
		}
	?>

	<body onload="init();tabinit();">

		<div id="load" class="loading">
			<div class="header">
				<img src="favicon.ico" style="float:left;width:18px;height:18px;padding-right:5px">
			  <p class="banner"><?php=$banner?></p>
			  <p class="hostname"><span name="ipconfig/hostname"><?php=$hostname?></span></p>
			</div>
		</div>

		<div class="preload"><img src='file.png' /></div>
		<div class="preload"><img src='folder.png' /></div>
		<div class="preload"><img src='expanded.png' /></div>
		<div class="preload"><img src='linked.png' /></div>
		<div class="preload"><img src='collapsed.png' /></div>
		<div class="preload"><img src='link_to.png' /></div>

		<div id="main" class="wrapper hide">
			<div id="offline">
				<div id="bgnd"></div>
				<div id="txt">Reconnecting</div>
			</div>

			<div class="header">
				<img src="favicon.ico" style="float:left;width:18px;height:18px;padding-right:5px">
			  <p class="banner"><?php=$banner?><br><a href='' onclick='logout();'>logout '<span id="logout"><?php=$_SERVER['USERNAME']?></span>'</a></p>
			  <p class="hostname"><span name="ipconfig/hostname"><?php=$hostname?></span></p>
			</div>
			
			<ul id="tabs">
				<li><a href="#control" onmouseup='helpInit(0);'>Input/Output</a></li>
				<?php
					if ($administrator) echo "<li><a href='#config' onmouseup='helpInit(1);'>Configuration</a></li> ";
					if ($controller && $console) echo "<li><a href='#console' onmouseup='helpInit(0);'>Console</a></li> ";
					if ($controller && $ff_support && $filemgr) echo "<li><a href='#filefolders' onmousedown='frefresh();return false;' onmouseup='helpInit(0);'><span id='fwarn'></span>Folders</a></li> ";
					if ($administrator && $registry) echo "<li><a href='#regeditor' onmouseup='helpInit(1);'>Registry</a></li> ";
					if ($controller && $ff_support && $syslog) echo "<li><a href='#syslog' onmouseup='helpInit(0);'>Syslog</a></li> ";
					if ($ff_support && $peers) echo "<li><a href='#peers' onmouseup='helpInit(0);'>Peers</a></li> ";
				?>
				<li><a href="#about">About</a></li>
			</ul>
			
			<ul id="tabs-admin" style='display:none'>
				<li><a href="#control" onmouseup='helpInit(0);'>Input/Output</a></li>
				<li><a href='#config' onmouseup='helpInit(1);'>Configuration</a></li>
				<li><a href='#console' onmouseup='helpInit(0);'>Console</a></li>
				<?php
					if ($ff_support && $filemgr) echo "<li><a href='#filefolders' onmousedown='frefresh();return false;' onmouseup='helpInit(0);'><span id='fwarn'></span>Folders</a></li> ";
					if ($registry) echo "<li><a href='#regeditor' onmouseup='helpInit(1);'>Registry</a></li> ";
					if ($ff_support && $syslog) echo "<li><a href='#syslog' onmouseup='helpInit(0);'>Syslog</a></li> ";
					if ($ff_support && $peers) echo "<li><a href='#peers' onmouseup='helpInit(0);'>Peers</a></li> ";
				?>
				<li><a href="#about">About</a></li>
			</ul>
			
			<ul id="tabs-control" style='display:none'>
				<li><a href="#control" onmouseup='helpInit(0);'>Input/Output</a></li>
				<li><a href='#console' onmouseup='helpInit(0);'>Console</a></li>
				<?php
					if ($ff_support && $filemgr) echo "<li><a href='#filefolders' onmousedown='frefresh();return false;' onmouseup='helpInit(0);'><span id='fwarn'></span>Folders</a></li> ";
					if ($ff_support && $syslog) echo "<li><a href='#syslog' onmouseup='helpInit(0);'>Syslog</a></li> ";
					if ($ff_support && $peers) echo "<li><a href='#peers' onmouseup='helpInit(0);'>Peers</a></li> ";
				?>
				<li><a href="#about">About</a></li>
			</ul>
			
			<ul id="tabs-other" style='display:none'>
				<li><a href="#control" onmouseup='helpInit(0);'>Input/Output</a></li>
				<?php
					if ($ff_support && $peers) echo "<li><a href='#peers' onmouseup='helpInit(0);'>Peers</a></li> ";
				?>
				<li><a href="#about">About</a></li>
			</ul>

			<div class="tabbed" id="control">
				<div class="iotree">
					<ul id="iosets">
						<li><a href="#internal">Internal</a></li>
						<li><a href="#external">External</a></li>
					</ul>
				<a href='http://www.integpg.com'><img src='integlogo.png' width=100px></a>
				</div>
				<div class="iosettings" id="internal">
					<table class="iotable">
						<tr>
							<td><?php inputblock(1); ?></td>
							<td><?php if ($inp_cnt > 8) inputblock(9); else outputblock(1); ?></td>
						</tr>
						<tr>
							<td><?php if ($inp_cnt > 4) inputblock(5); else outputblock(9); ?></td>
							<td><?php if ($inp_cnt > 8) outputblock(1); else outputblock(5); ?></td>
						</tr>
					</table>
				</div>

				<div class="iosettings hide" id="external">
					<div class="sets" id="modules">
						<table class="iotable" id="exttable">
						</table>
					</div>
				</div>

			</div>

			<div class="tabbed hide" id="config">
				<div class="cfgtree">
					<ul id="sets">
						<li><a href="#display">Display</a></li>
						<li><a href="#labels">Labels</a></li>
						<li><a href="#inputs">Inputs</a></li>
						<li><a href="#counters">Counters</a></li>
						<li><a href="#outputs">Outputs</a></li>
						<li><a href="#metering">Metering</a></li>
						<li><a href="#serial">Serial I/O</a></li>
						<li><a href="#apps">Applications</a></li>
						<li><a href="#eacct">Mail-Account</a></li>
						<li><a href="#email">Mail-Profiles</a></li>
						<li><a href="#events">Events</a></li>
						<li><a href="#network">Network</a></li>
						<li><a href="#security">Security</a></li>
						<li><a href="#cmdserver">Telnet</a></li>
						<li><a href="#webserver">WebServer</a></li>
						<li><a href="#ftpserver">FTP</a></li>
						<li><a href="#jrserver">Protocol</a></li>
						<li><a href="#extmods">Modules</a></li>
					</ul>
					<a href='http://www.integpg.com'><img src='integlogo.png' width=100px></a>
				</div>
				<div class="settings">

					<div class="sets" id="display">
						<table class="conf">
							<tr>
								<th rowspan=3 width=50px>Channel</th>
								<th colspan=5>Inputs</th>
								<th colspan=3>Outputs</th>
							</tr>
							<tr>
								<th rowspan=2>Enabled</th>
								<th colspan=4>Show</th>
								<th rowspan=2>Enabled</th>
								<th colspan=2>Show</th>
							</tr>
							<tr>
								<th>Counter</th>
								<th>Usage</th>
								<th>Alarms</th>
								<th>Controls</th>
								<th>Usage</th>
								<th>Control</th>
							</tr>
							<?php
								$ctlkeys = array("Toggle", "Pulse", "None");
								$ctlvals = array(0, 1, 2);

								$rows = $inp_cnt > $out_cnt ? $inp_cnt : $out_cnt;
								for ($n = 1; $n <= $rows; $n++) {
									echo "<tr><td class='static'>$n</td>";
									if ($n <= $inp_cnt) {
										$node = "IO/Inputs/din$n";
										checkbox("$node/Enabled", TRUE);
										checkbox("$node/ShowCount", TRUE);
										checkbox("$node/ShowUsageMeter", TRUE);
										checkbox("$node/ShowAlarms", TRUE);
										checkbox("$node/ShowControls", TRUE);
									}
									else {
										echo "<td></td><td></td><td></td><td></td><td></td>";
									}
									if ($n <= $out_cnt) {
										$node = "IO/Outputs/rout$n";
										checkbox("$node/Enabled", TRUE);
										checkbox("$node/ShowUsageMeter", TRUE);
										selectbox("$node/ShowControls", $ctlkeys, $ctlvals, "0");
									}
									else {
										echo "<td></td><td></td><td></td>";
									}
									echo "</tr>";
								}
							?>
						</table><br>
						<table class="regconf" style='width:30%'>
							<tr><th>ON Color</th><?php textbox("IO/OnColor", 16, "#66ff66", "mono"); ?></tr>
							<tr><th>OFF Color</th><?php textbox("IO/OffColor", 16, "#ff6666", "mono"); ?></tr>
							<tr><th>Colors Reversed</th><?php checkbox("IO/InvertColors", FALSE); ?></tr>
						</table>
					</div>

					<div class="sets hide" id="labels">
						<table class="conf">
							<tr>
								<th rowspan=2 width=50px>Channel</th>
								<th colspan=4>Inputs</th>
							</tr>
							<tr>
								<th>Description</th>
								<th>On Text</th>
								<th>Off Text</th>
								<th>Counter</th>
							</tr>
							<?php
								for ($n = 1; $n <= $inp_cnt; $n++) {
									$node = "IO/Inputs/din$n";

									echo "<tr><td class='static'>$n</td>";
									textbox("$node/Desc", 32, "Digital Input $n");
									textbox("$node/ClosedDesc", 8, "ON");
									textbox("$node/OpenDesc", 8, "OFF");
									textbox("$node/Count/Units", 8, "Counts");
									echo "</tr>";
								}
							?>
						</table><br>
						<table class="conf">
							<tr>
								<th rowspan=2 width=50px>Channel</th>
								<th colspan=3>Outputs</th>
							</tr>
							<tr>
								<th>Description</th>
								<th>On Text</th>
								<th>Off Text</th>
							</tr>
							<?php
								for ($n = 1; $n <= $out_cnt; $n++) {
									$node = "IO/Outputs/rout$n";

									echo "<tr><td class='static'>$n</td>";
									textbox("$node/Desc", 32, "Relay Output $n");
									textbox("$node/ClosedDesc", 8, "ON");
									textbox("$node/OpenDesc", 8, "OFF");
									echo "</tr>";
								}
							?>
						</table>
					</div>

					<div class="sets hide" id="inputs">
						Input Channel Configuration<br><br>
						<table class="conf">
							<tr>
								<th rowspan=2 width=50px>Channel</th>
								<th rowspan=2>Invert</th>
								<th rowspan=2>Debounce (ms)</th>
								<th colspan=3>Latch</th>
								<th rowspan=2>Conditioning</th>
								<th colspan=2>Alarm</th>
							</tr>
							<tr>
								<th>Enabled</th>
								<th>State</th>
								<th>LatchTime (secs)</th>
								<th>Enable</th>
								<th>Invert</th>
							</tr>
							<?php
								$stkeys = array("OFF", "ON");
								$stvals = array(0, 1);

								$cndkeys = array("Normal", "Inverted", "OFF", "ON");
								$cndvals = array(0, 1, 2, 3);

								for ($n = 1; $n <= $inp_cnt; $n++) {
									$node = "IO/Inputs/din".$n;

									echo "<tr><td class='static'>$n</td>";
									checkbox($node."/Inversion", FALSE);
									valuebox($node."/Debounce", 4, "200");
									checkbox($node."/Latching", FALSE);
									selectbox($node."/LatchState", $stkeys, $stvals, "1");
									valuebox($node."/LatchTime", 4, "0");
									selectbox($node."/Conditioning", $cndkeys, $cndvals, "0");
									checkbox("$node/Alarming", FALSE);
									checkbox("$node/Alarm/Inversion", FALSE);
									echo "</tr>";
								}
							?>
						</table>
						<p style="float:right"><small> <a href="inputs.png" target="blank">View Block Diagram</a></small></p>
					</div>

					<div class="sets hide" id="counters">
						Input Channel Counters<br><br>
						<table class="conf">
							<tr>
								<th rowspan=2 width="50px">Channel</th>
								<th rowspan=2>Counts</th>
								<th rowspan=2>Scale</th>
								<th rowspan=2>Count State</th>
								<th colspan=3>Alarm 1</th>
								<th colspan=3>Alarm 2</th>
							</tr>
							<tr>
								<th>Enable</th>
								<th>Limit</th>
								<th>HoldOff (msec)</th>
								<th>Enable</th>
								<th>Limit</th>
								<th>HoldOff (msec)</th>
							</tr>
							<?php
								$stkeys = array("OFF", "ON");
								$stvals = array(0, 1);

								for ($n = 1; $n <= $inp_cnt; $n++) {
									$node = "IO/Inputs/din".$n;

									echo "<tr class='resettd'><td class='resethdr'><a href='' onclick='clrcnt(&quot;$n&quot;);return(false);'>" .
										"<img class='cntclr' src='deletex.png' width='10' height='10' title='Reset Counter' /></a><div class='cntr'>$n</div></td>";
									echo "<td><span name='counter$n'>0</span></td>";
									valuebox("$node/Count/Multiplier", 6 "1.0");
									selectbox($node."/CountState", $stkeys, $stvals, "1");
									checkbox("$node/Count/Alarm1", FALSE);
									valuebox("$node/Count/Limit1", 6, "0");
									valuebox("$node/Alarm1/HoldOff", 6, "0");
									checkbox("$node/Count/Alarm2", FALSE);
									valuebox("$node/Count/Limit2", 6, "0");
									valuebox("$node/Alarm2/HoldOff", 6, "0");
									echo "</tr>";
								}
							?>
						</table>
						<p style="float:right"><small> <a href="inputs.png" target="blank">View Block Diagram</a></small></p>
					</div>

					<div class="sets hide" id="outputs">
						Output Channel Configuration<br><br>
						<table class="conf">
							<tr>
								<th width=50px>Channel</th>
								<th>Initial Action (ms)</th>
								<th>Metering State</th>
								<th>Default Pulse (ms)</th>
							</tr>
							<?php
								for ($n = 1; $n <= $out_cnt; $n++) {
									$node = "IO/Outputs/rout$n";

									echo "<tr><td class='static'>$n</td>";
									valuebox("$node/InitialState", 8, "");
									selectbox("$node/UsageState", $stkeys, $stvals, "1");
									valuebox("$node/PulseDuration", 8, "1000");
									echo "</tr>";
								}
							?>
						</table>
					</div>

					<div class="sets hide" id="metering">
						Channel Metering<br><br>
						<table class="conf">
							<tr>
								<th rowspan=2 width="50px">Channel</th>
								<th rowspan=2>Hours</th>
								<th rowspan=2>Metering State</th>
								<th colspan=3>Alarm</th>
							</tr>
							<tr>
								<th>Enable</th>
								<th>Limit</th>
								<th>HoldOff (msec)</th>
							</tr>
							<?php
								$stkeys = array("OFF", "ON");
								$stvals = array(0, 1);

								for ($n = 1; $n <= $inp_cnt; $n++) {
									$node = "IO/Inputs/din$n";

									echo "<tr class='resettd'><td class='resethdr'><a href='' onclick='clruse(&quot;$n&quot;);return(false);'>" .
										"<img class='cntclr' src='deletex.png' width='10' height='10' title='Reset Meter' /></a><div class='cntr'>Input $n</div></td>";
									echo "<td><span name='io/inputs/din$n/\$hourmeter'>";
									echo nformat(getRegistryString("$node/\$HourMeter", "0.00"));
									echo "</span></td>";
									selectbox($node."/UsageState", $stkeys, $stvals, "1");
									checkbox("$node/Usage/Alarm", FALSE);
									valuebox("$node/Usage/Limit", 8, "0");
									valuebox("$node/Usage/HoldOff", 6, "0");
									echo "</tr>";
								}
								for ($n = 1; $n <= $out_cnt; $n++) {
									$node = "IO/Outputs/rout$n";
									$k = $n + $inp_cnt;

									echo "<tr class='resettd'><td class='resethdr'><a href='' onclick='clruse(&quot;$k&quot;);return(false);'>" .
										"<img class='cntclr' src='deletex.png' width='10' height='10' title='Reset Meter' /></a><div class='cntr'>Relay $n</div></td>";
									echo "<td><span name='io/outputs/rout$n/\$hourmeter'>";
									echo nformat(getRegistryString("$node/\$HourMeter", "0.00"));
									echo "</span></td>";
									selectbox($node."/UsageState", $stkeys, $stvals, "1");
									checkbox("$node/Usage/Alarm", FALSE);
									valuebox("$node/Usage/Limit", 8, "0");
									valuebox("$node/Usage/HoldOff", 6, "0");
									echo "</tr>";
								}
							?>
						</table>
						<p style="float:right"><small> <a href="inputs.png" target="blank">View Block Diagram</a></small></p>
					</div>

					<div class="sets hide" id="serial">
						AUX Serial Port<br><br>
						<?php
							$node = "AUXSerial/";
							$bauds = array("110", "150", "300", "600", "1200", "2400", "4800", "9600", "14400", "19200", "28800", 
								"31250", "38400", "57600", "115200", "128000", "250000");
							$bdvals = array(110, 150, 300, 600, 1200, 2400, 4800, 9600, 14400, 19200, 28800, 31250, 38400, 57600, 115200, 128000, 250000);							
						?>
						<table class="ipconf">
							<tr>
								<th>Baud Rate</th>
								<?php selectbox($node."Baudrate", $bauds, $bdvals, "115200"); ?>
							</tr>
							<tr>
								<th>Data Bits</th>
								<?php selectbox($node."Databits", array("7", "8"), array(7, 8), "8"); ?> 
							</tr>
							<tr>
								<th>Stop Bits</th>
								<?php selectbox($node."Stopbits", array("1", "2"), array(1, 2), "1"); ?> 
							</tr>
							<tr>
								<th>Parity</th>
								<?php selectbox($node."Parity", array("NONE", "EVEN", "ODD"), array(0, 2, 3), "0"); ?> 
							</tr>
							<tr>
								<th>Flow Control</th>
								<?php selectbox($node."Flow", array("NO_CONTROL", "RTSCTS_IN", "RTSCTS_OUT", "RTSCTS", "XONXOFF_IN", "XONXOFF_OUT", "XONXOFF"), array(0, 1, 2, 3, 4, 8, 12), "0"); ?> 
							</tr>
							<tr>
								<th>RS-485 Mode</th>
								<?php checkbox($node."RS485", FALSE, "style='top:1px'", " Enabled"); ?> 
							</tr>
						</table><br><br>
						
						<?php
							$node = "COMSerial/";
						?>
						COM Serial Port (RS-232)<br><br>
						<table class="ipconf">
							<tr>
								<th>Baud Rate</th>
								<?php selectbox($node."Baudrate", $bauds, $bdvals, "115200"); ?>
							</tr>
							<tr>
								<th>Data Bits</th>
								<?php selectbox($node."Databits", array("7", "8"), array(7, 8), "8"); ?> 
							</tr>
							<tr>
								<th>Stop Bits</th>
								<?php selectbox($node."Stopbits", array("1", "2"), array(1, 2), "1"); ?> 
							</tr>
							<tr>
								<th>Parity</th>
								<?php selectbox($node."Parity", array("NONE", "EVEN", "ODD"), array(0, 2, 3), "0"); ?> 
							</tr>
							<tr>
								<th>Flow Control</th>
								<?php selectbox($node."Flow", array("NO_CONTROL", "XONXOFF_IN", "XONXOFF_OUT", "XONXOFF"), array(0, 4, 8, 12), "0"); ?> 
							</tr>
							<tr>
								<th>Boot Dialog</th>
								<?php checkbox($node."BootDialog", TRUE, "style='top:1px'", " Enabled"); ?> 
							</tr>
						</table>
					</div>

					<div class="sets hide" id="apps">
						Enable/Configure Registered Applications<br><br>
						<?php
							$apps = getRegistryList("Applications", true);

							// we don't have sort fns
							for ($n = 0; $n < count($apps)-1; $n++) {
								if ($apps[$n] > $apps[$n+1]) {
									$k = $apps[$n];
									$apps[$n] = $apps[$n+1];
									$apps[$n+1] = $k;
									if ($n > 0) $n -= 2;
								}
							}

							$cnt = 0;
							for ($n = 0; $n < count($apps); $n++) {
								$name = getRegistryString("$apps[$n]/Name");
								$run = getRegistryString("$apps[$n]/Run");
								$config = getRegistryString("$apps[$n]/Config");
								$desc = getRegistryString("$apps[$n]/Desc");
								if (is_null($desc))
									$desc = "No description available.";

								if (!is_null($name) && !is_null($run)) {
									$runky = "Run/" . substr($apps[$n], 13);
									$cnt++;
									echo "<table class='apps'><tr><td title='$name\n\n$desc'>";
									echo "<div style='float:left;'><input type='checkbox' name='$run' title='$runky'";
									if (!is_null(getRegistryString($runky)))
										echo " checked";
									echo "><b> $name</b></div>";
									if (!is_null($config))
										echo "<div class='conf'><a href='$config' target='_blank'><img src='link_to.png' width='16' height='16' alt='' /></a></div>";
									echo "</td></tr></table>";
								}
							}
							if ($cnt == 0)
								echo "No Registered Applications";
						?>
					</div>

					<div class="sets hide" id="email">
						Email Default/Custom Profile Setup<br><br>
						<div class="enode">Select
							<select id="emailsel" name="email">
								<option>&lt;default&gt;</option>
								<?php
									$list = getRegistryList("/Email", true);
									for ($n = 0; $n < count($list); $n++) {
										$pos = stripos($list[$n], "email/");
										$key = substr($list[$n], $pos + 6);
										echo "<option value='$key'>$key</option>";
									}
								?>
							</select>
		        	<button onclick='profile()'>Add</button>
						</div>
						<div id="ehead" class="ehead">eMail Profile: &lt;default&gt;</div>
						<div class="econf" id="econf">
							<table class="econf">
								<tr>
									<th>ToAddress</th>
									<?php textbox("Email/ToAddress", 50, ""); ?>
								</tr>
								<tr>
									<th>CcAddress</th>
									<?php textbox("Email/CcAddress", 50, ""); ?>
								</tr>
								<tr>
									<th>BccAddress</th>
									<?php textbox("Email/BccAddress", 50, ""); ?>
								</tr>
								<tr>
									<th>Subject</th>
									<?php textbox("Email/Subject", 50, ""); ?>
								</tr>
								<tr>
									<th>Message</th>
									<?php textbox("Email/Message", 50, ""); ?>
								</tr>
								<tr>
									<th>Message File</th>
									<?php textbox("Email/MessageFile", 50, ""); ?>
								</tr>
								<tr>
									<th>Attachments</th>
									<?php textbox("Email/Attachments", 50, ""); ?>
								</tr>
								<tr>
									<th>Signature</th>
									<?php textbox("Email/Signature", 50, ""); ?>
								</tr>
							</table>
						</div>
					</div>

					<div class="sets hide" id="eacct">
						Email Server and Account Setup<br><br>
						<div class="eacc" id="eacc">
							<table class="ipconf">
								<tr>
									<th>Mail Server</th>
									<?php textbox("IpConfig/MailHost", 20, ""); ?>
								</tr>
								<tr>
									<th>From Address</th>
									<?php textbox("IpConfig/EmailAddress", 30, ""); ?>
								</tr>
								<tr>
									<th>SMTP Username</th>
									<?php textbox("IpConfig/Username", 30, ""); ?>
								</tr>
								<tr>
									<th>Port</th>
									<?php textbox("Email/Port", 12, "25"); ?>
								</tr>
								<tr>
									<th>SMTPS</th>
									<?php	checkbox("Email/SMTPS", FALSE); ?>
								</tr>
								<tr>
									<th>Retry Count</th>
									<?php textbox("Email/RetryCount", 12, "12"); ?>
								</tr>
								<tr>
									<th>Retry Delay (mins)</th>
									<?php textbox("Email/RetryDelay", 12, "10"); ?>
								</tr>
							</table>
						</div>
					</div>

					<div class="sets hide" id="events">
						<div>
							<?php
								$key = "Events/Services";
								echo "<input type='checkbox' name='$key' title='$key'";
								if (getRegistryBoolean("$key", TRUE))
									echo " checked";
								echo "> Event Services Enabled<br><br>";
							?>
						</div>
						<div style="float: left; width: 49%;">
							<table class="ipconf" style="width: 100%;">
								<tr>
									<th colspan=3>
										<?php
											$key = "Events/OnBoot";
											echo "<input type='checkbox' name='$key' title='$key'";
											if (getRegistryBoolean("$key", TRUE))
												echo " checked";
											echo "> OnBoot Events Enabled";
										?>
									</th>
								</tr>
								<tr>
									<th rowspan=3>System<br>Boot</th>
									<th>Run Apps</th>
									<?php checkbox("Events/OnBoot/RunEnable", TRUE); ?>
								</tr>
								<tr>
									<th>Email Enable</th>
									<?php checkbox("Events/OnBoot/Email", FALSE); ?>
								</tr>
								<tr>
									<th>Email Profile</th>
									<?php textbox("Events/OnBoot/EmailBlock", 12, "<default>"); ?>
								</tr>
								<tr class="blank_row">
									<td colspan=3 style="border: 0;"></td>
								</tr>
								<tr>
									<th colspan=3>
										<?php
											$key = "Events/OnAlarm";
											echo "<input type='checkbox' name='$key' title='$key'";
											if (getRegistryBoolean("$key", TRUE))
												echo " checked";
											echo "> OnAlarm Events Enabled";
										?>
									</th>
								</tr>
								<tr>
									<th rowspan=2>Input<br>Alarm</th>
									<th>Email Enable</th>
									<?php checkbox("Events/OnAlarm/Email", FALSE); ?>
								</tr>
								<tr>
									<th>Email Profile</th>
									<?php textbox("Events/OnAlarm/EmailBlock", 12, "<default>"); ?>
								</tr>
								<tr class="blank_row">
									<td colspan=3 style="border: 0;"></td>
								</tr>
								<tr>
									<th colspan=3>
										<?php
											$key = "Events/OnAlarm1";
											echo "<input type='checkbox' name='$key' title='$key'";
											if (getRegistryBoolean("$key", TRUE))
												echo " checked";
											echo "> OnAlarm1 Events Enabled";
										?>
									</th>
								</tr>
								<tr>
									<th rowspan=2>Counter<br>Alarm1</th>
									<th>Email Enable</th>
									<?php checkbox("Events/OnAlarm1/Email", FALSE); ?>
								</tr>
								<tr>
									<th>Email Profile</th>
									<?php textbox("Events/OnAlarm1/EmailBlock", 12, "<default>"); ?>
								</tr>
								<tr class="blank_row">
									<td colspan=3 style="border: 0;"></td>
								</tr>
								<tr>
									<th colspan=3>
										<?php
											$key = "Events/OnAlarm2";
											echo "<input type='checkbox' name='$key' title='$key'";
											if (getRegistryBoolean("$key", TRUE))
												echo " checked";
											echo "> OnAlarm2 Events Enabled";
										?>
									</th>
								</tr>
								<tr>
									<th rowspan=2>Counter<br>Alarm2</th>
									<th>Email Enable</th>
									<?php checkbox("Events/OnAlarm2/Email", FALSE); ?>
								</tr>
								<tr>
									<th>Email Profile</th>
									<?php textbox("Events/OnAlarm2/EmailBlock", 12, "<default>"); ?>
								</tr>
							</table>
						</div>
						<div style="float: right; width: 49%;">
							<table class="ipconf" style="width: 100%;">
								<tr>
									<th colspan=3>
										<?php
											$key = "Events/OnUsage";
											echo "<input type='checkbox' name='$key' title='$key'";
											if (getRegistryBoolean("$key", TRUE))
												echo " checked";
											echo "> OnUsage Events Enabled";
										?>
									</th>
								</tr>
								<tr>
									<th rowspan=2>Usage<br>Meter</th>
									<th>Email Enable</th>
									<?php checkbox("Events/OnUsage/Email", FALSE); ?>
								</tr>
								<tr>
									<th>Email Profile</th>
									<?php textbox("Events/OnUsage/EmailBlock", 12, "<default>"); ?>
								</tr>
								<tr class="blank_row">
									<td colspan=3 style="border: 0;"></td>
								</tr>
								<tr>
									<th colspan=3>
										<?php
											$key = "Events/OnConfig";
											echo "<input type='checkbox' name='$key' title='$key'";
											if (getRegistryBoolean("$key", TRUE))
												echo " checked";
											echo "> OnConfig Events Enabled";
										?>
									</th>
								</tr>
								<tr>
									<th rowspan=2>Config<br>Change</th>
									<th>Email Enable</th>
									<?php checkbox("Events/OnConfig/Email", FALSE); ?>
								</tr>
								<tr>
									<th>Email Profile</th>
									<?php textbox("Events/OnConfig/EmailBlock", 12, "<default>"); ?>
								</tr>
							</table>
						</div>
					</div>

					<div class="sets hide" id="network">
						IPv4 Configuration<br><br>
						<div style="float: left; width: 49%;">
							<table class="ipconf">
								<tr>
									<th>DHCP Enabled</th>
									<?php checkbox("IpConfig/DHCP", FALSE); ?>
								</tr>
								<tr>
									<th>IP Address</th>
									<?php textbox("IpConfig/IpAddress", 12, "0.0.0.0"); ?>
								</tr>
								<tr>
									<th>Subnet Mask</th>
									<?php textbox("IpConfig/SubnetMask", 12, "0.0.0.0"); ?>
								</tr>
								<tr>
									<th>Gateway IP</th>
									<?php textbox("IpConfig/GatewayIP", 12, "0.0.0.0"); ?>
								</tr>
								<tr>
									<th>Primary DNS</th>
									<?php textbox("IpConfig/PrimaryDNS", 12, "0.0.0.0"); ?>
								</tr>
								<tr>
									<th>Secondary DNS</th>
									<?php textbox("IpConfig/SecondaryDNS", 12, "0.0.0.0"); ?>
								</tr>
							</table>
						</div>
						<div style="float: right; width: 49%;">
							<table class="ipconf">
								<tr>
									<th colspan=2>DNS Timeout (ms)</th>
									<?php textbox("IpConfig/DNSTimeout", 4, "5000"); ?>
								</tr>
								<tr>
									<th colspan=2>MTU</th>
									<?php textbox("IpConfig/MTU", 4, "1500"); ?>
								</tr>
								<tr>
									<th colspan=2>TTL</th>
									<?php textbox("IpConfig/TTL", 4, "128"); ?>
								</tr>
								<tr>
									<th rowspan=3>Keepalive</th>
									<th>Time (s)</th>
									<?php textbox("IpConfig/Keepalive/Time", 4, "300"); ?>
								</tr>
								<tr>
									<th>Interval (s)</th>
									<?php textbox("IpConfig/Keepalive/Interval", 4, "30"); ?>
								</tr>
								<tr>
									<th>Retry</th>
									<?php textbox("IpConfig/Keepalive/Retry", 4, "8"); ?>
								</tr>
								<tr>
									<th colspan=2>Socket Connect Timeout</th>
									<?php textbox("IpConfig/Socket/ConnectTimeout", 4, "5000"); ?>
								</tr>
							</table>
						</div>
						<div style="clear: both; width: 49%;">
							<br><table class="ipconf">
								<tr>
									<th>Hostname</th>
									<?php textbox("IpConfig/Hostname", 20, ""); ?>
								</tr>
								<tr>
									<th>Local Domain</th>
									<?php textbox("IpConfig/Domain", 20, "jnior.local"); ?>
								</tr>
								<tr>
									<th>NTP Server</th>
									<?php textbox("IpConfig/NTPServer", 20, "pool.ntp.org"); ?>
								</tr>
								<tr>
									<th>Syslog Server</th>
									<?php textbox("IpConfig/SyslogServer", 20, ""); ?>
								</tr>
								<tr>
									<th>File Sharing</th>
									<?php checkbox("Shares/Server", FALSE); ?>
								</tr>
							</table>
						</div>
					</div>

					<div class="sets hide" id="security">
						Security Parameters<br><br>
						<table class="regconf">
							<tr>
								<th>SSL Enabled</th>
								<?php	checkbox("SSL/Enabled", TRUE); ?>
							</tr>
							<tr>
								<th>SSL Required</th>
								<?php	checkbox("SSL/Required", FALSE); ?>
							</tr>
							<tr>
								<th>Allowed IP Addresses</th>
								<?php textbox("IpConfig/Allow", -1, ""); ?>
							</tr>
						</table>
					</div>

					<div class="sets hide" id="webserver">
						Web Server Configuration<br><br>
						<table class="regconf">
							<tr>
								<th>Server Enabled</th>
								<?php checkbox("WebServer/Server", TRUE); ?>
							</tr>
							<tr>
								<th>HTTP Port</th>
								<?php textbox("WebServer/Port", 6, "80"); ?>
							</tr>
							<tr>
								<th>HTTPS SSL Port</th>
								<?php	textbox("WebServer/SSLPort", 6, "443"); ?>
							</tr>
						</table><br><table class="regconf">
							<tr>
								<th>Login Enabled</th>
								<?php checkbox("WebServer/Login", TRUE); ?>
							</tr>
							<tr>
								<th>Anonymous User Name/ID</th>
								<?php textbox("WebServer/Anonymous", 10, ""); ?>
							</tr>
						</table><br><table class="regconf">
							<tr>
								<th>Root Folder</th>
								<?php textbox("WebServer/Root", 20, "/flash/www/"); ?>
							</tr>
							<tr>
								<th>Default Pages</th>
								<?php textbox("WebServer/Index", -1, "index.php;index.html"); ?>
							</tr>
							<tr>
								<th>Additional Search Paths</th>
								<?php textbox("WebServer/Path", -1, "/flash/www/config"); ?>
							</tr>
						</table>
					</div>

					<div class="sets hide" id="extmods">
						Sensor Port - External Modules<br><br>
						<table class="regconf" id="modulelist"></table>
						<small>
							 <p style="float:left"><i>Click Assignment column to change relay group</i></p>
							 <p style="float:right"><a href="." onclick="rescan(event);">rescan</a></p>
						</small>
						<br><div id='modconfig'></div>
					</div>

					<div class="sets hide" id="jrserver">
						JANOS Management Protocol (JMP) Server  Configuration<br><br>
						<table class="ipconf">
							<tr>
								<th>Server Enabled</th>
								<?php checkbox("JMPServer/Server", TRUE); ?>
							</tr>
							<tr>
								<th>Port</th>
								<?php textbox("JMPServer/Port", 6, "9220"); ?>
							</tr>
							<tr>
								<th>Login Required</th>
								<?php checkbox("JMPServer/Login", TRUE); ?>
							</tr>
							<tr>
								<th>Anonymous User Name/ID</th>
								<?php textbox("JMPServer/Anonymous", 4, ""); ?>
							</tr>
						</table><br><br>
						JNIOR Protocol Server Configuration<br><br>
						<table class="ipconf">
							<tr>
								<th>Server Enabled</th>
								<?php checkbox("JniorServer/Server", TRUE); ?>
							</tr>
							<tr>
								<th>Port</th>
								<?php textbox("JniorServer/Port", 6, "9200"); ?>
							</tr>
							<tr>
								<th>Login Required</th>
								<?php checkbox("JniorServer/Login", TRUE); ?>
							</tr>
							<tr>
								<th>Anonymous User Name/ID</th>
								<?php textbox("JniorServer/Anonymous", 4, ""); ?>
							</tr>
						</table>
					</div>

					<div class="sets hide" id="ftpserver">
						File Transfer Protocol (FTP) Server Configuration<br><br>
						<table class="ipconf">
							<tr>
								<th>Server Enabled</th>
								<?php checkbox("FTP/Server", TRUE); ?>
							</tr>
							<tr>
								<th>Port</th>
								<?php textbox("FTP/Port", 6, "21"); ?>
							</tr>
							<tr>
								<th>Anonymous User Name/ID</th>
								<?php textbox("FTP/Anonymous", 4, ""); ?>
							</tr>
							<tr>
								<th>Unix Listing Style</th>
								<?php checkbox("FTP/UnixStyle", FALSE); ?>
							</tr>
						</table>
					</div>

					<div class="sets hide" id="cmdserver">
						Telnet Command Console Server Configuration<br><br>
						<table class="ipconf">
							<tr>
								<th>Server Enabled</th>
								<?php checkbox("Telnet/Server", TRUE); ?>
							</tr>
							<tr>
								<th>Port</th>
								<?php textbox("Telnet/Port", 6, "23"); ?>
							</tr>
						</table>
					</div>
				</div>
			</div>

			<div class="tabbed hide" id="console">
		    <div id="menu">
		        <p class="logout">
		        	<button class="button" id="clear" onclick="onClear()">Clear</button>
		        	<button class="button" id="open" autofocus onclick="onOpen()">Start Session</button>
		        	<button class="button hide" id="close" onclick="onClose()">End Session</button>
		        </p>
		        <p style="clear:both"></p>
		    </div>

				<div class="scrn" id="scrn">
			    <textarea id="screen" wrap="off" class="screen inactive" spellcheck="false"  
			    	onkeydown="onKeydown(event)" onkeypress="onKeypress(event)" onpaste="onPaste(event)" 
			    	onclick="onPosition(this)" oncut="onCut(this)" ondrop="scnpaste(event)"></textarea>
				</div>
				<p class="status" id="status">No Active Session</p>
			</div>

			<div class="tabbed hide" id="filefolders">
				<div class='fmenu'><a href='' onclick='frefresh();return(false);'>Refresh</a></div>
				<div class='fmenu'><a href='' onclick='fnewfolder();return(false);'>New Folder</a></div>
				<div class='fmenu'><a href='' onclick='fdownld();return(false);'>Download</a></div>
				<div class='fmenu'><a href='' onclick='fdelete();return(false);'>Delete</a></div>
				<div class='fmenu hide'>Select files...</div>
				<div class='fmenur' id='filestats'></div>
				<div class='fmenur hide'><a href='' onclick='fdone(event);return(false);'>Done</a></div>
				<div class='fmenur hide'><a href='' onclick='fcancel();return(false);'>Cancel</a></div>
				<div id="ffolder">/</div>
				<div id="fexplore">
					<span id="Root/" style="padding-left:0px;">
						<a href="" onclick='fileexpand("");return(false);'>
							<img src='collapsed.png' width='10' height='10' />Root
						</a>
					</span><br>
				</div>
				<div id="filedata" class="twirl"></div>
			</div>

			<div class="tabbed hide" id="syslog">
				<div id="logdata" class='twirl'>
					<table id="logtable">
					</table>
				</div>
			</div>

			<div class="tabbed hide" id="peers">
				<div class='peermenu'><a href='' onclick='peerrefresh();return(false);'>Refresh</a></div>
				<div class='peermenur' id='peerstats'></div>
				<div id="peerdata" class='twirl'>
					<table id="peertable">
					</table>
				</div>
			</div>

			<div class="tabbed hide" id="about">
				<div id="abouttext">
					<p>
						<a href='http://www.integpg.com'><img src='integlogo.png' width=100px></a>
						<b>INTEG Proces Group, Inc.</b><br>
						2919 East Hardies Road, 1st Floor<br>
						Gibsonia, PA 15044<br>
						1-724-933-9350 	<a href="http://www.integpg.com" target="blank">www.integpg.com</a>
					</p>
					<p>
						The Dynamic Configuration Pages (WebUI) are designed to support JNIOR Series 4 implementations running under JANOS v1.6 and later.
						These are dynamic HTML5 pages utilizing the standard client-side JavaScript supported by your browser. This site is served by
						the JANOS WebServer and generated using the JANOS version of PHP scripting. All real-time interaction is supported through
						the JANOS built-in Websocket connection. The JNIOR may be fully maintained through this one site depending upon configuration
						and user permissions. Secure access using TLSv1.2 is fully supported.
					</p>
					<h3>On-line Community</h3>
					<p>Visit <a href="http://jnior.com" target="blank">jnior.com</a> for the latest documentation, direct access to INTEG designers, and 24/7 
						support.
						</p>
					<h3>Documentation</h3>
					<p>
						The JNIOR is configured through a series of Registry settings. The 
						<a href="RegistryDoc.html" target="dcphelp">Registry Key Assignments</a> document 
						describes all of the configuration settings. In many cases the WebUI will display the relavant Registry key when
						you hover over a setting in the Configuration section. Additional infrequently required settings may be found in the document. Note 
						that the current Registry content may be viewed with the REG command. The <code>/flash/jnior.ini</code> file serves as a backup. This
						file is auto-generated and must not be overwritten or modified.
					</p>
					<p>
						Applications are developed using Java and must be solely built against the JANOS runtime library <code>/etc/JanosClasses.jar</code>.
						An <u>extended JAR file</u> containing JavDoc and source detail is available by request. This is extrememly useful when used
						within a development environment. INTEG will fully support customers in	developing applications and can provide development
						services.
					</p>
					<p>
						For Web development JANOS implements a PHP-like server-side scripting facility. This offers a subset of PHP functionality. The
						details are fully	documented and available upon request.
					</p>
					<p>
						JANOS supports a built-in Websocket service providing real-time data and interaction. Documentation is also available upon
						request. The built-in Websocket replaces the JNIOR Protocol which remains available. Documentation for the legacy JNIOR Protocol can
						be supplied. JANOS provides for highly customizable network communications. External applications may communicate with
						applications running under JANOS which themselves can be developed as servers. Contact INTEG for details.
					</p>
					<h3>Timezone Corrections and Customization</h3>
					<p>
						JANOS includes a default set of timezones. If the timezone defined for your locale is inaccurate or missing, you may use a
						<a href="RegistryDoc.html#timezones" target="dcphelp">custom timezone</a>. If you need to adjust a timezone or create one,
						let us know. We may include the definition as a default in a future JANOS release.
						
					</p>
					<h3>Known WebUI Issues</h3>
					<p>
						Due to variations in browser technologies the following issues may be encountered. Results are best obtained using Chrome.
					</p>
					<ol>
						<li>
							Files may be dragged into but not out of the Folders tab when using Mozilla FireFox or Internet Explorer.
						</li>
						<li>
							Anonymous login cannot be fully achieved when using Internet Explorer.
						</li>
						<li>
							Resizing is not supported by Internet Explorer.
						</li>
					</ol>
					<p>
						INTEG welcomes all performance reports.
					</p>
				</div>
			</div>

			<div class="tabbed hide" id="regeditor">
				<div class='rmenu'><a href='' onclick='regrefresh();return(false);'>Refresh</a></div>
				<div class='rmenu'><a href='' onclick='newkey();return(false);'>New</a></div>
				<div class='rmenu'><a href='' onclick='regdelete();return(false);'>Delete</a></div>
				<div class='rmenur'><a href="RegistryDoc.html" target="dcphelp">Registry Documentation</a></div>
				<div id="regnode">?</div>
				<div id= "explore">
					<span id="Registry/" style="padding-left:0px;">
						<a href="" onclick='regexpand("");return(false);'>
							<img src='collapsed.png' width='10' height='10' />Registry
						</a>
					</span><br>
				</div>
				<div id="keydata"></div>
			</div>

			<div class="statusbar"><span id="helpcontext"></span></div>
	    <p id="clock" style='font-size:9px;padding-top:2px;position:absolute;left:15px;bottom:0;'></p>
	    <p style='font-size:9px;padding-top:2px;position:absolute;right:15px;bottom:0;'><?php=$appvers?></p>
		</div>

		<div id="newkey">
			<div>
				<p><b>Create/Edit Registry Key</b></p>
	          <br><p>Key: (Complete/Alter the key)</p>
	          <input type='text' id='nkkey'>
	          <br><p>Content: (Enter/Edit content)</p>
						<textarea id='nkdata' spellcheck="false"></textarea>
	        <br><br>
	        <center>
	        	<button onclick='newkeyOK()'>OK</button>
	        	<button onclick='newkey()'>Cancel</button>
	        </center>
			</div>
		</div>

		<div id="login">
			<div>
				<p><b>JNIOR requires login</b></p>
	          <br><p>Username:</p>
	          <input type='text' id='user'>
	          <br><p>Password:</p>
	          <input type='password' id='psw' onkeypress='loginkey(event);'>
	        <br><br>
	        	<button onclick='loginOK()'>OK</button>
			</div>
		</div>

		<div id="profile">
			<div>
				<p>Add new eMail Profile</p>
	          <p class='error' id='proferr'></p>
	          <br><p>Enter Profile Name:</p>
	          <input type='text' id='prof' onkeypress='profkey(event);'>
	        <br><br>
	        	<button onclick='profileOK()'>OK</button>
	        	<button onclick='profile()'>Cancel</button>
			</div>
		</div>

		<div id="overlay">
	     <div>
	          <p id='username'></p>
	          <p class='error' id='ovrerr'></p>
	          <br><p>Enter Password:</p>
	          <input type='password' id='psw1'>
	          <br><br><p>Reenter Password:</p>
	          <input type='password' id='psw2' onkeypress='psw2key(event);'>
	        <br><br>
	        	<button onclick='overlayOK()'>OK</button>
	        	<button onclick='overlayCancel()'>Cancel</button>
	     </div>
		</div>

		<div id="routa">
	    <div>

	     	Reassign 4ROUT Module with ID <span id='rident'></span> as
	    	<span id='rkey' style='display:none'></span>
	    	<?php
	     		if ($model == "412")
    			echo " ROUT 13-16?<br><br>";
	     		else {
     			echo "<div id='group'>";
	     			if ($model == "414")
	    			echo "<input type='radio' name='sex' id='btnB' value='B'> ROUT 5-8<br>";
	     			echo "<input type='radio' name='sex' id='btnC' value='C'> ROUT 9-12<br>";
	     			echo "<input type='radio' name='sex' id='btnD' value='D'> ROUT 13-16</div>";
	     		}
	     	?>
       	<button onclick='routaOK()'>OK</button>
       	<button onclick='routaCancel()'>Cancel</button>
	    </div>
		</div>

		<div id="setan">
	    <div>
	    	<span id='anchan' style='display:none'></span>
	    	<span id='ankey' style='display:none'></span>
	    	<p id='anident'><span id='anmodule'></span> (ID: <span id='anid'></span>)</p>
				<p id='ansetting'>Set <span id='anoutput'></span> to
      	<input type='number' id='anvalue'> <span id='anunits'></span></p>
       	<button onclick='setanOK()'>OK</button>
       	<button onclick='setanCancel()'>Cancel</button>
	    </div>
		</div>

		<div id="setdim">
	    <div>
	    	<p id='dmname'><b>LED Dimmer Settings</b></p>
	    	<p id='dmid'></p><br>
				<table class='dimset'>
					<tr id='dmctrl1r'>
						<td align='right'><span id='dmd1r'></span></td> 
		      	<td><input type='number' id='dmr' step='5.0' min='0' max='100'></td>
		      	<td>%</td>
		      	<td>
		      		<button onclick='setdm("dmr",0)'>0</button>
		      		<button onclick='setdm("dmr",10)'>10</button>
		      		<button onclick='setdm("dmr",25)'>25</button>
		      		<button onclick='setdm("dmr",50)'>50</button>
		      		<button onclick='setdm("dmr",75)'>75</button>
		      		<button onclick='setdm("dmr",100)'>100</button>
		      	</td>
	      	</tr>
					<tr id='dmctrl2g'>
						<td align='right'><span id='dmd2g'></span></td> 
		      	<td><input type='number' id='dmg' step='5.0' min='0' max='100'></td>
		      	<td>%</td>
		      	<td>
		      		<button onclick='setdm("dmg",0)'>0</button>
		      		<button onclick='setdm("dmg",10)'>10</button>
		      		<button onclick='setdm("dmg",25)'>25</button>
		      		<button onclick='setdm("dmg",50)'>50</button>
		      		<button onclick='setdm("dmg",75)'>75</button>
		      		<button onclick='setdm("dmg",100)'>100</button>
		      	</td>
	      	</tr>
					<tr id='dmctrl3b'>
						<td align='right'><span id='dmd3b'></span></td> 
		      	<td><input type='number' id='dmb' step='5.0' min='0' max='100'></td>
		      	<td>%</td>
		      	<td>
		      		<button onclick='setdm("dmb",0)'>0</button>
		      		<button onclick='setdm("dmb",10)'>10</button>
		      		<button onclick='setdm("dmb",25)'>25</button>
		      		<button onclick='setdm("dmb",50)'>50</button>
		      		<button onclick='setdm("dmb",75)'>75</button>
		      		<button onclick='setdm("dmb",100)'>100</button>
		      	</td>
	      	</tr>
					<tr>
						<td align='right'>Fade</td> 
		      	<td><input type='number' id='dmfade' step='0.5' min='0' max='30'></td>
		      	<td>Seconds</td>
		      	<td>
		      		<button onclick='setdm("dmfade",0)'>0</button>
		      		<button onclick='setdm("dmfade",0.5)'>0.5</button>
		      		<button onclick='setdm("dmfade",1)'>1</button>
		      		<button onclick='setdm("dmfade",2)'>2</button>
		      		<button onclick='setdm("dmfade",5)'>5</button>
		      		<button onclick='setdm("dmfade",10)'>10</button>
		      	</td>
	      	</tr>
	      </table><br>
       	<button onclick='setdimOK()'>OK</button>
       	<button onclick='setdimCancel()'>Cancel</button>
	    </div>
		</div>

		<div id="scratch"></div>
	</body>
</html>