 /*
  JNIOR Monitor/Configuration Page
  INTEG Process Group, Inc., 2919 E Hardies Rd, Gibsonia PA 
  724.933.9350
  
  File: dimmer.js
  
  The user is hereby granted license to use, modify, and redistribute the contents of this
  file for any purpose, commercial or otherwise. No prior authorization by INTEG Process 
  Group, Inc. is required.
*/ 

// true when control active (sliding)
var sliding_control = null;
var sliding_interval;
var pace_sliding = false;

// Function returns HMTL for the LED Dimmer
function device_dimmer(delem, key) {
	if (sliding_control != null)
		return;
	
	var ch = new Array("1R","2G","3B");
	var id = module_keyToId[key];

	var modkey = "externals/" + id.toLowerCase() + "/";
	var key = modkey + "desc";
	var desc = getkey(key, "LED Dimmer");
	
	var inner = "<td name='dimmer'>";
	inner += "<p class='modname'><span name='" + key + "'>" + desc + "</span></p>";
	inner += "<p class='modaddr'>" + id + "</p>";
	inner += "<div class='modio'>";
	
	inner += "<table class='dimmer'>";
	for (var n = 0; n < 4; n++) {
		var idn = "dim:" + n + ":" + id;
		var slider_idn = "slider:" + n + ":" + id;
		var color_idn = "color:" + id;
		
		inner += "<td class='dimmerset" + (n == 3 ? " sep" : "") + "'>";
		
		// each channel
		if (n < 3) {
			inner += "<table class='dimmerch'>";

			var chkey = modkey + "chan" + ch[n] + "/";
	
			// get input channel configuration details
			var desc_key = chkey + "desc";
			var desc_val = getkey(desc_key, "Channel " + ch[n]);
			var enab_key = chkey + "enable";
			var enab_val = istrue(getkey(enab_key, "enabled"));
			var enab_style = enab_val ? "" : " style='display:none'";

			var raw = parseInt(module_idToStatus[id].substring(4 * n, 4 * n + 4), 16);
			var reading = 100 * (raw / 0xfff0);
			var value = reading.toFixed(1);

			inner += "<tr" + enab_style + "><td class='dimname' name='" + keystd(desc_key) + "'>" + desc_val + "</td></tr>";
			inner += "<tr" + enab_style + "><td class='dimreading' id='" + idn + "'>" + value + "%</td></tr>";
			inner += "<tr" + enab_style + "><td class='dslide'>";
			if (jnior_control)
				inner+= "<input class='slider' id='" + slider_idn + "' type='range'" +	" value='" + (10*value) + 
						"' min='0' max='1000' onmousedown='sliding(event)' onmouseup='slid(event)'>";
			inner += "</td></tr>";
			inner += "</table>";
		}
		
		// tools panel when n is 4
		else {
			inner += "<table class='dimmertools'>";
			
			var color = "#";
			var raw = [];
			for (k = 0; k < 3; k++) {
				raw[k] = parseInt(module_idToStatus[id].substring(4 * k, 4 * k + 4), 16);
				val = Math.floor(255 * (raw[k] / 0xfff0));
				color += (val + 0x100).toString(16).substr(1);
			}
			if (jnior_control) {
				inner += "<tr><td>Color</td><td><input type='color' id='" + color_idn + "' name='" + color_idn + 
						"' size=6 value='" + color + "'" + " onchange='newcolor(event)' onkeydown='textKeydown(event)'></td></tr>";
				inner += "<tr><td>Advanced</td><td><button onclick='setDimmer(\"" + id + "\");'>Adjust</button></td></tr>"
			}
			inner += "</table>";
			snapText[color_idn] = color;
		}
		inner += "</td>";
	}
	inner += "</table>";
	inner += "</div>";
	inner += "</td>";
	delem.innerHTML = inner;
}

// Function updates LED Dimmer block content
function update_dimmer(key) {
	var id = module_keyToId[key];

	for (var n = 0; n < 4; n++) {
		var idn = "dim:" + n + ":" + id;
		var slider_idn = "slider:" + n + ":" + id;
		var color_idn = "color:" + id;
		var delem = document.getElementById(slider_idn);
		if (sliding_control != delem) {
			
			var elem = document.getElementById(idn);
			if (elem) {
				var raw = parseInt(module_idToStatus[id].substring(4 * n, 4 * n + 4), 16);
				var reading = 100 * (raw / 0xfff0);
				var value = reading.toFixed(1);
				elem.innerHTML = value + "%";
				delem.value = 10 * value;
			}
		}
	}

	var elem = document.getElementById(color_idn);
	if (elem && !elem.isTextEdit) {
		var color = "#";
		for (k = 0; k < 3; k++) {
			var raw = parseInt(module_idToStatus[id].substring(4 * k, 4 * k + 4), 16);
			var val = Math.floor(255 * (raw / 0xfff0));
			color += (val + 0x100).toString(16).substr(1);
		}
		elem.value = color;
		snapText[elem.name] = color;
	}
		
	return false;
}


// update color selection
function newcolor(evt) {
	var ctrl = evt.target.id.split(":");
	var id = ctrl[1];
	
	var color = evt.target.value;
	var red = Math.floor(1000 * parseInt(color.substr(1, 2), 16) / 255);
	var grn = Math.floor(1000 * parseInt(color.substr(3, 2), 16) / 255);
	var blu = Math.floor(1000 * parseInt(color.substr(5, 2), 16) / 255);
	
	var elem = document.getElementById("dim:0:" + id);
	if (elem)
		elem.innerHTML = (red / 10).toString();
	elem = document.getElementById("dim:1:" + id);
	if (elem)
		elem.innerHTML = (grn / 10).toString();
	elem = document.getElementById("dim:2:" + id);
	if (elem)
		elem.innerHTML = (blu / 10).toString();
		
	elem = document.getElementById("slider:0:" + id);
	if (elem)
		elem.value = red;
	elem = document.getElementById("slider:1:" + id);
	if (elem)
		elem.value = grn;
	elem = document.getElementById("slider:2:" + id);
	if (elem)
		elem.value = blu;

	var raw = Math.floor(0xfff0 * red / 1000) + 1;
	var block = (raw + 0x10000).toString(16).substr(1);
	raw = Math.floor(0xfff0 * grn / 1000) + 1;
	block += (raw + 0x10000).toString(16).substr(1);
	raw = Math.floor(0xfff0 * blu / 1000) + 1;
	block += (raw + 0x10000).toString(16).substr(1);
	block += "00000001000100010000";
	
	var device = new Object();
	device['Address'] = id;
	device['Hex'] = block;
	
	var request = new Object();
	request['Message'] = "Write Devices";
	request['Devices'] = new Array(device);
	chan.sendJson(request);	
	
	var request = new Object();
	request['Message'] = "Read Devices";
	request['Devices'] = new Array(id);
	chan.sendJson(request);	

	return false;
}

// update dimmer
function slid(evt) {
	// insure that the last write occurs
	pace_sliding = false;
	
	slide(evt);
	
	// allow all slider updates now
	sliding_control = null;
	clearInterval(sliding_interval);

	var ctrl = evt.target.id.split(":");
	var ch = ctrl[1];
	var id = ctrl[2];
	
	var request = new Object();
	request['Message'] = "Read Devices";
	request['Devices'] = new Array(id);
	chan.sendJson(request);	
}

function sliding(evt) {
	// prevent slider updates while we are manipulating it
	sliding_control = evt.target;
	sliding_interval = setInterval(slide, 100);
}

// update dimmer
function slide() {
	
	var ctrl = sliding_control.id.split(":");
	var val = sliding_control.value;
	
	var ch = ctrl[1];
	var id = ctrl[2];
	var idn = "dim:" + ch + ":" + id;
	var color_idn = "color:" + id;

	var raw = Math.floor(0xfff0 * val / 1000) + 1;
	var hex = (raw + 0x10000).toString(16).substr(1);
	var block = "000000000000".substr(0, 4*ch) + hex + "000000000000".substr(0, 4*(3-ch)) +
			"000000000000".substr(0, 4*ch) + "0001" + "000000000000".substr(0, 4*(3-ch));
	
	var value = val/10;
	var elem = document.getElementById(idn);
	if (elem)
		elem.innerHTML = value.toFixed(1) + "%";
	
	var picker = document.getElementById(color_idn);
	if (picker) {
		var status = module_idToStatus[id];
		var updated = status.substr(0, 4*ch) + hex + status.substr(4 + 4 * ch);
		var color = "#";
		for (k = 0; k < 3; k++) {
			var raw = parseInt(updated.substring(4 * k, 4 * k + 4), 16);
			var val = Math.floor(255 * (raw / 0xfff0));
			color += (val + 0x100).toString(16).substr(1);
		}
		picker.value = color;
		snapText[picker.name] = color;
	}

	// pace messages
	if (pace_sliding)
		return false;
	pace_sliding = true;
	
	var device = new Object();
	device['Address'] = id;
	device['Hex'] = block;
	
	var request = new Object();
	request['Message'] = "Write Devices";
	request['Devices'] = new Array(device);
	chan.sendJson(request);	
}

// LED Dimmer adjustment dialog
function setDimmer(id) {
	document.getElementById('dmid').innerHTML = id;

	var modkey = "externals/" + id.toLowerCase() + "/";
	var key = modkey + "desc";
	var desc = getkey(key, "LED Dimmer");
	document.getElementById('dmname').innerHTML = "<b>" + desc + " Settings</b>";
	document.getElementById('dmid').innerHTML = id;

	var desc_key = modkey + "chan1R/desc";
	var desc_val = getkey(desc_key, "Channel 1R");
	document.getElementById('dmd1r').innerHTML = desc_val;

	desc_key = modkey + "chan2G/desc";
	desc_val = getkey(desc_key, "Channel 2G");
	document.getElementById('dmd2g').innerHTML = desc_val;

	desc_key = modkey + "chan3B/desc";
	desc_val = getkey(desc_key, "Channel 3B");
	document.getElementById('dmd3b').innerHTML = desc_val;
	
	var enab_key = modkey + "chan1r/enable";
	var enab_val = istrue(getkey(enab_key, "enabled"));
	document.getElementById('dmctrl1r').style.display = enab_val ? "" : "none";
	
	var enab_key = modkey + "chan2g/enable";
	var enab_val = istrue(getkey(enab_key, "enabled"));
	document.getElementById('dmctrl2g').style.display = enab_val ? "" : "none";
	
	var enab_key = modkey + "chan3b/enable";
	var enab_val = istrue(getkey(enab_key, "enabled"));
	document.getElementById('dmctrl3b').style.display = enab_val ? "" : "none";
	
	document.getElementById('dmr').value = document.getElementById("slider:0:" + id).value/10;
	document.getElementById('dmg').value = document.getElementById("slider:1:" + id).value/10;
	document.getElementById('dmb').value = document.getElementById("slider:2:" + id).value/10;
	document.getElementById('dmfade').value = 0;
	setdim();
	return false;
}

function setdm(id,val) {
	document.getElementById(id).value = val;
}

// Toggles visibility of the External Analog setting dialog
function setdim() {
	el = document.getElementById('setdim');
	el.style.display = getComputedStyle(el).getPropertyValue('display') == "none" ? "inherit" : "none";
}

// Clicked Cancel. Hide popup.
function setdimCancel() {
	setdim();
}

// Clicked OK. Determines action and does it. Popup is hidden.
function setdimOK() {
	id = document.getElementById('dmid').innerHTML;
	r = document.getElementById('dmr').value;
	g = document.getElementById('dmg').value;
	b = document.getElementById('dmb').value;
	fade = document.getElementById('dmfade').value;
	
	raw = Math.floor(0xfff0 * r / 100) + 1;
	block = (raw + 0x10000).toString(16).substr(1);
	raw = Math.floor(0xfff0 * g / 100) + 1;
	block += (raw + 0x10000).toString(16).substr(1);
	raw = Math.floor(0xfff0 * b / 100) + 1;
	block += (raw + 0x10000).toString(16).substr(1);
	block += "0000";
	raw = 1000 * fade + 1;
	block += (raw + 0x10000).toString(16).substr(1);
	block += (raw + 0x10000).toString(16).substr(1);
	block += (raw + 0x10000).toString(16).substr(1);
	block += "0000";
		
	setdim();
	
	var device = new Object();
	device['Address'] = id;
	device['Hex'] = block;
	
	var request = new Object();
	request['Message'] = "Write Devices";
	request['Devices'] = new Array(device);
	chan.sendJson(request);	
	
	var request = new Object();
	request['Message'] = "Read Devices";
	request['Devices'] = new Array(id);
	chan.sendJson(request);	

}