 /*
  JNIOR Monitor/Configuration Page
  INTEG Process Group, Inc., 2919 E Hardies Rd, Gibsonia PA 
  724.933.9350
  
  File: tabs.js
  
  Javascript to support the tabs and display selection on the main page. This goes along
  with the tabs-styles.css stylesheet.
  
  The user is hereby granted license to use, modify, and redistribute the contents of this
  file for any purpose, commercial or otherwise. No prior authorization by INTEG Process 
  Group, Inc. is required.
*/

// tabs & sets
var tabLinks = new Array();
var contentDivs = new Array();
var setLinks = new Array();
var setDivs = new Array();
var setIoLinks = new Array();
var setIoDivs = new Array();

function showTab() {
  var selectedId = getHash( this.getAttribute('href') );

  // Highlight the selected tab, and dim all others.
  // Also show the selected content div, and hide all others.
  for ( var id in contentDivs ) {
    if ( id == selectedId ) {
      tabLinks[id].className = 'selected';
      contentDivs[id].className = 'tabbed';
      if (selectedId == 'console') {
      	var screen = document.getElementById('screen');
      	if (connected) {
	  screen.focus();
	  screen.setSelectionRange(caret, caret);
      	}
      	else
      	  document.getElementById('open').focus();
      }
    } else {
      tabLinks[id].className = '';
      contentDivs[id].className = 'tabbed hide';
    }
  }
  
  // Stop the browser following the link
  return false;
}

function showSet() {
  var selectedId = getHash( this.getAttribute('href') );

  // Highlight the selected set, and dim all others.
  // Also show the selected set div, and hide all others.
  for ( var id in setDivs ) {
    if ( id == selectedId ) {
      setLinks[id].className = 'selected';
      setDivs[id].className = 'sets';
    } else {
      setLinks[id].className = '';
      setDivs[id].className = 'sets hide';
    }
  }
    
  // Stop the browser following the link
  return false;
}
  
function showIoSet() {
  var selectedId = getHash( this.getAttribute('href') );

  // Highlight the selected set, and dim all others.
  // Also show the selected set div, and hide all others.
  for ( var id in setIoDivs ) {
    if ( id == selectedId ) {
      setIoLinks[id].className = 'selected';
      setIoDivs[id].className = 'iosettings';
    } else {
      setIoLinks[id].className = '';
      setIoDivs[id].className = 'iosettings hide';
    }
  }
    
  // Stop the browser following the link
  return false;
}
  
function getFirstChildWithTagName( element, tagName ) {
  for ( var i = 0; i < element.childNodes.length; i++ ) {
    if ( element.childNodes[i].nodeName == tagName ) return element.childNodes[i];
  }
}
  
function getHash( url ) {
  var hashPos = url.lastIndexOf ( '#' );
  return url.substring( hashPos + 1 );
}

function tabinit() {
  // Grab the tab links and content divs from the page
  var tabListItems = document.getElementById('tabs').childNodes;
  for ( var i = 0; i < tabListItems.length; i++ ) {
    if ( tabListItems[i].nodeName == "LI" ) {
      var tabLink = getFirstChildWithTagName( tabListItems[i], 'A' );
      var id = getHash( tabLink.getAttribute('href') );
      tabLinks[id] = tabLink;
      contentDivs[id] = document.getElementById( id );
    }
  }

  // Assign onclick events to the tab links, and
  // highlight the first tab
  var i = 0;

  for ( var id in tabLinks ) {
    tabLinks[id].onclick = showTab;
    tabLinks[id].onfocus = function() { this.blur() };
    if ( i == 0 ) tabLinks[id].className = 'selected';
    i++;
  }

  // Hide all content divs except the first
  var i = 0;

  for ( var id in contentDivs ) {
    if ( i != 0 ) contentDivs[id].className = 'tabbed hide';
    i++;
  }

  // Grab the set links and content divs from the page
  var setListItems = document.getElementById('sets').childNodes;
  for ( var i = 0; i < setListItems.length; i++ ) {
    if ( setListItems[i].nodeName == "LI" ) {
      var setLink = getFirstChildWithTagName( setListItems[i], 'A' );
      var id = getHash( setLink.getAttribute('href') );
      setLinks[id] = setLink;
      setDivs[id] = document.getElementById( id );
    }
  }

  // Grab the ioset links and content divs from the page
  var setListItems = document.getElementById('iosets').childNodes;
  for ( var i = 0; i < setListItems.length; i++ ) {
    if ( setListItems[i].nodeName == "LI" ) {
      var setLink = getFirstChildWithTagName( setListItems[i], 'A' );
      var id = getHash( setLink.getAttribute('href') );
      setIoLinks[id] = setLink;
      setIoDivs[id] = document.getElementById( id );
    }
  }

  // Assign onclick events to the set links, and
  // highlight the first set
  var i = 0;
  for ( var id in setLinks ) {
    setLinks[id].onclick = showSet;
    setLinks[id].onfocus = function() { this.blur() };
    if ( i == 0 ) setLinks[id].className = 'selected';
    i++;
  }

  // Hide all content divs except the first
  var i = 0;
   for ( var id in setDivs ) {
    if ( i != 0 ) setDivs[id].className = 'sets hide';
    i++;
  }

  var i = 0;
  for ( var id in setIoLinks ) {
    setIoLinks[id].onclick = showIoSet;
    setIoLinks[id].onfocus = function() { this.blur() };
    if ( i == 0 ) setIoLinks[id].className = 'selected';
    i++;
  }

  // Hide all content divs except the first
  var i = 0;
   for ( var id in setIoDivs ) {
    if ( i != 0 ) setIoDivs[id].className = 'iosettings hide';
    i++;
  }
}    

